/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.model;

import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.ConstantCurve;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveInfoType;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.ParameterizedData;
import com.opengamma.strata.market.param.ParameterizedDataCombiner;
import com.opengamma.strata.pricer.model.SabrVolatilityFormula;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
public final class SabrParameters
implements ParameterizedData,
ImmutableBean,
Serializable {
    private static final ConstantCurve ZERO_SHIFT = ConstantCurve.of((String)"Zero shift", (double)0.0);
    @PropertyDefinition(validate="notNull")
    private final Curve alphaCurve;
    @PropertyDefinition(validate="notNull")
    private final Curve betaCurve;
    @PropertyDefinition(validate="notNull")
    private final Curve rhoCurve;
    @PropertyDefinition(validate="notNull")
    private final Curve nuCurve;
    @PropertyDefinition(validate="notNull")
    private final Curve shiftCurve;
    @PropertyDefinition(validate="notNull")
    private final SabrVolatilityFormula sabrVolatilityFormula;
    private final transient DayCount dayCount;
    private final transient ParameterizedDataCombiner paramCombiner;
    private static final TypedMetaBean<SabrParameters> META_BEAN = LightMetaBean.of(SabrParameters.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"alphaCurve", "betaCurve", "rhoCurve", "nuCurve", "shiftCurve", "sabrVolatilityFormula"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    public static SabrParameters of(Curve alphaCurve, Curve betaCurve, Curve rhoCurve, Curve nuCurve, SabrVolatilityFormula sabrFormula) {
        return new SabrParameters(alphaCurve, betaCurve, rhoCurve, nuCurve, (Curve)ZERO_SHIFT, sabrFormula);
    }

    public static SabrParameters of(Curve alphaCurve, Curve betaCurve, Curve rhoCurve, Curve nuCurve, Curve shiftCurve, SabrVolatilityFormula sabrFormula) {
        return new SabrParameters(alphaCurve, betaCurve, rhoCurve, nuCurve, shiftCurve, sabrFormula);
    }

    @ImmutableConstructor
    private SabrParameters(Curve alphaCurve, Curve betaCurve, Curve rhoCurve, Curve nuCurve, Curve shiftCurve, SabrVolatilityFormula sabrFormula) {
        SabrParameters.validate(alphaCurve, "alphaCurve", ValueType.SABR_ALPHA);
        SabrParameters.validate(betaCurve, "betaCurve", ValueType.SABR_BETA);
        SabrParameters.validate(rhoCurve, "rhoCurve", ValueType.SABR_RHO);
        SabrParameters.validate(nuCurve, "nuCurve", ValueType.SABR_NU);
        ArgChecker.notNull((Object)shiftCurve, (String)"shiftCurve");
        ArgChecker.notNull((Object)sabrFormula, (String)"sabrFormula");
        DayCount dayCount = (DayCount)alphaCurve.getMetadata().findInfo(CurveInfoType.DAY_COUNT).orElseThrow(() -> new IllegalArgumentException("Incorrect curve metadata, missing DayCount"));
        SabrParameters.validate(betaCurve, dayCount);
        SabrParameters.validate(rhoCurve, dayCount);
        SabrParameters.validate(nuCurve, dayCount);
        SabrParameters.validate(shiftCurve, dayCount);
        this.alphaCurve = alphaCurve;
        this.betaCurve = betaCurve;
        this.rhoCurve = rhoCurve;
        this.nuCurve = nuCurve;
        this.shiftCurve = shiftCurve;
        this.sabrVolatilityFormula = sabrFormula;
        this.dayCount = dayCount;
        this.paramCombiner = ParameterizedDataCombiner.of((ParameterizedData[])new ParameterizedData[]{alphaCurve, betaCurve, rhoCurve, nuCurve, shiftCurve});
    }

    private static void validate(Curve curve, String name, ValueType yType) {
        ArgChecker.notNull((Object)curve, (String)name);
        curve.getMetadata().getXValueType().checkEquals(ValueType.YEAR_FRACTION, "Incorrect x-value type for SABR volatilities");
        ValueType yValueType = curve.getMetadata().getYValueType();
        yValueType.checkEquals(yType, "Incorrect y-value type for SABR volatilities");
    }

    private static void validate(Curve curve, DayCount dayCount) {
        if (!curve.getMetadata().findInfo(CurveInfoType.DAY_COUNT).orElse(dayCount).equals(dayCount)) {
            throw new IllegalArgumentException("SABR curves must have the same day count");
        }
    }

    private Object readResolve() {
        return new SabrParameters(this.alphaCurve, this.betaCurve, this.rhoCurve, this.nuCurve, this.shiftCurve, this.sabrVolatilityFormula);
    }

    public DayCount getDayCount() {
        return this.dayCount;
    }

    public int getParameterCount() {
        return this.paramCombiner.getParameterCount();
    }

    public double getParameter(int parameterIndex) {
        return this.paramCombiner.getParameter(parameterIndex);
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.paramCombiner.getParameterMetadata(parameterIndex);
    }

    public SabrParameters withParameter(int parameterIndex, double newValue) {
        return new SabrParameters((Curve)this.paramCombiner.underlyingWithParameter(0, Curve.class, parameterIndex, newValue), (Curve)this.paramCombiner.underlyingWithParameter(1, Curve.class, parameterIndex, newValue), (Curve)this.paramCombiner.underlyingWithParameter(2, Curve.class, parameterIndex, newValue), (Curve)this.paramCombiner.underlyingWithParameter(3, Curve.class, parameterIndex, newValue), (Curve)this.paramCombiner.underlyingWithParameter(4, Curve.class, parameterIndex, newValue), this.sabrVolatilityFormula);
    }

    public SabrParameters withPerturbation(ParameterPerturbation perturbation) {
        return new SabrParameters((Curve)this.paramCombiner.underlyingWithPerturbation(0, Curve.class, perturbation), (Curve)this.paramCombiner.underlyingWithPerturbation(1, Curve.class, perturbation), (Curve)this.paramCombiner.underlyingWithPerturbation(2, Curve.class, perturbation), (Curve)this.paramCombiner.underlyingWithPerturbation(3, Curve.class, perturbation), (Curve)this.paramCombiner.underlyingWithPerturbation(4, Curve.class, perturbation), this.sabrVolatilityFormula);
    }

    public double alpha(double expiry) {
        return this.alphaCurve.yValue(expiry);
    }

    public double beta(double expiry) {
        return this.betaCurve.yValue(expiry);
    }

    public double rho(double expiry) {
        return this.rhoCurve.yValue(expiry);
    }

    public double nu(double expiry) {
        return this.nuCurve.yValue(expiry);
    }

    public double shift(double expiry) {
        return this.shiftCurve.yValue(expiry);
    }

    public double volatility(double expiry, double strike, double forward) {
        double alpha = this.alpha(expiry);
        double beta = this.beta(expiry);
        double rho = this.rho(expiry);
        double nu = this.nu(expiry);
        double shift = this.shift(expiry);
        return this.sabrVolatilityFormula.volatility(forward + shift, strike + shift, expiry, alpha, beta, rho, nu);
    }

    public ValueDerivatives volatilityAdjoint(double expiry, double strike, double forward) {
        double alpha = this.alpha(expiry);
        double beta = this.beta(expiry);
        double rho = this.rho(expiry);
        double nu = this.nu(expiry);
        double shift = this.shift(expiry);
        return this.sabrVolatilityFormula.volatilityAdjoint(forward + shift, strike + shift, expiry, alpha, beta, rho, nu);
    }

    public static TypedMetaBean<SabrParameters> meta() {
        return META_BEAN;
    }

    public TypedMetaBean<SabrParameters> metaBean() {
        return META_BEAN;
    }

    public Curve getAlphaCurve() {
        return this.alphaCurve;
    }

    public Curve getBetaCurve() {
        return this.betaCurve;
    }

    public Curve getRhoCurve() {
        return this.rhoCurve;
    }

    public Curve getNuCurve() {
        return this.nuCurve;
    }

    public Curve getShiftCurve() {
        return this.shiftCurve;
    }

    public SabrVolatilityFormula getSabrVolatilityFormula() {
        return this.sabrVolatilityFormula;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SabrParameters other = (SabrParameters)obj;
            return JodaBeanUtils.equal((Object)this.alphaCurve, (Object)other.alphaCurve) && JodaBeanUtils.equal((Object)this.betaCurve, (Object)other.betaCurve) && JodaBeanUtils.equal((Object)this.rhoCurve, (Object)other.rhoCurve) && JodaBeanUtils.equal((Object)this.nuCurve, (Object)other.nuCurve) && JodaBeanUtils.equal((Object)this.shiftCurve, (Object)other.shiftCurve) && JodaBeanUtils.equal((Object)this.sabrVolatilityFormula, (Object)other.sabrVolatilityFormula);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.alphaCurve);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.betaCurve);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rhoCurve);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.nuCurve);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.shiftCurve);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.sabrVolatilityFormula);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(224);
        buf.append("SabrParameters{");
        buf.append("alphaCurve").append('=').append(JodaBeanUtils.toString((Object)this.alphaCurve)).append(',').append(' ');
        buf.append("betaCurve").append('=').append(JodaBeanUtils.toString((Object)this.betaCurve)).append(',').append(' ');
        buf.append("rhoCurve").append('=').append(JodaBeanUtils.toString((Object)this.rhoCurve)).append(',').append(' ');
        buf.append("nuCurve").append('=').append(JodaBeanUtils.toString((Object)this.nuCurve)).append(',').append(' ');
        buf.append("shiftCurve").append('=').append(JodaBeanUtils.toString((Object)this.shiftCurve)).append(',').append(' ');
        buf.append("sabrVolatilityFormula").append('=').append(JodaBeanUtils.toString((Object)this.sabrVolatilityFormula));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

