/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.option;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.pricer.option.RawOptionData;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.SortedMap;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
public final class TenorRawOptionData
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final ImmutableSortedMap<Tenor, RawOptionData> data;
    private static final TypedMetaBean<TenorRawOptionData> META_BEAN = LightMetaBean.of(TenorRawOptionData.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"data"}, (Object[])new Object[]{ImmutableSortedMap.of()});
    private static final long serialVersionUID = 1L;

    public static TenorRawOptionData of(Map<Tenor, RawOptionData> data) {
        return new TenorRawOptionData((SortedMap<Tenor, RawOptionData>)ImmutableSortedMap.copyOf(data));
    }

    public ImmutableSet<Tenor> getTenors() {
        return this.data.keySet();
    }

    public RawOptionData getData(Tenor tenor) {
        RawOptionData result = (RawOptionData)this.data.get((Object)tenor);
        if (result == null) {
            throw new IllegalArgumentException("No data found for tenor " + tenor);
        }
        return result;
    }

    public static TypedMetaBean<TenorRawOptionData> meta() {
        return META_BEAN;
    }

    private TenorRawOptionData(SortedMap<Tenor, RawOptionData> data) {
        JodaBeanUtils.notNull(data, (String)"data");
        this.data = ImmutableSortedMap.copyOfSorted(data);
    }

    public TypedMetaBean<TenorRawOptionData> metaBean() {
        return META_BEAN;
    }

    public ImmutableSortedMap<Tenor, RawOptionData> getData() {
        return this.data;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            TenorRawOptionData other = (TenorRawOptionData)obj;
            return JodaBeanUtils.equal(this.data, other.data);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.data);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("TenorRawOptionData{");
        buf.append("data").append('=').append(JodaBeanUtils.toString(this.data));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

