/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.rate;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.IborIndexObservation;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.market.MarketDataView;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.ParameterizedData;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.rate.DiscountIborIndexRates;
import com.opengamma.strata.pricer.rate.IborRateSensitivity;
import com.opengamma.strata.pricer.rate.SimpleIborIndexRates;
import java.time.LocalDate;
import java.util.function.Consumer;

public interface IborIndexRates
extends MarketDataView,
ParameterizedData {
    public static IborIndexRates of(IborIndex index, LocalDate valuationDate, Curve forwardCurve) {
        return IborIndexRates.of(index, valuationDate, forwardCurve, LocalDateDoubleTimeSeries.empty());
    }

    public static IborIndexRates of(IborIndex index, LocalDate valuationDate, Curve forwardCurve, LocalDateDoubleTimeSeries fixings) {
        if (forwardCurve.getMetadata().getYValueType().equals((Object)ValueType.FORWARD_RATE)) {
            return SimpleIborIndexRates.of(index, valuationDate, forwardCurve, fixings);
        }
        DiscountFactors discountFactors = DiscountFactors.of(index.getCurrency(), valuationDate, forwardCurve);
        return DiscountIborIndexRates.of(index, discountFactors, fixings);
    }

    public IborIndex getIndex();

    public LocalDateDoubleTimeSeries getFixings();

    public IborIndexRates withParameter(int var1, double var2);

    public IborIndexRates withPerturbation(ParameterPerturbation var1);

    public double rate(IborIndexObservation var1);

    public double rateIgnoringFixings(IborIndexObservation var1);

    public PointSensitivityBuilder ratePointSensitivity(IborIndexObservation var1);

    public PointSensitivityBuilder rateIgnoringFixingsPointSensitivity(IborIndexObservation var1);

    default public double explainRate(IborIndexObservation observation, ExplainMapBuilder builder, Consumer<ExplainMapBuilder> consumer) {
        LocalDate fixingDate = observation.getFixingDate();
        double rate = this.rate(observation);
        ExplainMapBuilder child = builder.openListEntry(ExplainKey.OBSERVATIONS);
        child.put(ExplainKey.ENTRY_TYPE, (Object)"IborIndexObservation");
        child.put(ExplainKey.FIXING_DATE, (Object)fixingDate);
        child.put(ExplainKey.INDEX, (Object)observation.getIndex());
        child.put(ExplainKey.FORWARD_RATE_START_DATE, (Object)observation.getEffectiveDate());
        child.put(ExplainKey.FORWARD_RATE_END_DATE, (Object)observation.getMaturityDate());
        child.put(ExplainKey.INDEX_VALUE, (Object)rate);
        if (fixingDate.isBefore(this.getValuationDate()) || fixingDate.equals(this.getValuationDate()) && this.getFixings().containsDate(fixingDate)) {
            child.put(ExplainKey.FROM_FIXING_SERIES, (Object)true);
        }
        consumer.accept(child);
        child.closeListEntry(ExplainKey.OBSERVATIONS);
        return rate;
    }

    public CurrencyParameterSensitivities parameterSensitivity(IborRateSensitivity var1);

    public CurrencyParameterSensitivities createParameterSensitivity(Currency var1, DoubleArray var2);
}

