/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.rate;

import com.google.common.collect.ComparisonChain;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.IborIndexObservation;
import com.opengamma.strata.market.sensitivity.MutablePointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.DoubleUnaryOperator;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class IborRateSensitivity
implements PointSensitivity,
PointSensitivityBuilder,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final IborIndexObservation observation;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    @PropertyDefinition(overrideGet=true)
    private final double sensitivity;
    private static final long serialVersionUID = 1L;

    public static IborRateSensitivity of(IborIndexObservation observation, double sensitivity) {
        return new IborRateSensitivity(observation, observation.getIndex().getCurrency(), sensitivity);
    }

    public static IborRateSensitivity of(IborIndexObservation observation, Currency sensitivityCurrency, double sensitivity) {
        return new IborRateSensitivity(observation, sensitivityCurrency, sensitivity);
    }

    public IborIndex getIndex() {
        return this.observation.getIndex();
    }

    public IborRateSensitivity withCurrency(Currency currency) {
        if (this.currency.equals((Object)currency)) {
            return this;
        }
        return new IborRateSensitivity(this.observation, currency, this.sensitivity);
    }

    public IborRateSensitivity withSensitivity(double sensitivity) {
        return new IborRateSensitivity(this.observation, this.currency, sensitivity);
    }

    public int compareKey(PointSensitivity other) {
        if (other instanceof IborRateSensitivity) {
            IborRateSensitivity otherIbor = (IborRateSensitivity)other;
            return ComparisonChain.start().compare((Comparable)((Object)this.getIndex().toString()), (Comparable)((Object)otherIbor.getIndex().toString())).compare((Comparable)this.currency, (Comparable)otherIbor.currency).compare((Comparable)this.observation.getFixingDate(), (Comparable)otherIbor.observation.getFixingDate()).result();
        }
        return this.getClass().getSimpleName().compareTo(other.getClass().getSimpleName());
    }

    public IborRateSensitivity convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        return (IborRateSensitivity)super.convertedTo(resultCurrency, rateProvider);
    }

    public IborRateSensitivity multipliedBy(double factor) {
        return new IborRateSensitivity(this.observation, this.currency, this.sensitivity * factor);
    }

    public IborRateSensitivity mapSensitivity(DoubleUnaryOperator operator) {
        return new IborRateSensitivity(this.observation, this.currency, operator.applyAsDouble(this.sensitivity));
    }

    public IborRateSensitivity normalize() {
        return this;
    }

    public MutablePointSensitivities buildInto(MutablePointSensitivities combination) {
        return combination.add((PointSensitivity)this);
    }

    public IborRateSensitivity cloned() {
        return this;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private IborRateSensitivity(IborIndexObservation observation, Currency currency, double sensitivity) {
        JodaBeanUtils.notNull((Object)observation, (String)"observation");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        this.observation = observation;
        this.currency = currency;
        this.sensitivity = sensitivity;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public IborIndexObservation getObservation() {
        return this.observation;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public double getSensitivity() {
        return this.sensitivity;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IborRateSensitivity other = (IborRateSensitivity)obj;
            return JodaBeanUtils.equal((Object)this.observation, (Object)other.observation) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.sensitivity, (double)other.sensitivity);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.observation);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.sensitivity);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("IborRateSensitivity{");
        buf.append("observation").append('=').append(JodaBeanUtils.toString((Object)this.observation)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<IborRateSensitivity> {
        private IborIndexObservation observation;
        private Currency currency;
        private double sensitivity;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    return this.observation;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    this.observation = (IborIndexObservation)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 564403871: {
                    this.sensitivity = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public IborRateSensitivity build() {
            return new IborRateSensitivity(this.observation, this.currency, this.sensitivity);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("IborRateSensitivity.Builder{");
            buf.append("observation").append('=').append(JodaBeanUtils.toString((Object)this.observation)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<IborIndexObservation> observation = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"observation", IborRateSensitivity.class, IborIndexObservation.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", IborRateSensitivity.class, Currency.class);
        private final MetaProperty<Double> sensitivity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sensitivity", IborRateSensitivity.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"observation", "currency", "sensitivity"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    return this.observation;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends IborRateSensitivity> builder() {
            return new Builder();
        }

        public Class<? extends IborRateSensitivity> beanType() {
            return IborRateSensitivity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<IborIndexObservation> observation() {
            return this.observation;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> sensitivity() {
            return this.sensitivity;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    return ((IborRateSensitivity)bean).getObservation();
                }
                case 575402001: {
                    return ((IborRateSensitivity)bean).getCurrency();
                }
                case 564403871: {
                    return ((IborRateSensitivity)bean).getSensitivity();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

