/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.rate;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxMatrix;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.basics.index.FxIndex;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.basics.index.PriceIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveGroupName;
import com.opengamma.strata.market.curve.CurveId;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.fx.DiscountFxForwardRates;
import com.opengamma.strata.pricer.fx.ForwardFxIndexRates;
import com.opengamma.strata.pricer.fx.FxForwardRates;
import com.opengamma.strata.pricer.fx.FxIndexRates;
import com.opengamma.strata.pricer.rate.HistoricIborIndexRates;
import com.opengamma.strata.pricer.rate.HistoricOvernightIndexRates;
import com.opengamma.strata.pricer.rate.HistoricPriceIndexValues;
import com.opengamma.strata.pricer.rate.IborIndexRates;
import com.opengamma.strata.pricer.rate.ImmutableRatesProviderBuilder;
import com.opengamma.strata.pricer.rate.OvernightIndexRates;
import com.opengamma.strata.pricer.rate.PriceIndexValues;
import com.opengamma.strata.pricer.rate.RatesProvider;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private", constructorScope="package")
public final class ImmutableRatesProvider
implements RatesProvider,
ImmutableBean,
Serializable {
    private static final long serialVersionUID = 1L;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDate valuationDate;
    @PropertyDefinition(validate="notNull")
    private final FxRateProvider fxRateProvider;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<Currency, Curve> discountCurves;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<Index, Curve> indexCurves;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<Index, LocalDateDoubleTimeSeries> timeSeries;

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.fxRateProvider = (FxRateProvider)FxMatrix.empty();
    }

    public static ImmutableRatesProvider combined(FxRateProvider fx, ImmutableRatesProvider ... providers) {
        ArgChecker.isTrue((providers.length > 0 ? 1 : 0) != 0, (String)"at least one provider requested");
        ImmutableRatesProvider merged = ImmutableRatesProvider.builder(providers[0].getValuationDate()).build();
        for (ImmutableRatesProvider provider : providers) {
            merged = merged.combinedWith(provider, fx);
        }
        return merged;
    }

    public static ImmutableRatesProviderBuilder builder(LocalDate valuationDate) {
        return new ImmutableRatesProviderBuilder(valuationDate);
    }

    public ImmutableRatesProviderBuilder toBuilder() {
        return new ImmutableRatesProviderBuilder(this.valuationDate).fxRateProvider(this.fxRateProvider).discountCurves((Map<Currency, ? extends Curve>)this.discountCurves).indexCurves((Map<? extends Index, ? extends Curve>)this.indexCurves).timeSeries((Map<? extends Index, LocalDateDoubleTimeSeries>)this.timeSeries);
    }

    public ImmutableSet<Currency> getDiscountCurrencies() {
        return this.discountCurves.keySet();
    }

    @Override
    public Stream<Index> indices() {
        return this.indexCurves.keySet().stream();
    }

    public ImmutableSet<IborIndex> getIborIndices() {
        return (ImmutableSet)this.indexCurves.keySet().stream().flatMap(Guavate.filtering(IborIndex.class)).collect(Guavate.toImmutableSet());
    }

    public ImmutableSet<OvernightIndex> getOvernightIndices() {
        return (ImmutableSet)this.indexCurves.keySet().stream().flatMap(Guavate.filtering(OvernightIndex.class)).collect(Guavate.toImmutableSet());
    }

    public ImmutableSet<PriceIndex> getPriceIndices() {
        return (ImmutableSet)this.indexCurves.keySet().stream().flatMap(Guavate.filtering(PriceIndex.class)).collect(Guavate.toImmutableSet());
    }

    public ImmutableSet<Index> getTimeSeriesIndices() {
        return this.timeSeries.keySet();
    }

    @Override
    public <T> Optional<T> findData(MarketDataName<T> name) {
        if (name instanceof CurveName) {
            return Stream.concat(this.discountCurves.values().stream(), this.indexCurves.values().stream()).filter(c -> c.getName().equals((Object)name)).map(v -> name.getMarketDataType().cast(v)).findFirst();
        }
        return Optional.empty();
    }

    @Override
    public <T> T data(MarketDataId<T> id) {
        throw new IllegalArgumentException("Unknown identifier: " + id.toString());
    }

    @Override
    public LocalDateDoubleTimeSeries timeSeries(Index index) {
        return (LocalDateDoubleTimeSeries)this.timeSeries.getOrDefault((Object)index, (Object)LocalDateDoubleTimeSeries.empty());
    }

    @Override
    public double fxRate(Currency baseCurrency, Currency counterCurrency) {
        return this.fxRateProvider.fxRate(baseCurrency, counterCurrency);
    }

    @Override
    public DiscountFactors discountFactors(Currency currency) {
        Curve curve = (Curve)this.discountCurves.get((Object)currency);
        if (curve == null) {
            throw new IllegalArgumentException("Unable to find discount curve: " + currency);
        }
        return DiscountFactors.of(currency, this.valuationDate, curve);
    }

    @Override
    public FxIndexRates fxIndexRates(FxIndex index) {
        LocalDateDoubleTimeSeries fixings = this.timeSeries((Index)index);
        FxForwardRates fxForwardRates = this.fxForwardRates(index.getCurrencyPair());
        return ForwardFxIndexRates.of(index, fxForwardRates, fixings);
    }

    @Override
    public FxForwardRates fxForwardRates(CurrencyPair currencyPair) {
        DiscountFactors base = this.discountFactors(currencyPair.getBase());
        DiscountFactors counter = this.discountFactors(currencyPair.getCounter());
        return DiscountFxForwardRates.of(currencyPair, this.fxRateProvider, base, counter);
    }

    @Override
    public IborIndexRates iborIndexRates(IborIndex index) {
        Curve curve = (Curve)this.indexCurves.get((Object)index);
        if (curve == null) {
            return this.historicCurve(index);
        }
        return IborIndexRates.of(index, this.valuationDate, curve, this.timeSeries((Index)index));
    }

    private IborIndexRates historicCurve(IborIndex index) {
        LocalDateDoubleTimeSeries fixings = this.timeSeries((Index)index);
        if (index.isActive() || fixings.isEmpty()) {
            throw new IllegalArgumentException("Unable to find Ibor index curve: " + index);
        }
        return HistoricIborIndexRates.of(index, this.valuationDate, fixings);
    }

    @Override
    public OvernightIndexRates overnightIndexRates(OvernightIndex index) {
        Curve curve = (Curve)this.indexCurves.get((Object)index);
        if (curve == null) {
            return this.historicCurve(index);
        }
        return OvernightIndexRates.of(index, this.valuationDate, curve, this.timeSeries((Index)index));
    }

    private OvernightIndexRates historicCurve(OvernightIndex index) {
        LocalDateDoubleTimeSeries fixings = this.timeSeries((Index)index);
        if (index.isActive() || fixings.isEmpty()) {
            throw new IllegalArgumentException("Unable to find Overnight index curve: " + index);
        }
        return HistoricOvernightIndexRates.of(index, this.valuationDate, fixings);
    }

    @Override
    public PriceIndexValues priceIndexValues(PriceIndex index) {
        Curve curve = (Curve)this.indexCurves.get((Object)index);
        if (curve == null) {
            return this.historicCurve(index);
        }
        return PriceIndexValues.of(index, this.valuationDate, curve, this.timeSeries((Index)index));
    }

    private PriceIndexValues historicCurve(PriceIndex index) {
        LocalDateDoubleTimeSeries fixings = this.timeSeries((Index)index);
        if (index.isActive() || fixings.isEmpty()) {
            throw new IllegalArgumentException("Unable to find Price index curve: " + index);
        }
        return HistoricPriceIndexValues.of(index, this.valuationDate, fixings);
    }

    public ImmutableRatesProvider combinedWith(ImmutableRatesProvider other, FxRateProvider fxProvider) {
        ImmutableRatesProviderBuilder merged = other.toBuilder();
        ImmutableMap<Currency, Curve> dscMap1 = this.discountCurves;
        ImmutableMap<Currency, Curve> dscMap2 = other.discountCurves;
        for (Map.Entry entry : dscMap1.entrySet()) {
            ArgChecker.isTrue((!dscMap2.containsKey(entry.getKey()) ? 1 : 0) != 0, (String)"conflict on discount curve, currency '{}' appears twice in the providers", (Object[])new Object[]{entry.getKey()});
            merged.discountCurve((Currency)entry.getKey(), (Curve)entry.getValue());
        }
        ImmutableMap<Index, Curve> indexMap1 = this.indexCurves;
        ImmutableMap<Index, Curve> indexMap2 = other.indexCurves;
        for (Map.Entry entry : indexMap1.entrySet()) {
            ArgChecker.isTrue((!indexMap2.containsKey(entry.getKey()) ? 1 : 0) != 0, (String)"conflict on index curve, index '{}' appears twice in the providers", (Object[])new Object[]{entry.getKey()});
            merged.indexCurve((Index)entry.getKey(), (Curve)entry.getValue());
        }
        ImmutableMap<Index, LocalDateDoubleTimeSeries> tsMap1 = this.timeSeries;
        ImmutableMap<Index, LocalDateDoubleTimeSeries> tsMap2 = other.timeSeries;
        for (Map.Entry entry : tsMap1.entrySet()) {
            ArgChecker.isTrue((!tsMap2.containsKey(entry.getKey()) ? 1 : 0) != 0, (String)"conflict on time series, index '{}' appears twice in the providers", (Object[])new Object[]{entry.getKey()});
            merged.timeSeries((Index)entry.getKey(), (LocalDateDoubleTimeSeries)entry.getValue());
        }
        merged.fxRateProvider(fxProvider);
        return merged.build();
    }

    @Override
    public ImmutableRatesProvider toImmutableRatesProvider() {
        return this;
    }

    public Map<CurveName, Curve> getCurves() {
        HashMap<CurveName, Curve> curves = new HashMap<CurveName, Curve>();
        this.discountCurves.values().forEach(curve -> curves.put(curve.getName(), (Curve)curve));
        this.indexCurves.values().forEach(curve -> curves.put(curve.getName(), (Curve)curve));
        return curves;
    }

    public Map<CurveId, Curve> getCurves(CurveGroupName groupName) {
        HashMap<CurveId, Curve> curves = new HashMap<CurveId, Curve>();
        this.discountCurves.values().forEach(curve -> curves.put(CurveId.of((CurveGroupName)groupName, (CurveName)curve.getName()), (Curve)curve));
        this.indexCurves.values().forEach(curve -> curves.put(CurveId.of((CurveGroupName)groupName, (CurveName)curve.getName()), (Curve)curve));
        return curves;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    ImmutableRatesProvider(LocalDate valuationDate, FxRateProvider fxRateProvider, Map<Currency, Curve> discountCurves, Map<Index, Curve> indexCurves, Map<Index, LocalDateDoubleTimeSeries> timeSeries) {
        JodaBeanUtils.notNull((Object)valuationDate, (String)"valuationDate");
        JodaBeanUtils.notNull((Object)fxRateProvider, (String)"fxRateProvider");
        JodaBeanUtils.notNull(discountCurves, (String)"discountCurves");
        JodaBeanUtils.notNull(indexCurves, (String)"indexCurves");
        JodaBeanUtils.notNull(timeSeries, (String)"timeSeries");
        this.valuationDate = valuationDate;
        this.fxRateProvider = fxRateProvider;
        this.discountCurves = ImmutableMap.copyOf(discountCurves);
        this.indexCurves = ImmutableMap.copyOf(indexCurves);
        this.timeSeries = ImmutableMap.copyOf(timeSeries);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public LocalDate getValuationDate() {
        return this.valuationDate;
    }

    public FxRateProvider getFxRateProvider() {
        return this.fxRateProvider;
    }

    public ImmutableMap<Currency, Curve> getDiscountCurves() {
        return this.discountCurves;
    }

    public ImmutableMap<Index, Curve> getIndexCurves() {
        return this.indexCurves;
    }

    public ImmutableMap<Index, LocalDateDoubleTimeSeries> getTimeSeries() {
        return this.timeSeries;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ImmutableRatesProvider other = (ImmutableRatesProvider)obj;
            return JodaBeanUtils.equal((Object)this.valuationDate, (Object)other.valuationDate) && JodaBeanUtils.equal((Object)this.fxRateProvider, (Object)other.fxRateProvider) && JodaBeanUtils.equal(this.discountCurves, other.discountCurves) && JodaBeanUtils.equal(this.indexCurves, other.indexCurves) && JodaBeanUtils.equal(this.timeSeries, other.timeSeries);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.valuationDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fxRateProvider);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.discountCurves);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.indexCurves);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.timeSeries);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("ImmutableRatesProvider{");
        buf.append("valuationDate").append('=').append(JodaBeanUtils.toString((Object)this.valuationDate)).append(',').append(' ');
        buf.append("fxRateProvider").append('=').append(JodaBeanUtils.toString((Object)this.fxRateProvider)).append(',').append(' ');
        buf.append("discountCurves").append('=').append(JodaBeanUtils.toString(this.discountCurves)).append(',').append(' ');
        buf.append("indexCurves").append('=').append(JodaBeanUtils.toString(this.indexCurves)).append(',').append(' ');
        buf.append("timeSeries").append('=').append(JodaBeanUtils.toString(this.timeSeries));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ImmutableRatesProvider> {
        private LocalDate valuationDate;
        private FxRateProvider fxRateProvider;
        private Map<Currency, Curve> discountCurves = ImmutableMap.of();
        private Map<Index, Curve> indexCurves = ImmutableMap.of();
        private Map<Index, LocalDateDoubleTimeSeries> timeSeries = ImmutableMap.of();

        private Builder() {
            ImmutableRatesProvider.applyDefaults(this);
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 113107279: {
                    return this.valuationDate;
                }
                case -1499624221: {
                    return this.fxRateProvider;
                }
                case -624113147: {
                    return this.discountCurves;
                }
                case 886361302: {
                    return this.indexCurves;
                }
                case 779431844: {
                    return this.timeSeries;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 113107279: {
                    this.valuationDate = (LocalDate)newValue;
                    break;
                }
                case -1499624221: {
                    this.fxRateProvider = (FxRateProvider)newValue;
                    break;
                }
                case -624113147: {
                    this.discountCurves = (Map)newValue;
                    break;
                }
                case 886361302: {
                    this.indexCurves = (Map)newValue;
                    break;
                }
                case 779431844: {
                    this.timeSeries = (Map)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ImmutableRatesProvider build() {
            return new ImmutableRatesProvider(this.valuationDate, this.fxRateProvider, this.discountCurves, this.indexCurves, this.timeSeries);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("ImmutableRatesProvider.Builder{");
            buf.append("valuationDate").append('=').append(JodaBeanUtils.toString((Object)this.valuationDate)).append(',').append(' ');
            buf.append("fxRateProvider").append('=').append(JodaBeanUtils.toString((Object)this.fxRateProvider)).append(',').append(' ');
            buf.append("discountCurves").append('=').append(JodaBeanUtils.toString(this.discountCurves)).append(',').append(' ');
            buf.append("indexCurves").append('=').append(JodaBeanUtils.toString(this.indexCurves)).append(',').append(' ');
            buf.append("timeSeries").append('=').append(JodaBeanUtils.toString(this.timeSeries));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<LocalDate> valuationDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valuationDate", ImmutableRatesProvider.class, LocalDate.class);
        private final MetaProperty<FxRateProvider> fxRateProvider = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fxRateProvider", ImmutableRatesProvider.class, FxRateProvider.class);
        private final MetaProperty<ImmutableMap<Currency, Curve>> discountCurves = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"discountCurves", ImmutableRatesProvider.class, ImmutableMap.class);
        private final MetaProperty<ImmutableMap<Index, Curve>> indexCurves = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"indexCurves", ImmutableRatesProvider.class, ImmutableMap.class);
        private final MetaProperty<ImmutableMap<Index, LocalDateDoubleTimeSeries>> timeSeries = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"timeSeries", ImmutableRatesProvider.class, ImmutableMap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"valuationDate", "fxRateProvider", "discountCurves", "indexCurves", "timeSeries"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 113107279: {
                    return this.valuationDate;
                }
                case -1499624221: {
                    return this.fxRateProvider;
                }
                case -624113147: {
                    return this.discountCurves;
                }
                case 886361302: {
                    return this.indexCurves;
                }
                case 779431844: {
                    return this.timeSeries;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ImmutableRatesProvider> builder() {
            return new Builder();
        }

        public Class<? extends ImmutableRatesProvider> beanType() {
            return ImmutableRatesProvider.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<LocalDate> valuationDate() {
            return this.valuationDate;
        }

        public MetaProperty<FxRateProvider> fxRateProvider() {
            return this.fxRateProvider;
        }

        public MetaProperty<ImmutableMap<Currency, Curve>> discountCurves() {
            return this.discountCurves;
        }

        public MetaProperty<ImmutableMap<Index, Curve>> indexCurves() {
            return this.indexCurves;
        }

        public MetaProperty<ImmutableMap<Index, LocalDateDoubleTimeSeries>> timeSeries() {
            return this.timeSeries;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 113107279: {
                    return ((ImmutableRatesProvider)bean).getValuationDate();
                }
                case -1499624221: {
                    return ((ImmutableRatesProvider)bean).getFxRateProvider();
                }
                case -624113147: {
                    return ((ImmutableRatesProvider)bean).getDiscountCurves();
                }
                case 886361302: {
                    return ((ImmutableRatesProvider)bean).getIndexCurves();
                }
                case 779431844: {
                    return ((ImmutableRatesProvider)bean).getTimeSeries();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

