/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.rate;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxMatrix;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.basics.index.PriceIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.pricer.rate.ImmutableRatesProvider;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

public final class ImmutableRatesProviderBuilder {
    private final LocalDate valuationDate;
    private FxRateProvider fxRateProvider = FxMatrix.empty();
    private final Map<Currency, Curve> discountCurves = new HashMap<Currency, Curve>();
    private final Map<Index, Curve> indexCurves = new HashMap<Index, Curve>();
    private final Map<Index, LocalDateDoubleTimeSeries> timeSeries = new HashMap<Index, LocalDateDoubleTimeSeries>();

    ImmutableRatesProviderBuilder(LocalDate valuationDate) {
        this.valuationDate = (LocalDate)ArgChecker.notNull((Object)valuationDate, (String)"valuationDate");
    }

    public ImmutableRatesProviderBuilder fxRateProvider(FxRateProvider fxRateProvider) {
        this.fxRateProvider = (FxRateProvider)ArgChecker.notNull((Object)fxRateProvider, (String)"fxRateProvider");
        return this;
    }

    public ImmutableRatesProviderBuilder discountCurve(Currency currency, Curve discountCurve) {
        ArgChecker.notNull((Object)currency, (String)"currency");
        ArgChecker.notNull((Object)discountCurve, (String)"discountCurve");
        this.discountCurves.put(currency, discountCurve);
        return this;
    }

    public ImmutableRatesProviderBuilder discountCurves(Map<Currency, ? extends Curve> discountCurves) {
        ArgChecker.notNull(discountCurves, (String)"discountCurves");
        for (Map.Entry<Currency, ? extends Curve> entry : discountCurves.entrySet()) {
            this.discountCurve(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public ImmutableRatesProviderBuilder iborIndexCurve(IborIndex index, Curve forwardCurve) {
        ArgChecker.notNull((Object)index, (String)"index");
        ArgChecker.notNull((Object)forwardCurve, (String)"forwardCurve");
        this.indexCurves.put((Index)index, forwardCurve);
        return this;
    }

    public ImmutableRatesProviderBuilder iborIndexCurve(IborIndex index, Curve forwardCurve, LocalDateDoubleTimeSeries timeSeries) {
        ArgChecker.notNull((Object)index, (String)"index");
        ArgChecker.notNull((Object)forwardCurve, (String)"forwardCurve");
        ArgChecker.notNull((Object)timeSeries, (String)"timeSeries");
        this.indexCurves.put((Index)index, forwardCurve);
        this.timeSeries.put((Index)index, timeSeries);
        return this;
    }

    public ImmutableRatesProviderBuilder overnightIndexCurve(OvernightIndex index, Curve forwardCurve) {
        ArgChecker.notNull((Object)index, (String)"index");
        ArgChecker.notNull((Object)forwardCurve, (String)"forwardCurve");
        this.indexCurves.put((Index)index, forwardCurve);
        return this;
    }

    public ImmutableRatesProviderBuilder overnightIndexCurve(OvernightIndex index, Curve forwardCurve, LocalDateDoubleTimeSeries timeSeries) {
        ArgChecker.notNull((Object)index, (String)"index");
        ArgChecker.notNull((Object)forwardCurve, (String)"forwardCurve");
        ArgChecker.notNull((Object)timeSeries, (String)"timeSeries");
        this.indexCurves.put((Index)index, forwardCurve);
        this.timeSeries.put((Index)index, timeSeries);
        return this;
    }

    public ImmutableRatesProviderBuilder priceIndexCurve(PriceIndex index, Curve forwardCurve) {
        ArgChecker.notNull((Object)index, (String)"index");
        ArgChecker.notNull((Object)forwardCurve, (String)"forwardCurve");
        this.indexCurves.put((Index)index, forwardCurve);
        return this;
    }

    public ImmutableRatesProviderBuilder priceIndexCurve(PriceIndex index, Curve forwardCurve, LocalDateDoubleTimeSeries timeSeries) {
        ArgChecker.notNull((Object)index, (String)"index");
        ArgChecker.notNull((Object)forwardCurve, (String)"forwardCurve");
        ArgChecker.notNull((Object)timeSeries, (String)"timeSeries");
        this.indexCurves.put((Index)index, forwardCurve);
        this.timeSeries.put((Index)index, timeSeries);
        return this;
    }

    public ImmutableRatesProviderBuilder indexCurve(Index index, Curve forwardCurve) {
        ArgChecker.notNull((Object)index, (String)"index");
        ArgChecker.notNull((Object)forwardCurve, (String)"forwardCurve");
        this.indexCurves.put(index, forwardCurve);
        return this;
    }

    public ImmutableRatesProviderBuilder indexCurve(Index index, Curve forwardCurve, LocalDateDoubleTimeSeries timeSeries) {
        ArgChecker.notNull((Object)index, (String)"index");
        ArgChecker.notNull((Object)forwardCurve, (String)"forwardCurve");
        this.indexCurves.put(index, forwardCurve);
        this.timeSeries.put(index, timeSeries);
        return this;
    }

    public ImmutableRatesProviderBuilder indexCurves(Map<? extends Index, ? extends Curve> indexCurves) {
        ArgChecker.noNulls(indexCurves, (String)"indexCurves");
        for (Map.Entry<? extends Index, ? extends Curve> entry : indexCurves.entrySet()) {
            this.indexCurve(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public ImmutableRatesProviderBuilder indexCurves(Map<? extends Index, ? extends Curve> indexCurves, Map<? extends Index, LocalDateDoubleTimeSeries> timeSeries) {
        ArgChecker.noNulls(indexCurves, (String)"indexCurves");
        for (Map.Entry<? extends Index, ? extends Curve> entry : indexCurves.entrySet()) {
            Index index = entry.getKey();
            LocalDateDoubleTimeSeries ts = timeSeries.get(index);
            ts = ts != null ? ts : LocalDateDoubleTimeSeries.empty();
            this.indexCurve(entry.getKey(), entry.getValue(), ts);
        }
        return this;
    }

    public ImmutableRatesProviderBuilder timeSeries(Index index, LocalDateDoubleTimeSeries timeSeries) {
        ArgChecker.notNull((Object)index, (String)"index");
        ArgChecker.notNull((Object)timeSeries, (String)"timeSeries");
        this.timeSeries.put(index, timeSeries);
        return this;
    }

    public ImmutableRatesProviderBuilder timeSeries(Map<? extends Index, LocalDateDoubleTimeSeries> timeSeries) {
        ArgChecker.noNulls(timeSeries, (String)"timeSeries");
        this.timeSeries.putAll(timeSeries);
        return this;
    }

    public ImmutableRatesProvider build() {
        return new ImmutableRatesProvider(this.valuationDate, this.fxRateProvider, this.discountCurves, this.indexCurves, this.timeSeries);
    }
}

