/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.rate;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.basics.index.OvernightIndexObservation;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.market.MarketDataView;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.ParameterizedData;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.rate.DiscountOvernightIndexRates;
import com.opengamma.strata.pricer.rate.OvernightRateSensitivity;
import java.time.LocalDate;

public interface OvernightIndexRates
extends MarketDataView,
ParameterizedData {
    public static OvernightIndexRates of(OvernightIndex index, LocalDate valuationDate, Curve forwardCurve) {
        return OvernightIndexRates.of(index, valuationDate, forwardCurve, LocalDateDoubleTimeSeries.empty());
    }

    public static OvernightIndexRates of(OvernightIndex index, LocalDate valuationDate, Curve forwardCurve, LocalDateDoubleTimeSeries fixings) {
        DiscountFactors discountFactors = DiscountFactors.of(index.getCurrency(), valuationDate, forwardCurve);
        return DiscountOvernightIndexRates.of(index, discountFactors, fixings);
    }

    public OvernightIndex getIndex();

    public LocalDateDoubleTimeSeries getFixings();

    public OvernightIndexRates withParameter(int var1, double var2);

    public OvernightIndexRates withPerturbation(ParameterPerturbation var1);

    public double rate(OvernightIndexObservation var1);

    public double rateIgnoringFixings(OvernightIndexObservation var1);

    public PointSensitivityBuilder ratePointSensitivity(OvernightIndexObservation var1);

    public PointSensitivityBuilder rateIgnoringFixingsPointSensitivity(OvernightIndexObservation var1);

    public double periodRate(OvernightIndexObservation var1, LocalDate var2);

    public PointSensitivityBuilder periodRatePointSensitivity(OvernightIndexObservation var1, LocalDate var2);

    public CurrencyParameterSensitivities parameterSensitivity(OvernightRateSensitivity var1);

    public CurrencyParameterSensitivities createParameterSensitivity(Currency var1, DoubleArray var2);
}

