/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.rate;

import com.google.common.collect.ComparisonChain;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.basics.index.OvernightIndexObservation;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.MutablePointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.DoubleUnaryOperator;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class OvernightRateSensitivity
implements PointSensitivity,
PointSensitivityBuilder,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final OvernightIndexObservation observation;
    @PropertyDefinition(validate="notNull")
    private final LocalDate endDate;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    @PropertyDefinition(overrideGet=true)
    private final double sensitivity;
    private static final long serialVersionUID = 1L;

    public static OvernightRateSensitivity of(OvernightIndexObservation observation, double sensitivity) {
        return OvernightRateSensitivity.of(observation, observation.getCurrency(), sensitivity);
    }

    public static OvernightRateSensitivity of(OvernightIndexObservation observation, Currency sensitivityCurrency, double sensitivity) {
        return new OvernightRateSensitivity(observation, observation.getMaturityDate(), sensitivityCurrency, sensitivity);
    }

    public static OvernightRateSensitivity ofPeriod(OvernightIndexObservation observation, LocalDate endDate, double sensitivity) {
        return OvernightRateSensitivity.ofPeriod(observation, endDate, observation.getCurrency(), sensitivity);
    }

    public static OvernightRateSensitivity ofPeriod(OvernightIndexObservation observation, LocalDate endDate, Currency sensitivityCurrency, double sensitivity) {
        return new OvernightRateSensitivity(observation, endDate, sensitivityCurrency, sensitivity);
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.inOrderNotEqual((Comparable)this.observation.getFixingDate(), (Object)this.endDate, (String)"fixingDate", (String)"endDate");
    }

    public OvernightIndex getIndex() {
        return this.observation.getIndex();
    }

    public OvernightRateSensitivity withCurrency(Currency currency) {
        if (this.currency.equals((Object)currency)) {
            return this;
        }
        return new OvernightRateSensitivity(this.observation, this.endDate, currency, this.sensitivity);
    }

    public OvernightRateSensitivity withSensitivity(double sensitivity) {
        return new OvernightRateSensitivity(this.observation, this.endDate, this.currency, sensitivity);
    }

    public int compareKey(PointSensitivity other) {
        if (other instanceof OvernightRateSensitivity) {
            OvernightRateSensitivity otherOn = (OvernightRateSensitivity)other;
            return ComparisonChain.start().compare((Comparable)((Object)this.getIndex().toString()), (Comparable)((Object)otherOn.getIndex().toString())).compare((Comparable)this.currency, (Comparable)otherOn.currency).compare((Comparable)this.observation.getFixingDate(), (Comparable)otherOn.observation.getFixingDate()).compare((Comparable)this.endDate, (Comparable)otherOn.endDate).result();
        }
        return this.getClass().getSimpleName().compareTo(other.getClass().getSimpleName());
    }

    public OvernightRateSensitivity convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        return (OvernightRateSensitivity)super.convertedTo(resultCurrency, rateProvider);
    }

    public OvernightRateSensitivity multipliedBy(double factor) {
        return new OvernightRateSensitivity(this.observation, this.endDate, this.currency, this.sensitivity * factor);
    }

    public OvernightRateSensitivity mapSensitivity(DoubleUnaryOperator operator) {
        return new OvernightRateSensitivity(this.observation, this.endDate, this.currency, operator.applyAsDouble(this.sensitivity));
    }

    public OvernightRateSensitivity normalize() {
        return this;
    }

    public MutablePointSensitivities buildInto(MutablePointSensitivities combination) {
        return combination.add((PointSensitivity)this);
    }

    public OvernightRateSensitivity cloned() {
        return this;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private OvernightRateSensitivity(OvernightIndexObservation observation, LocalDate endDate, Currency currency, double sensitivity) {
        JodaBeanUtils.notNull((Object)observation, (String)"observation");
        JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        this.observation = observation;
        this.endDate = endDate;
        this.currency = currency;
        this.sensitivity = sensitivity;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public OvernightIndexObservation getObservation() {
        return this.observation;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public double getSensitivity() {
        return this.sensitivity;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            OvernightRateSensitivity other = (OvernightRateSensitivity)obj;
            return JodaBeanUtils.equal((Object)this.observation, (Object)other.observation) && JodaBeanUtils.equal((Object)this.endDate, (Object)other.endDate) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.sensitivity, (double)other.sensitivity);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.observation);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.sensitivity);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("OvernightRateSensitivity{");
        buf.append("observation").append('=').append(JodaBeanUtils.toString((Object)this.observation)).append(',').append(' ');
        buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<OvernightRateSensitivity> {
        private OvernightIndexObservation observation;
        private LocalDate endDate;
        private Currency currency;
        private double sensitivity;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    return this.observation;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    this.observation = (OvernightIndexObservation)newValue;
                    break;
                }
                case -1607727319: {
                    this.endDate = (LocalDate)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 564403871: {
                    this.sensitivity = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public OvernightRateSensitivity build() {
            return new OvernightRateSensitivity(this.observation, this.endDate, this.currency, this.sensitivity);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("OvernightRateSensitivity.Builder{");
            buf.append("observation").append('=').append(JodaBeanUtils.toString((Object)this.observation)).append(',').append(' ');
            buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<OvernightIndexObservation> observation = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"observation", OvernightRateSensitivity.class, OvernightIndexObservation.class);
        private final MetaProperty<LocalDate> endDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"endDate", OvernightRateSensitivity.class, LocalDate.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", OvernightRateSensitivity.class, Currency.class);
        private final MetaProperty<Double> sensitivity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sensitivity", OvernightRateSensitivity.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"observation", "endDate", "currency", "sensitivity"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    return this.observation;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends OvernightRateSensitivity> builder() {
            return new Builder();
        }

        public Class<? extends OvernightRateSensitivity> beanType() {
            return OvernightRateSensitivity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<OvernightIndexObservation> observation() {
            return this.observation;
        }

        public MetaProperty<LocalDate> endDate() {
            return this.endDate;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> sensitivity() {
            return this.sensitivity;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 122345516: {
                    return ((OvernightRateSensitivity)bean).getObservation();
                }
                case -1607727319: {
                    return ((OvernightRateSensitivity)bean).getEndDate();
                }
                case 575402001: {
                    return ((OvernightRateSensitivity)bean).getCurrency();
                }
                case 564403871: {
                    return ((OvernightRateSensitivity)bean).getSensitivity();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

