/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.rate;

import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.index.FxIndex;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.basics.index.PriceIndex;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.BaseProvider;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.fx.FxForwardRates;
import com.opengamma.strata.pricer.fx.FxForwardSensitivity;
import com.opengamma.strata.pricer.fx.FxIndexRates;
import com.opengamma.strata.pricer.fx.FxIndexSensitivity;
import com.opengamma.strata.pricer.rate.IborIndexRates;
import com.opengamma.strata.pricer.rate.IborRateSensitivity;
import com.opengamma.strata.pricer.rate.ImmutableRatesProvider;
import com.opengamma.strata.pricer.rate.InflationRateSensitivity;
import com.opengamma.strata.pricer.rate.OvernightIndexRates;
import com.opengamma.strata.pricer.rate.OvernightRateSensitivity;
import com.opengamma.strata.pricer.rate.PriceIndexValues;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public interface RatesProvider
extends BaseProvider {
    default public Stream<Index> indices() {
        return Guavate.concatToSet((Iterable[])new Iterable[]{this.getIborIndices(), this.getOvernightIndices(), this.getPriceIndices()}).stream();
    }

    public Set<IborIndex> getIborIndices();

    public Set<OvernightIndex> getOvernightIndices();

    public Set<PriceIndex> getPriceIndices();

    public Set<Index> getTimeSeriesIndices();

    public FxIndexRates fxIndexRates(FxIndex var1);

    public FxForwardRates fxForwardRates(CurrencyPair var1);

    public IborIndexRates iborIndexRates(IborIndex var1);

    public OvernightIndexRates overnightIndexRates(OvernightIndex var1);

    public PriceIndexValues priceIndexValues(PriceIndex var1);

    default public CurrencyParameterSensitivities parameterSensitivity(PointSensitivities pointSensitivities) {
        CurrencyParameterSensitivities sens = CurrencyParameterSensitivities.empty();
        for (PointSensitivity point : pointSensitivities.getSensitivities()) {
            Object rates;
            PointSensitivityBuilder pt;
            if (point instanceof ZeroRateSensitivity) {
                pt = (ZeroRateSensitivity)point;
                DiscountFactors factors = this.discountFactors(pt.getCurveCurrency());
                sens = sens.combinedWith(factors.parameterSensitivity((ZeroRateSensitivity)pt));
                continue;
            }
            if (point instanceof IborRateSensitivity) {
                pt = (IborRateSensitivity)point;
                rates = this.iborIndexRates(pt.getIndex());
                sens = sens.combinedWith(rates.parameterSensitivity((IborRateSensitivity)pt));
                continue;
            }
            if (point instanceof OvernightRateSensitivity) {
                pt = (OvernightRateSensitivity)point;
                rates = this.overnightIndexRates(pt.getIndex());
                sens = sens.combinedWith(rates.parameterSensitivity((OvernightRateSensitivity)pt));
                continue;
            }
            if (point instanceof FxIndexSensitivity) {
                pt = (FxIndexSensitivity)point;
                rates = this.fxIndexRates(pt.getIndex());
                sens = sens.combinedWith(rates.parameterSensitivity((FxIndexSensitivity)pt));
                continue;
            }
            if (point instanceof InflationRateSensitivity) {
                pt = (InflationRateSensitivity)point;
                rates = this.priceIndexValues(pt.getIndex());
                sens = sens.combinedWith(rates.parameterSensitivity((InflationRateSensitivity)pt));
                continue;
            }
            if (!(point instanceof FxForwardSensitivity)) continue;
            pt = (FxForwardSensitivity)point;
            rates = this.fxForwardRates(pt.getCurrencyPair());
            sens = sens.combinedWith(rates.parameterSensitivity((FxForwardSensitivity)pt));
        }
        return sens;
    }

    default public MultiCurrencyAmount currencyExposure(PointSensitivities pointSensitivities) {
        MultiCurrencyAmount ce = MultiCurrencyAmount.empty();
        for (PointSensitivity point : pointSensitivities.getSensitivities()) {
            Object rates;
            PointSensitivityBuilder pt;
            if (point instanceof FxIndexSensitivity) {
                pt = (FxIndexSensitivity)point;
                rates = this.fxIndexRates(pt.getIndex());
                ce = ce.plus(rates.currencyExposure((FxIndexSensitivity)pt));
            }
            if (!(point instanceof FxForwardSensitivity)) continue;
            pt = (FxForwardSensitivity)point;
            pt = pt.convertedTo(pt.getReferenceCurrency(), this);
            rates = this.fxForwardRates(pt.getCurrencyPair());
            ce = ce.plus(rates.currencyExposure((FxForwardSensitivity)pt));
        }
        return ce;
    }

    public <T> Optional<T> findData(MarketDataName<T> var1);

    public LocalDateDoubleTimeSeries timeSeries(Index var1);

    public ImmutableRatesProvider toImmutableRatesProvider();
}

