/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.sensitivity;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveInfoType;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.JacobianCalibrationMatrix;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.math.impl.matrix.MatrixAlgebra;
import com.opengamma.strata.math.impl.matrix.OGMatrixAlgebra;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.pricer.credit.CreditRatesProvider;
import com.opengamma.strata.pricer.rate.RatesProvider;
import java.util.Map;

public class MarketQuoteSensitivityCalculator {
    public static final MarketQuoteSensitivityCalculator DEFAULT = new MarketQuoteSensitivityCalculator();
    private static final MatrixAlgebra MATRIX_ALGEBRA = new OGMatrixAlgebra();

    public CurrencyParameterSensitivities sensitivity(CurrencyParameterSensitivities paramSensitivities, RatesProvider provider) {
        ArgChecker.notNull((Object)paramSensitivities, (String)"paramSensitivities");
        ArgChecker.notNull((Object)provider, (String)"provider");
        CurrencyParameterSensitivities result = CurrencyParameterSensitivities.empty();
        for (CurrencyParameterSensitivity paramSens : paramSensitivities.getSensitivities()) {
            DoubleArray marketQuoteSensMatrix;
            Curve curve = provider.findData(paramSens.getMarketDataName()).filter(v -> v instanceof Curve).map(v -> (Curve)v).orElseThrow(() -> new IllegalArgumentException("Market Quote sensitivity requires curve: " + paramSens.getMarketDataName()));
            JacobianCalibrationMatrix info = (JacobianCalibrationMatrix)curve.getMetadata().findInfo(CurveInfoType.JACOBIAN).orElseThrow(() -> new IllegalArgumentException("Market Quote sensitivity requires Jacobian calibration information"));
            DoubleMatrix jacobian = info.getJacobianMatrix();
            DoubleArray paramSensMatrix = paramSens.getSensitivity();
            DoubleArray marketQuoteSens = marketQuoteSensMatrix = (DoubleArray)MATRIX_ALGEBRA.multiply((Matrix)paramSensMatrix, (Matrix)jacobian);
            Map split = info.splitValues(marketQuoteSens);
            for (Map.Entry entry : split.entrySet()) {
                CurveName curveName = (CurveName)entry.getKey();
                CurrencyParameterSensitivity maketQuoteSens = provider.findData(curveName).map(c -> c.createParameterSensitivity(paramSens.getCurrency(), (DoubleArray)entry.getValue())).orElse(CurrencyParameterSensitivity.of((MarketDataName)curveName, (Currency)paramSens.getCurrency(), (DoubleArray)((DoubleArray)entry.getValue())));
                result = result.combinedWith(maketQuoteSens);
            }
        }
        return result;
    }

    public CurrencyParameterSensitivities sensitivity(CurrencyParameterSensitivities paramSensitivities, LegalEntityDiscountingProvider provider) {
        ArgChecker.notNull((Object)paramSensitivities, (String)"paramSensitivities");
        ArgChecker.notNull((Object)provider, (String)"provider");
        CurrencyParameterSensitivities result = CurrencyParameterSensitivities.empty();
        for (CurrencyParameterSensitivity paramSens : paramSensitivities.getSensitivities()) {
            DoubleArray marketQuoteSensMatrix;
            Curve curve = provider.findData(paramSens.getMarketDataName()).filter(v -> v instanceof Curve).map(v -> (Curve)v).orElseThrow(() -> new IllegalArgumentException("Market Quote sensitivity requires curve: " + paramSens.getMarketDataName()));
            JacobianCalibrationMatrix info = (JacobianCalibrationMatrix)curve.getMetadata().findInfo(CurveInfoType.JACOBIAN).orElseThrow(() -> new IllegalArgumentException("Market Quote sensitivity requires Jacobian calibration information"));
            DoubleMatrix jacobian = info.getJacobianMatrix();
            DoubleArray paramSensMatrix = paramSens.getSensitivity();
            DoubleArray marketQuoteSens = marketQuoteSensMatrix = (DoubleArray)MATRIX_ALGEBRA.multiply((Matrix)paramSensMatrix, (Matrix)jacobian);
            Map split = info.splitValues(marketQuoteSens);
            for (Map.Entry entry : split.entrySet()) {
                CurveName curveName = (CurveName)entry.getKey();
                CurrencyParameterSensitivity maketQuoteSens = provider.findData(curveName).map(c -> c.createParameterSensitivity(paramSens.getCurrency(), (DoubleArray)entry.getValue())).orElse(CurrencyParameterSensitivity.of((MarketDataName)curveName, (Currency)paramSens.getCurrency(), (DoubleArray)((DoubleArray)entry.getValue())));
                result = result.combinedWith(maketQuoteSens);
            }
        }
        return result;
    }

    public CurrencyParameterSensitivities sensitivity(CurrencyParameterSensitivities paramSensitivities, CreditRatesProvider provider) {
        CurrencyParameterSensitivities result = CurrencyParameterSensitivities.empty();
        for (CurrencyParameterSensitivity paramSens : paramSensitivities.getSensitivities()) {
            DoubleArray marketQuoteSensMatrix;
            Curve curve = provider.findData(paramSens.getMarketDataName()).filter(v -> v instanceof Curve).map(v -> (Curve)v).orElseThrow(() -> new IllegalArgumentException("Market Quote sensitivity requires curve: " + paramSens.getMarketDataName()));
            JacobianCalibrationMatrix info = (JacobianCalibrationMatrix)curve.getMetadata().findInfo(CurveInfoType.JACOBIAN).orElseThrow(() -> new IllegalArgumentException("Market Quote sensitivity requires Jacobian calibration information"));
            DoubleMatrix jacobian = info.getJacobianMatrix();
            DoubleArray paramSensMatrix = paramSens.getSensitivity();
            DoubleArray marketQuoteSens = marketQuoteSensMatrix = (DoubleArray)MATRIX_ALGEBRA.multiply((Matrix)paramSensMatrix, (Matrix)jacobian);
            Map split = info.splitValues(marketQuoteSens);
            for (Map.Entry entry : split.entrySet()) {
                CurveName curveName = (CurveName)entry.getKey();
                CurrencyParameterSensitivity maketQuoteSens = provider.findData(curveName).map(c -> c.createParameterSensitivity(paramSens.getCurrency(), (DoubleArray)entry.getValue())).orElse(CurrencyParameterSensitivity.of((MarketDataName)curveName, (Currency)paramSens.getCurrency(), (DoubleArray)((DoubleArray)entry.getValue())));
                result = result.combinedWith(maketQuoteSens);
            }
        }
        return result;
    }
}

