/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.swap;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.amount.CashFlow;
import com.opengamma.strata.market.amount.CashFlows;
import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMap;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.SwapPaymentEventPricer;
import com.opengamma.strata.pricer.swap.SwapPaymentPeriodPricer;
import com.opengamma.strata.product.swap.RatePaymentPeriod;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;
import com.opengamma.strata.product.swap.SwapPaymentEvent;
import com.opengamma.strata.product.swap.SwapPaymentPeriod;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;

public class DiscountingSwapLegPricer {
    public static final DiscountingSwapLegPricer DEFAULT = new DiscountingSwapLegPricer(SwapPaymentPeriodPricer.standard(), SwapPaymentEventPricer.standard());
    private final SwapPaymentPeriodPricer<SwapPaymentPeriod> paymentPeriodPricer;
    private final SwapPaymentEventPricer<SwapPaymentEvent> paymentEventPricer;
    private static final double MIN_YIELD = 1.0E-4;

    public DiscountingSwapLegPricer(SwapPaymentPeriodPricer<SwapPaymentPeriod> paymentPeriodPricer, SwapPaymentEventPricer<SwapPaymentEvent> paymentEventPricer) {
        this.paymentPeriodPricer = (SwapPaymentPeriodPricer)ArgChecker.notNull(paymentPeriodPricer, (String)"paymentPeriodPricer");
        this.paymentEventPricer = (SwapPaymentEventPricer)ArgChecker.notNull(paymentEventPricer, (String)"paymentEventPricer");
    }

    public SwapPaymentPeriodPricer<SwapPaymentPeriod> getPeriodPricer() {
        return this.paymentPeriodPricer;
    }

    public SwapPaymentEventPricer<SwapPaymentEvent> getEventPricer() {
        return this.paymentEventPricer;
    }

    public CurrencyAmount presentValue(ResolvedSwapLeg leg, Currency currency, RatesProvider provider) {
        double pv = this.presentValueInternal(leg, provider);
        return CurrencyAmount.of((Currency)currency, (double)(pv * provider.fxRate(leg.getCurrency(), currency)));
    }

    public CurrencyAmount presentValue(ResolvedSwapLeg leg, RatesProvider provider) {
        return CurrencyAmount.of((Currency)leg.getCurrency(), (double)this.presentValueInternal(leg, provider));
    }

    double presentValueInternal(ResolvedSwapLeg leg, RatesProvider provider) {
        return this.presentValuePeriodsInternal(leg, provider) + this.presentValueEventsInternal(leg, provider);
    }

    public CurrencyAmount forecastValue(ResolvedSwapLeg leg, RatesProvider provider) {
        return CurrencyAmount.of((Currency)leg.getCurrency(), (double)this.forecastValueInternal(leg, provider));
    }

    double forecastValueInternal(ResolvedSwapLeg leg, RatesProvider provider) {
        return this.forecastValuePeriodsInternal(leg, provider) + this.forecastValueEventsInternal(leg, provider);
    }

    public CurrencyAmount accruedInterest(ResolvedSwapLeg leg, RatesProvider provider) {
        Optional period = leg.findPaymentPeriod(provider.getValuationDate());
        if (period.isPresent()) {
            double accruedInterest = this.paymentPeriodPricer.accruedInterest((SwapPaymentPeriod)period.get(), provider);
            return CurrencyAmount.of((Currency)leg.getCurrency(), (double)accruedInterest);
        }
        return CurrencyAmount.zero((Currency)leg.getCurrency());
    }

    public double pvbp(ResolvedSwapLeg leg, RatesProvider provider) {
        double pvbpLeg = 0.0;
        for (SwapPaymentPeriod period : leg.getPaymentPeriods()) {
            pvbpLeg += this.paymentPeriodPricer.pvbp(period, provider);
        }
        return pvbpLeg;
    }

    public double couponEquivalent(ResolvedSwapLeg leg, RatesProvider provider, double pvbp) {
        return this.presentValuePeriodsInternal(leg, provider) / pvbp;
    }

    public PointSensitivityBuilder presentValueSensitivity(ResolvedSwapLeg leg, RatesProvider provider) {
        return this.legValueSensitivity(leg, provider, this.paymentPeriodPricer::presentValueSensitivity, this.paymentEventPricer::presentValueSensitivity);
    }

    public PointSensitivityBuilder forecastValueSensitivity(ResolvedSwapLeg leg, RatesProvider provider) {
        return this.legValueSensitivity(leg, provider, this.paymentPeriodPricer::forecastValueSensitivity, this.paymentEventPricer::forecastValueSensitivity);
    }

    private PointSensitivityBuilder legValueSensitivity(ResolvedSwapLeg leg, RatesProvider provider, BiFunction<SwapPaymentPeriod, RatesProvider, PointSensitivityBuilder> periodFn, BiFunction<SwapPaymentEvent, RatesProvider, PointSensitivityBuilder> eventFn) {
        PointSensitivityBuilder builder = PointSensitivityBuilder.none();
        for (SwapPaymentPeriod period : leg.getPaymentPeriods()) {
            if (period.getPaymentDate().isBefore(provider.getValuationDate())) continue;
            builder = builder.combinedWith(periodFn.apply(period, provider));
        }
        for (SwapPaymentEvent event : leg.getPaymentEvents()) {
            if (event.getPaymentDate().isBefore(provider.getValuationDate())) continue;
            builder = builder.combinedWith(eventFn.apply(event, provider));
        }
        return builder;
    }

    public PointSensitivityBuilder pvbpSensitivity(ResolvedSwapLeg fixedLeg, RatesProvider provider) {
        PointSensitivityBuilder builder = PointSensitivityBuilder.none();
        for (SwapPaymentPeriod period : fixedLeg.getPaymentPeriods()) {
            builder = builder.combinedWith(this.paymentPeriodPricer.pvbpSensitivity(period, provider));
        }
        return builder;
    }

    public double annuityCash(ResolvedSwapLeg fixedLeg, double yield) {
        int nbFixedPeriod = fixedLeg.getPaymentPeriods().size();
        SwapPaymentPeriod paymentPeriod = (SwapPaymentPeriod)fixedLeg.getPaymentPeriods().get(0);
        ArgChecker.isTrue((boolean)(paymentPeriod instanceof RatePaymentPeriod), (String)"payment period should be RatePaymentPeriod");
        RatePaymentPeriod ratePaymentPeriod = (RatePaymentPeriod)paymentPeriod;
        int nbFixedPaymentYear = (int)Math.round(1.0 / ratePaymentPeriod.getDayCount().yearFraction(ratePaymentPeriod.getStartDate(), ratePaymentPeriod.getEndDate()));
        double notional = Math.abs(ratePaymentPeriod.getNotional());
        double annuityCash = notional * this.annuityCash(nbFixedPaymentYear, nbFixedPeriod, yield);
        return annuityCash;
    }

    public double annuityCash(int nbPaymentsPerYear, int nbPeriods, double yield) {
        double periodFactor;
        double tau = 1.0 / (double)nbPaymentsPerYear;
        if (Math.abs(yield) > 1.0E-4) {
            return (1.0 - Math.pow(1.0 + yield * tau, -nbPeriods)) / yield;
        }
        double annuity = 0.0;
        double multiPeriodFactor = periodFactor = 1.0 / (1.0 + yield * tau);
        for (int i = 0; i < nbPeriods; ++i) {
            annuity += multiPeriodFactor;
            multiPeriodFactor *= periodFactor;
        }
        return annuity *= tau;
    }

    public ValueDerivatives annuityCash1(int nbPaymentsPerYear, int nbPeriods, double yield) {
        double periodFactor;
        double tau = 1.0 / (double)nbPaymentsPerYear;
        if (Math.abs(yield) > 1.0E-4) {
            double yieldPerPeriod = yield * tau;
            double dfEnd = Math.pow(1.0 + yieldPerPeriod, -nbPeriods);
            double annuity = (1.0 - dfEnd) / yield;
            double derivative = -annuity / yield;
            return ValueDerivatives.of((double)annuity, (DoubleArray)DoubleArray.of((double)(derivative += tau * (double)nbPeriods * dfEnd / ((1.0 + yieldPerPeriod) * yield))));
        }
        double annuity = 0.0;
        double derivative = 0.0;
        double multiPeriodFactor = periodFactor = 1.0 / (1.0 + yield * tau);
        for (int i = 0; i < nbPeriods; ++i) {
            annuity += multiPeriodFactor;
            derivative += (double)(-(i + 1)) * (multiPeriodFactor *= periodFactor);
        }
        return ValueDerivatives.of((double)(annuity *= tau), (DoubleArray)DoubleArray.of((double)(derivative *= tau * tau)));
    }

    public ValueDerivatives annuityCash2(int nbPaymentsPerYear, int nbPeriods, double yield) {
        double periodFactor;
        double tau = 1.0 / (double)nbPaymentsPerYear;
        if (Math.abs(yield) > 1.0E-4) {
            double yieldPerPeriod = yield * tau;
            double dfEnd = Math.pow(1.0 + yieldPerPeriod, -nbPeriods);
            double annuity = (1.0 - dfEnd) / yield;
            double derivative1 = -annuity / yield;
            double derivative2 = -2.0 * (derivative1 += tau * (double)nbPeriods * dfEnd / ((1.0 + yieldPerPeriod) * yield)) / yield;
            return ValueDerivatives.of((double)annuity, (DoubleArray)DoubleArray.of((double)derivative1, (double)(derivative2 -= tau * tau * (double)nbPeriods * (double)(nbPeriods + 1) * dfEnd / ((1.0 + yieldPerPeriod) * (1.0 + yieldPerPeriod) * yield))));
        }
        double annuity = 0.0;
        double derivative1 = 0.0;
        double derivative2 = 0.0;
        double multiPeriodFactor = periodFactor = 1.0 / (1.0 + yield * tau);
        for (int i = 0; i < nbPeriods; ++i) {
            annuity += multiPeriodFactor;
            derivative1 += (double)(-(i + 1)) * (multiPeriodFactor *= periodFactor);
            derivative2 += (double)((i + 1) * (i + 2)) * multiPeriodFactor * periodFactor;
        }
        return ValueDerivatives.of((double)(annuity *= tau), (DoubleArray)DoubleArray.of((double)(derivative1 *= tau * tau), (double)(derivative2 *= tau * tau * tau)));
    }

    public ValueDerivatives annuityCash3(int nbPaymentsPerYear, int nbPeriods, double yield) {
        double periodFactor;
        double tau = 1.0 / (double)nbPaymentsPerYear;
        if (Math.abs(yield) > 1.0E-4) {
            double yieldPerPeriod = yield * tau;
            double dfEnd = Math.pow(1.0 + yieldPerPeriod, -nbPeriods);
            double annuity = (1.0 - dfEnd) / yield;
            double derivative1 = -annuity / yield;
            double derivative2 = -2.0 * (derivative1 += tau * (double)nbPeriods * dfEnd / ((1.0 + yieldPerPeriod) * yield)) / yield;
            double derivative3 = -6.0 * annuity / (yield * yield * yield);
            derivative3 += 6.0 * tau * (double)nbPeriods / (yield * yield * yield) * dfEnd / (1.0 + yieldPerPeriod);
            derivative3 += 3.0 * tau * tau * (double)nbPeriods * (double)(nbPeriods + 1) * dfEnd / ((1.0 + yieldPerPeriod) * (1.0 + yieldPerPeriod) * yield * yield);
            return ValueDerivatives.of((double)annuity, (DoubleArray)DoubleArray.of((double)derivative1, (double)(derivative2 -= tau * tau * (double)nbPeriods * (double)(nbPeriods + 1) * dfEnd / ((1.0 + yieldPerPeriod) * (1.0 + yieldPerPeriod) * yield)), (double)(derivative3 += tau * tau * tau * (double)nbPeriods * (double)(nbPeriods + 1) * (double)(nbPeriods + 2) * dfEnd / ((1.0 + yieldPerPeriod) * (1.0 + yieldPerPeriod) * (1.0 + yieldPerPeriod) * yield))));
        }
        double annuity = 0.0;
        double derivative1 = 0.0;
        double derivative2 = 0.0;
        double derivative3 = 0.0;
        double multiPeriodFactor = periodFactor = 1.0 / (1.0 + yield * tau);
        for (int i = 0; i < nbPeriods; ++i) {
            annuity += multiPeriodFactor;
            derivative1 += (double)(-(i + 1)) * (multiPeriodFactor *= periodFactor);
            derivative2 += (double)((i + 1) * (i + 2)) * multiPeriodFactor * periodFactor;
            derivative3 += (double)(-(i + 1) * (i + 2) * (i + 3)) * multiPeriodFactor * periodFactor * periodFactor;
        }
        return ValueDerivatives.of((double)(annuity *= tau), (DoubleArray)DoubleArray.of((double)(derivative1 *= tau * tau), (double)(derivative2 *= tau * tau * tau), (double)(derivative3 *= tau * tau * tau * tau)));
    }

    public ValueDerivatives annuityCashDerivative(ResolvedSwapLeg fixedLeg, double yield) {
        int nbFixedPeriod = fixedLeg.getPaymentPeriods().size();
        SwapPaymentPeriod paymentPeriod = (SwapPaymentPeriod)fixedLeg.getPaymentPeriods().get(0);
        ArgChecker.isTrue((boolean)(paymentPeriod instanceof RatePaymentPeriod), (String)"payment period should be RatePaymentPeriod");
        RatePaymentPeriod ratePaymentPeriod = (RatePaymentPeriod)paymentPeriod;
        int nbFixedPaymentYear = (int)Math.round(1.0 / ratePaymentPeriod.getDayCount().yearFraction(ratePaymentPeriod.getStartDate(), ratePaymentPeriod.getEndDate()));
        double notional = Math.abs(ratePaymentPeriod.getNotional());
        ValueDerivatives annuityUnit = this.annuityCash1(nbFixedPaymentYear, nbFixedPeriod, yield);
        return ValueDerivatives.of((double)(annuityUnit.getValue() * notional), (DoubleArray)annuityUnit.getDerivatives().multipliedBy(notional));
    }

    public CashFlows cashFlows(ResolvedSwapLeg leg, RatesProvider provider) {
        CashFlows cashFlowPeriods = this.cashFlowPeriodsInternal(leg, provider);
        CashFlows cashFlowEvents = this.cashFlowEventsInternal(leg, provider);
        return cashFlowPeriods.combinedWith(cashFlowEvents);
    }

    double forecastValueEventsInternal(ResolvedSwapLeg leg, RatesProvider provider) {
        double total = 0.0;
        for (SwapPaymentEvent event : leg.getPaymentEvents()) {
            if (event.getPaymentDate().isBefore(provider.getValuationDate())) continue;
            total += this.paymentEventPricer.forecastValue(event, provider);
        }
        return total;
    }

    double forecastValuePeriodsInternal(ResolvedSwapLeg leg, RatesProvider provider) {
        double total = 0.0;
        for (SwapPaymentPeriod period : leg.getPaymentPeriods()) {
            if (period.getPaymentDate().isBefore(provider.getValuationDate())) continue;
            total += this.paymentPeriodPricer.forecastValue(period, provider);
        }
        return total;
    }

    double presentValueEventsInternal(ResolvedSwapLeg leg, RatesProvider provider) {
        double total = 0.0;
        for (SwapPaymentEvent event : leg.getPaymentEvents()) {
            if (event.getPaymentDate().isBefore(provider.getValuationDate())) continue;
            total += this.paymentEventPricer.presentValue(event, provider);
        }
        return total;
    }

    double presentValuePeriodsInternal(ResolvedSwapLeg leg, RatesProvider provider) {
        double total = 0.0;
        for (SwapPaymentPeriod period : leg.getPaymentPeriods()) {
            if (period.getPaymentDate().isBefore(provider.getValuationDate())) continue;
            total += this.paymentPeriodPricer.presentValue(period, provider);
        }
        return total;
    }

    PointSensitivityBuilder presentValueSensitivityEventsInternal(ResolvedSwapLeg leg, RatesProvider provider) {
        PointSensitivityBuilder builder = PointSensitivityBuilder.none();
        for (SwapPaymentEvent event : leg.getPaymentEvents()) {
            if (event.getPaymentDate().isBefore(provider.getValuationDate())) continue;
            builder = builder.combinedWith(this.paymentEventPricer.presentValueSensitivity(event, provider));
        }
        return builder;
    }

    PointSensitivityBuilder presentValueSensitivityPeriodsInternal(ResolvedSwapLeg leg, RatesProvider provider) {
        PointSensitivityBuilder builder = PointSensitivityBuilder.none();
        for (SwapPaymentPeriod period : leg.getPaymentPeriods()) {
            if (period.getPaymentDate().isBefore(provider.getValuationDate())) continue;
            builder = builder.combinedWith(this.paymentPeriodPricer.presentValueSensitivity(period, provider));
        }
        return builder;
    }

    CashFlows cashFlowPeriodsInternal(ResolvedSwapLeg leg, RatesProvider provider) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SwapPaymentPeriod period : leg.getPaymentPeriods()) {
            double forecastValue;
            if (period.getPaymentDate().isBefore(provider.getValuationDate()) || (forecastValue = this.paymentPeriodPricer.forecastValue(period, provider)) == 0.0) continue;
            Currency currency = period.getCurrency();
            LocalDate paymentDate = period.getPaymentDate();
            double discountFactor = provider.discountFactor(currency, paymentDate);
            CashFlow singleCashFlow = CashFlow.ofForecastValue((LocalDate)paymentDate, (Currency)currency, (double)forecastValue, (double)discountFactor);
            builder.add((Object)singleCashFlow);
        }
        return CashFlows.of((List)builder.build());
    }

    CashFlows cashFlowEventsInternal(ResolvedSwapLeg leg, RatesProvider provider) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SwapPaymentEvent event : leg.getPaymentEvents()) {
            double forecastValue;
            if (event.getPaymentDate().isBefore(provider.getValuationDate()) || (forecastValue = this.paymentEventPricer.forecastValue(event, provider)) == 0.0) continue;
            Currency currency = event.getCurrency();
            LocalDate paymentDate = event.getPaymentDate();
            double discountFactor = provider.discountFactor(currency, paymentDate);
            CashFlow singleCashFlow = CashFlow.ofForecastValue((LocalDate)paymentDate, (Currency)currency, (double)forecastValue, (double)discountFactor);
            builder.add((Object)singleCashFlow);
        }
        return CashFlows.of((List)builder.build());
    }

    void explainPresentValueInternal(ResolvedSwapLeg leg, RatesProvider provider, ExplainMapBuilder builder) {
        builder.put(ExplainKey.ENTRY_TYPE, (Object)"Leg");
        builder.put(ExplainKey.PAY_RECEIVE, (Object)leg.getPayReceive());
        builder.put(ExplainKey.LEG_TYPE, (Object)leg.getType().toString());
        for (SwapPaymentPeriod period : leg.getPaymentPeriods()) {
            builder.addListEntry(ExplainKey.PAYMENT_PERIODS, child -> this.paymentPeriodPricer.explainPresentValue(period, provider, (ExplainMapBuilder)child));
        }
        for (SwapPaymentEvent event : leg.getPaymentEvents()) {
            builder.addListEntry(ExplainKey.PAYMENT_EVENTS, child -> this.paymentEventPricer.explainPresentValue(event, provider, (ExplainMapBuilder)child));
        }
        builder.put(ExplainKey.FORECAST_VALUE, (Object)this.forecastValue(leg, provider));
        builder.put(ExplainKey.PRESENT_VALUE, (Object)this.presentValue(leg, provider));
    }

    public ExplainMap explainPresentValue(ResolvedSwapLeg leg, RatesProvider provider) {
        ExplainMapBuilder builder = ExplainMap.builder();
        this.explainPresentValueInternal(leg, provider, builder);
        return builder.build();
    }

    public MultiCurrencyAmount currencyExposure(ResolvedSwapLeg leg, RatesProvider provider) {
        return this.currencyExposurePeriodsInternal(leg, provider).plus(this.currencyExposureEventsInternal(leg, provider));
    }

    private MultiCurrencyAmount currencyExposurePeriodsInternal(ResolvedSwapLeg leg, RatesProvider provider) {
        MultiCurrencyAmount total = MultiCurrencyAmount.empty();
        for (SwapPaymentPeriod period : leg.getPaymentPeriods()) {
            if (period.getPaymentDate().isBefore(provider.getValuationDate())) continue;
            total = total.plus(this.paymentPeriodPricer.currencyExposure(period, provider));
        }
        return total;
    }

    private MultiCurrencyAmount currencyExposureEventsInternal(ResolvedSwapLeg leg, RatesProvider provider) {
        MultiCurrencyAmount total = MultiCurrencyAmount.empty();
        for (SwapPaymentEvent event : leg.getPaymentEvents()) {
            if (event.getPaymentDate().isBefore(provider.getValuationDate())) continue;
            total = total.plus(this.paymentEventPricer.currencyExposure(event, provider));
        }
        return total;
    }

    public CurrencyAmount currentCash(ResolvedSwapLeg leg, RatesProvider provider) {
        return CurrencyAmount.of((Currency)leg.getCurrency(), (double)(this.currentCashPeriodsInternal(leg, provider) + this.currentCashEventsInternal(leg, provider)));
    }

    private double currentCashPeriodsInternal(ResolvedSwapLeg leg, RatesProvider provider) {
        double total = 0.0;
        for (SwapPaymentPeriod period : leg.getPaymentPeriods()) {
            if (period.getPaymentDate().isBefore(provider.getValuationDate())) continue;
            total += this.paymentPeriodPricer.currentCash(period, provider);
        }
        return total;
    }

    private double currentCashEventsInternal(ResolvedSwapLeg leg, RatesProvider provider) {
        double total = 0.0;
        for (SwapPaymentEvent event : leg.getPaymentEvents()) {
            if (event.getPaymentDate().isBefore(provider.getValuationDate())) continue;
            total += this.paymentEventPricer.currentCash(event, provider);
        }
        return total;
    }
}

