/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.swap;

import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.impl.swap.DispatchingSwapPaymentEventPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.swap.SwapPaymentEvent;

public interface SwapPaymentEventPricer<T extends SwapPaymentEvent> {
    public static SwapPaymentEventPricer<SwapPaymentEvent> standard() {
        return DispatchingSwapPaymentEventPricer.DEFAULT;
    }

    public double presentValue(T var1, RatesProvider var2);

    public PointSensitivityBuilder presentValueSensitivity(T var1, RatesProvider var2);

    public double forecastValue(T var1, RatesProvider var2);

    public PointSensitivityBuilder forecastValueSensitivity(T var1, RatesProvider var2);

    public void explainPresentValue(T var1, RatesProvider var2, ExplainMapBuilder var3);

    public MultiCurrencyAmount currencyExposure(T var1, RatesProvider var2);

    public double currentCash(T var1, RatesProvider var2);
}

