/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.swap;

import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.impl.swap.DispatchingSwapPaymentPeriodPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.swap.SwapPaymentPeriod;

public interface SwapPaymentPeriodPricer<T extends SwapPaymentPeriod> {
    public static SwapPaymentPeriodPricer<SwapPaymentPeriod> standard() {
        return DispatchingSwapPaymentPeriodPricer.DEFAULT;
    }

    public double presentValue(T var1, RatesProvider var2);

    public PointSensitivityBuilder presentValueSensitivity(T var1, RatesProvider var2);

    public double forecastValue(T var1, RatesProvider var2);

    public PointSensitivityBuilder forecastValueSensitivity(T var1, RatesProvider var2);

    public double pvbp(T var1, RatesProvider var2);

    public PointSensitivityBuilder pvbpSensitivity(T var1, RatesProvider var2);

    public double accruedInterest(T var1, RatesProvider var2);

    public void explainPresentValue(T var1, RatesProvider var2, ExplainMapBuilder var3);

    public MultiCurrencyAmount currencyExposure(T var1, RatesProvider var2);

    public double currentCash(T var1, RatesProvider var2);
}

