/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.swaption;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountingPaymentPricer;
import com.opengamma.strata.pricer.model.HullWhiteOneFactorPiecewiseConstantParametersProvider;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swaption.HullWhiteSwaptionPhysicalProductPricer;
import com.opengamma.strata.product.swaption.ResolvedSwaption;
import com.opengamma.strata.product.swaption.ResolvedSwaptionTrade;
import java.time.LocalDate;

public class HullWhiteSwaptionPhysicalTradePricer {
    public static final HullWhiteSwaptionPhysicalTradePricer DEFAULT = new HullWhiteSwaptionPhysicalTradePricer();
    private static final HullWhiteSwaptionPhysicalProductPricer PRICER_PRODUCT = HullWhiteSwaptionPhysicalProductPricer.DEFAULT;
    private static final DiscountingPaymentPricer PRICER_PREMIUM = DiscountingPaymentPricer.DEFAULT;

    public CurrencyAmount presentValue(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, HullWhiteOneFactorPiecewiseConstantParametersProvider hwProvider) {
        ResolvedSwaption product = trade.getProduct();
        CurrencyAmount pvProduct = PRICER_PRODUCT.presentValue(product, ratesProvider, hwProvider);
        Payment premium = trade.getPremium();
        CurrencyAmount pvPremium = PRICER_PREMIUM.presentValue(premium, ratesProvider);
        return pvProduct.plus(pvPremium);
    }

    public MultiCurrencyAmount currencyExposure(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, HullWhiteOneFactorPiecewiseConstantParametersProvider hwProvider) {
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{this.presentValue(trade, ratesProvider, hwProvider)});
    }

    public CurrencyAmount currentCash(ResolvedSwaptionTrade trade, LocalDate valuationDate) {
        Payment premium = trade.getPremium();
        if (premium.getDate().equals(valuationDate)) {
            return CurrencyAmount.of((Currency)premium.getCurrency(), (double)premium.getAmount());
        }
        return CurrencyAmount.of((Currency)premium.getCurrency(), (double)0.0);
    }

    public PointSensitivities presentValueSensitivityRates(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, HullWhiteOneFactorPiecewiseConstantParametersProvider hwProvider) {
        ResolvedSwaption product = trade.getProduct();
        PointSensitivityBuilder pvcsProduct = PRICER_PRODUCT.presentValueSensitivityRates(product, ratesProvider, hwProvider);
        Payment premium = trade.getPremium();
        PointSensitivityBuilder pvcsPremium = PRICER_PREMIUM.presentValueSensitivity(premium, ratesProvider);
        return pvcsProduct.combinedWith(pvcsPremium).build();
    }

    public DoubleArray presentValueSensitivityModelParamsHullWhite(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, HullWhiteOneFactorPiecewiseConstantParametersProvider hwProvider) {
        ResolvedSwaption product = trade.getProduct();
        return PRICER_PRODUCT.presentValueSensitivityModelParamsHullWhite(product, ratesProvider, hwProvider);
    }
}

