/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.swaption;

import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.surface.Surface;
import com.opengamma.strata.market.surface.SurfaceInfoType;
import com.opengamma.strata.pricer.impl.option.NormalFormulaRepository;
import com.opengamma.strata.pricer.swaption.NormalSwaptionVolatilities;
import com.opengamma.strata.pricer.swaption.SwaptionSensitivity;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilitiesName;
import com.opengamma.strata.product.common.PutCall;
import com.opengamma.strata.product.swap.type.FixedFloatSwapConvention;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalInt;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class NormalSwaptionExpiryTenorVolatilities
implements NormalSwaptionVolatilities,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final FixedFloatSwapConvention convention;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ZonedDateTime valuationDateTime;
    @PropertyDefinition(validate="notNull")
    private final Surface surface;
    private final transient DayCount dayCount;
    private static final long serialVersionUID = 1L;

    public static NormalSwaptionExpiryTenorVolatilities of(FixedFloatSwapConvention convention, ZonedDateTime valuationDateTime, Surface surface) {
        return new NormalSwaptionExpiryTenorVolatilities(convention, valuationDateTime, surface);
    }

    @ImmutableConstructor
    private NormalSwaptionExpiryTenorVolatilities(FixedFloatSwapConvention convention, ZonedDateTime valuationDateTime, Surface surface) {
        ArgChecker.notNull((Object)convention, (String)"convention");
        ArgChecker.notNull((Object)valuationDateTime, (String)"valuationDateTime");
        ArgChecker.notNull((Object)surface, (String)"surface");
        surface.getMetadata().getXValueType().checkEquals(ValueType.YEAR_FRACTION, "Incorrect x-value type for Normal volatilities");
        surface.getMetadata().getYValueType().checkEquals(ValueType.YEAR_FRACTION, "Incorrect y-value type for Normal volatilities");
        surface.getMetadata().getZValueType().checkEquals(ValueType.NORMAL_VOLATILITY, "Incorrect z-value type for Normal volatilities");
        DayCount dayCount = (DayCount)surface.getMetadata().findInfo(SurfaceInfoType.DAY_COUNT).orElseThrow(() -> new IllegalArgumentException("Incorrect surface metadata, missing DayCount"));
        this.valuationDateTime = valuationDateTime;
        this.surface = surface;
        this.convention = convention;
        this.dayCount = dayCount;
    }

    private Object readResolve() {
        return new NormalSwaptionExpiryTenorVolatilities(this.convention, this.valuationDateTime, this.surface);
    }

    @Override
    public SwaptionVolatilitiesName getName() {
        return SwaptionVolatilitiesName.of(this.surface.getName().getName());
    }

    public <T> Optional<T> findData(MarketDataName<T> name) {
        if (this.surface.getName().equals(name)) {
            return Optional.of(name.getMarketDataType().cast(this.surface));
        }
        return Optional.empty();
    }

    public int getParameterCount() {
        return this.surface.getParameterCount();
    }

    public double getParameter(int parameterIndex) {
        return this.surface.getParameter(parameterIndex);
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.surface.getParameterMetadata(parameterIndex);
    }

    public OptionalInt findParameterIndex(ParameterMetadata metadata) {
        return this.surface.findParameterIndex(metadata);
    }

    @Override
    public NormalSwaptionExpiryTenorVolatilities withParameter(int parameterIndex, double newValue) {
        return new NormalSwaptionExpiryTenorVolatilities(this.convention, this.valuationDateTime, this.surface.withParameter(parameterIndex, newValue));
    }

    @Override
    public NormalSwaptionExpiryTenorVolatilities withPerturbation(ParameterPerturbation perturbation) {
        return new NormalSwaptionExpiryTenorVolatilities(this.convention, this.valuationDateTime, this.surface.withPerturbation(perturbation));
    }

    @Override
    public double volatility(double expiry, double tenor, double strike, double forwardRate) {
        return this.surface.zValue(expiry, tenor);
    }

    @Override
    public CurrencyParameterSensitivities parameterSensitivity(PointSensitivities pointSensitivities) {
        CurrencyParameterSensitivities sens = CurrencyParameterSensitivities.empty();
        for (PointSensitivity point : pointSensitivities.getSensitivities()) {
            SwaptionSensitivity pt;
            if (!(point instanceof SwaptionSensitivity) || !(pt = (SwaptionSensitivity)point).getVolatilitiesName().equals(this.getName())) continue;
            sens = sens.combinedWith(this.parameterSensitivity(pt));
        }
        return sens;
    }

    private CurrencyParameterSensitivity parameterSensitivity(SwaptionSensitivity point) {
        double expiry = point.getExpiry();
        double tenor = point.getTenor();
        UnitParameterSensitivity unitSens = this.surface.zValueParameterSensitivity(expiry, tenor);
        return unitSens.multipliedBy(point.getCurrency(), point.getSensitivity());
    }

    @Override
    public double price(double expiry, double tenor, PutCall putCall, double strike, double forward, double volatility) {
        return NormalFormulaRepository.price(forward, strike, expiry, volatility, putCall);
    }

    @Override
    public double priceDelta(double expiry, double tenor, PutCall putCall, double strike, double forward, double volatility) {
        return NormalFormulaRepository.delta(forward, strike, expiry, volatility, putCall);
    }

    @Override
    public double priceGamma(double expiry, double tenor, PutCall putCall, double strike, double forward, double volatility) {
        return NormalFormulaRepository.gamma(forward, strike, expiry, volatility, putCall);
    }

    @Override
    public double priceTheta(double expiry, double tenor, PutCall putCall, double strike, double forward, double volatility) {
        return NormalFormulaRepository.theta(forward, strike, expiry, volatility, putCall);
    }

    @Override
    public double priceVega(double expiry, double tenor, PutCall putCall, double strike, double forward, double volatility) {
        return NormalFormulaRepository.vega(forward, strike, expiry, volatility, putCall);
    }

    @Override
    public double relativeTime(ZonedDateTime dateTime) {
        ArgChecker.notNull((Object)dateTime, (String)"dateTime");
        LocalDate valuationDate = this.valuationDateTime.toLocalDate();
        LocalDate date = dateTime.toLocalDate();
        return this.dayCount.relativeYearFraction(valuationDate, date);
    }

    @Override
    public double tenor(LocalDate startDate, LocalDate endDate) {
        return Math.round((double)(endDate.toEpochDay() - startDate.toEpochDay()) / 365.25 * 12.0) / 12L;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public FixedFloatSwapConvention getConvention() {
        return this.convention;
    }

    @Override
    public ZonedDateTime getValuationDateTime() {
        return this.valuationDateTime;
    }

    public Surface getSurface() {
        return this.surface;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            NormalSwaptionExpiryTenorVolatilities other = (NormalSwaptionExpiryTenorVolatilities)obj;
            return JodaBeanUtils.equal((Object)this.convention, (Object)other.convention) && JodaBeanUtils.equal((Object)this.valuationDateTime, (Object)other.valuationDateTime) && JodaBeanUtils.equal((Object)this.surface, (Object)other.surface);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.convention);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.valuationDateTime);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.surface);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("NormalSwaptionExpiryTenorVolatilities{");
        buf.append("convention").append('=').append(JodaBeanUtils.toString((Object)this.convention)).append(',').append(' ');
        buf.append("valuationDateTime").append('=').append(JodaBeanUtils.toString((Object)this.valuationDateTime)).append(',').append(' ');
        buf.append("surface").append('=').append(JodaBeanUtils.toString((Object)this.surface));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<NormalSwaptionExpiryTenorVolatilities> {
        private FixedFloatSwapConvention convention;
        private ZonedDateTime valuationDateTime;
        private Surface surface;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 2039569265: {
                    return this.convention;
                }
                case -949589828: {
                    return this.valuationDateTime;
                }
                case -1853231955: {
                    return this.surface;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 2039569265: {
                    this.convention = (FixedFloatSwapConvention)newValue;
                    break;
                }
                case -949589828: {
                    this.valuationDateTime = (ZonedDateTime)newValue;
                    break;
                }
                case -1853231955: {
                    this.surface = (Surface)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public NormalSwaptionExpiryTenorVolatilities build() {
            return new NormalSwaptionExpiryTenorVolatilities(this.convention, this.valuationDateTime, this.surface);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("NormalSwaptionExpiryTenorVolatilities.Builder{");
            buf.append("convention").append('=').append(JodaBeanUtils.toString((Object)this.convention)).append(',').append(' ');
            buf.append("valuationDateTime").append('=').append(JodaBeanUtils.toString((Object)this.valuationDateTime)).append(',').append(' ');
            buf.append("surface").append('=').append(JodaBeanUtils.toString((Object)this.surface));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<FixedFloatSwapConvention> convention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"convention", NormalSwaptionExpiryTenorVolatilities.class, FixedFloatSwapConvention.class);
        private final MetaProperty<ZonedDateTime> valuationDateTime = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valuationDateTime", NormalSwaptionExpiryTenorVolatilities.class, ZonedDateTime.class);
        private final MetaProperty<Surface> surface = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"surface", NormalSwaptionExpiryTenorVolatilities.class, Surface.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"convention", "valuationDateTime", "surface"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 2039569265: {
                    return this.convention;
                }
                case -949589828: {
                    return this.valuationDateTime;
                }
                case -1853231955: {
                    return this.surface;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends NormalSwaptionExpiryTenorVolatilities> builder() {
            return new Builder();
        }

        public Class<? extends NormalSwaptionExpiryTenorVolatilities> beanType() {
            return NormalSwaptionExpiryTenorVolatilities.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<FixedFloatSwapConvention> convention() {
            return this.convention;
        }

        public MetaProperty<ZonedDateTime> valuationDateTime() {
            return this.valuationDateTime;
        }

        public MetaProperty<Surface> surface() {
            return this.surface;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 2039569265: {
                    return ((NormalSwaptionExpiryTenorVolatilities)bean).getConvention();
                }
                case -949589828: {
                    return ((NormalSwaptionExpiryTenorVolatilities)bean).getValuationDateTime();
                }
                case -1853231955: {
                    return ((NormalSwaptionExpiryTenorVolatilities)bean).getSurface();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

