/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.swaption;

import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.pricer.impl.option.NormalFormulaRepository;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.DiscountingSwapProductPricer;
import com.opengamma.strata.pricer.swaption.VolatilitySwaptionPhysicalProductPricer;
import com.opengamma.strata.product.common.PutCall;
import com.opengamma.strata.product.swap.ResolvedSwap;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;
import com.opengamma.strata.product.swaption.ResolvedSwaption;
import java.time.LocalDate;

public class NormalSwaptionPhysicalProductPricer
extends VolatilitySwaptionPhysicalProductPricer {
    public static final NormalSwaptionPhysicalProductPricer DEFAULT = new NormalSwaptionPhysicalProductPricer(DiscountingSwapProductPricer.DEFAULT);

    public NormalSwaptionPhysicalProductPricer(DiscountingSwapProductPricer swapPricer) {
        super(swapPricer);
    }

    public double impliedVolatilityFromPresentValue(ResolvedSwaption swaption, RatesProvider ratesProvider, DayCount dayCount, double presentValue) {
        double sign = swaption.getLongShort().sign();
        ArgChecker.isTrue((presentValue * sign > 0.0 ? 1 : 0) != 0, (String)"Present value sign must be in line with the option Long/Short flag ");
        this.validateSwaption(swaption);
        LocalDate valuationDate = ratesProvider.getValuationDate();
        LocalDate expiryDate = swaption.getExpiryDate();
        ArgChecker.isTrue((boolean)expiryDate.isAfter(valuationDate), (String)"Expiry must be after valuation date to compute an implied volatility");
        double expiry = dayCount.yearFraction(valuationDate, expiryDate);
        ResolvedSwap underlying = swaption.getUnderlying();
        ResolvedSwapLeg fixedLeg = this.fixedLeg(underlying);
        double forward = this.forwardRate(swaption, ratesProvider);
        double pvbp = this.getSwapPricer().getLegPricer().pvbp(fixedLeg, ratesProvider);
        double numeraire = Math.abs(pvbp);
        double strike = this.getSwapPricer().getLegPricer().couponEquivalent(fixedLeg, ratesProvider, pvbp);
        PutCall putCall = PutCall.ofPut((boolean)fixedLeg.getPayReceive().isReceive());
        return NormalFormulaRepository.impliedVolatility(Math.abs(presentValue), forward, strike, expiry, 0.01, numeraire, putCall);
    }
}

