/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.swaption;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountingPaymentPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swaption.NormalSwaptionCashParYieldProductPricer;
import com.opengamma.strata.pricer.swaption.NormalSwaptionPhysicalProductPricer;
import com.opengamma.strata.pricer.swaption.NormalSwaptionVolatilities;
import com.opengamma.strata.pricer.swaption.SwaptionSensitivity;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilities;
import com.opengamma.strata.product.common.SettlementType;
import com.opengamma.strata.product.swaption.ResolvedSwaption;
import com.opengamma.strata.product.swaption.ResolvedSwaptionTrade;
import java.time.LocalDate;

public class NormalSwaptionTradePricer {
    public static final NormalSwaptionTradePricer DEFAULT = new NormalSwaptionTradePricer(NormalSwaptionCashParYieldProductPricer.DEFAULT, NormalSwaptionPhysicalProductPricer.DEFAULT, DiscountingPaymentPricer.DEFAULT);
    private final NormalSwaptionCashParYieldProductPricer cashParYieldPricer;
    private final NormalSwaptionPhysicalProductPricer physicalPricer;
    private final DiscountingPaymentPricer paymentPricer;

    public NormalSwaptionTradePricer(NormalSwaptionCashParYieldProductPricer cashParYieldPricer, NormalSwaptionPhysicalProductPricer physicalPricer, DiscountingPaymentPricer paymentPricer) {
        this.cashParYieldPricer = (NormalSwaptionCashParYieldProductPricer)ArgChecker.notNull((Object)cashParYieldPricer, (String)"cashParYieldPricer");
        this.physicalPricer = (NormalSwaptionPhysicalProductPricer)ArgChecker.notNull((Object)physicalPricer, (String)"physicalPricer");
        this.paymentPricer = (DiscountingPaymentPricer)ArgChecker.notNull((Object)paymentPricer, (String)"paymentPricer");
    }

    public CurrencyAmount presentValue(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, NormalSwaptionVolatilities swaptionVolatilities) {
        ResolvedSwaption product = trade.getProduct();
        CurrencyAmount pvProduct = this.isCash(product) ? this.cashParYieldPricer.presentValue(product, ratesProvider, swaptionVolatilities) : this.physicalPricer.presentValue(product, ratesProvider, swaptionVolatilities);
        Payment premium = trade.getPremium();
        CurrencyAmount pvPremium = this.paymentPricer.presentValue(premium, ratesProvider);
        return pvProduct.plus(pvPremium);
    }

    public PointSensitivities presentValueSensitivityRatesStickyStrike(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, NormalSwaptionVolatilities swaptionVolatilities) {
        ResolvedSwaption product = trade.getProduct();
        PointSensitivityBuilder pointSens = this.isCash(product) ? this.cashParYieldPricer.presentValueSensitivityRatesStickyStrike(product, ratesProvider, swaptionVolatilities) : this.physicalPricer.presentValueSensitivityRatesStickyStrike(product, ratesProvider, swaptionVolatilities);
        Payment premium = trade.getPremium();
        PointSensitivityBuilder pvcsPremium = this.paymentPricer.presentValueSensitivity(premium, ratesProvider);
        return pointSens.combinedWith(pvcsPremium).build();
    }

    public PointSensitivities presentValueSensitivityModelParamsVolatility(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, NormalSwaptionVolatilities swaptionVolatilities) {
        ResolvedSwaption product = trade.getProduct();
        SwaptionSensitivity pointSens = this.isCash(product) ? this.cashParYieldPricer.presentValueSensitivityModelParamsVolatility(product, ratesProvider, swaptionVolatilities) : this.physicalPricer.presentValueSensitivityModelParamsVolatility(product, ratesProvider, swaptionVolatilities);
        return PointSensitivities.of((PointSensitivity[])new PointSensitivity[]{pointSens});
    }

    public MultiCurrencyAmount currencyExposure(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, NormalSwaptionVolatilities swaptionVolatilities) {
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{this.presentValue(trade, ratesProvider, swaptionVolatilities)});
    }

    public double impliedVolatility(ResolvedSwaptionTrade swaptionTrade, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        ResolvedSwaption product = swaptionTrade.getProduct();
        if (this.isCash(product)) {
            return this.cashParYieldPricer.impliedVolatility(product, ratesProvider, swaptionVolatilities);
        }
        return this.physicalPricer.impliedVolatility(product, ratesProvider, swaptionVolatilities);
    }

    public double forwardRate(ResolvedSwaptionTrade swaptionTrade, RatesProvider ratesProvider) {
        ResolvedSwaption product = swaptionTrade.getProduct();
        if (this.isCash(product)) {
            return this.cashParYieldPricer.forwardRate(product, ratesProvider);
        }
        return this.physicalPricer.forwardRate(product, ratesProvider);
    }

    public CurrencyAmount currentCash(ResolvedSwaptionTrade trade, LocalDate valuationDate) {
        Payment premium = trade.getPremium();
        if (premium.getDate().equals(valuationDate)) {
            return CurrencyAmount.of((Currency)premium.getCurrency(), (double)premium.getAmount());
        }
        return CurrencyAmount.of((Currency)premium.getCurrency(), (double)0.0);
    }

    private boolean isCash(ResolvedSwaption product) {
        return product.getSwaptionSettlement().getSettlementType().equals((Object)SettlementType.CASH);
    }
}

