/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.swaption;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.model.SabrParameterType;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.surface.Surface;
import com.opengamma.strata.pricer.impl.option.BlackFormulaRepository;
import com.opengamma.strata.pricer.model.SabrInterestRateParameters;
import com.opengamma.strata.pricer.swaption.BlackSabrSwaptionVolatilities;
import com.opengamma.strata.pricer.swaption.SwaptionSabrSensitivity;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilitiesName;
import com.opengamma.strata.product.common.PutCall;
import com.opengamma.strata.product.swap.type.FixedFloatSwapConvention;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class SabrParametersSwaptionVolatilities
implements BlackSabrSwaptionVolatilities,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final SwaptionVolatilitiesName name;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final FixedFloatSwapConvention convention;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ZonedDateTime valuationDateTime;
    @PropertyDefinition(validate="notNull")
    private final SabrInterestRateParameters parameters;
    @PropertyDefinition(get="optional")
    private final ImmutableList<DoubleArray> dataSensitivityAlpha;
    @PropertyDefinition(get="optional")
    private final ImmutableList<DoubleArray> dataSensitivityBeta;
    @PropertyDefinition(get="optional")
    private final ImmutableList<DoubleArray> dataSensitivityRho;
    @PropertyDefinition(get="optional")
    private final ImmutableList<DoubleArray> dataSensitivityNu;
    private static final long serialVersionUID = 1L;

    public static SabrParametersSwaptionVolatilities of(SwaptionVolatilitiesName name, FixedFloatSwapConvention convention, ZonedDateTime valuationDateTime, SabrInterestRateParameters parameters) {
        return new SabrParametersSwaptionVolatilities(name, convention, valuationDateTime, parameters, null, null, null, null);
    }

    public DayCount getDayCount() {
        return this.getParameters().getDayCount();
    }

    public <T> Optional<T> findData(MarketDataName<T> name) {
        if (this.parameters.getAlphaSurface().getName().equals(name)) {
            return Optional.of(name.getMarketDataType().cast(this.parameters.getAlphaSurface()));
        }
        if (this.parameters.getBetaSurface().getName().equals(name)) {
            return Optional.of(name.getMarketDataType().cast(this.parameters.getBetaSurface()));
        }
        if (this.parameters.getRhoSurface().getName().equals(name)) {
            return Optional.of(name.getMarketDataType().cast(this.parameters.getRhoSurface()));
        }
        if (this.parameters.getNuSurface().getName().equals(name)) {
            return Optional.of(name.getMarketDataType().cast(this.parameters.getNuSurface()));
        }
        if (this.parameters.getShiftSurface().getName().equals(name)) {
            return Optional.of(name.getMarketDataType().cast(this.parameters.getShiftSurface()));
        }
        return Optional.empty();
    }

    public int getParameterCount() {
        return this.parameters.getParameterCount();
    }

    public double getParameter(int parameterIndex) {
        return this.parameters.getParameter(parameterIndex);
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.parameters.getParameterMetadata(parameterIndex);
    }

    @Override
    public SabrParametersSwaptionVolatilities withParameter(int parameterIndex, double newValue) {
        SabrInterestRateParameters updated = this.parameters.withParameter(parameterIndex, newValue);
        return new SabrParametersSwaptionVolatilities(this.name, this.convention, this.valuationDateTime, updated, (List<DoubleArray>)this.dataSensitivityAlpha, (List<DoubleArray>)this.dataSensitivityBeta, (List<DoubleArray>)this.dataSensitivityRho, (List<DoubleArray>)this.dataSensitivityNu);
    }

    @Override
    public SabrParametersSwaptionVolatilities withPerturbation(ParameterPerturbation perturbation) {
        SabrInterestRateParameters updated = this.parameters.withPerturbation(perturbation);
        return new SabrParametersSwaptionVolatilities(this.name, this.convention, this.valuationDateTime, updated, (List<DoubleArray>)this.dataSensitivityAlpha, (List<DoubleArray>)this.dataSensitivityBeta, (List<DoubleArray>)this.dataSensitivityRho, (List<DoubleArray>)this.dataSensitivityNu);
    }

    @Override
    public double volatility(double expiry, double tenor, double strike, double forwardRate) {
        return this.parameters.volatility(expiry, tenor, strike, forwardRate);
    }

    @Override
    public ValueDerivatives volatilityAdjoint(double expiry, double tenor, double strike, double forward) {
        return this.parameters.volatilityAdjoint(expiry, tenor, strike, forward);
    }

    @Override
    public double alpha(double expiry, double tenor) {
        return this.parameters.alpha(expiry, tenor);
    }

    @Override
    public double beta(double expiry, double tenor) {
        return this.parameters.beta(expiry, tenor);
    }

    @Override
    public double rho(double expiry, double tenor) {
        return this.parameters.rho(expiry, tenor);
    }

    @Override
    public double nu(double expiry, double tenor) {
        return this.parameters.nu(expiry, tenor);
    }

    @Override
    public double shift(double expiry, double tenor) {
        return this.parameters.shift(expiry, tenor);
    }

    @Override
    public CurrencyParameterSensitivities parameterSensitivity(PointSensitivities pointSensitivities) {
        CurrencyParameterSensitivities sens = CurrencyParameterSensitivities.empty();
        for (PointSensitivity point : pointSensitivities.getSensitivities()) {
            SwaptionSabrSensitivity pt;
            if (!(point instanceof SwaptionSabrSensitivity) || !(pt = (SwaptionSabrSensitivity)point).getVolatilitiesName().equals(this.getName())) continue;
            sens = sens.combinedWith(this.parameterSensitivity(pt));
        }
        return sens;
    }

    private CurrencyParameterSensitivity parameterSensitivity(SwaptionSabrSensitivity point) {
        Surface surface = this.getSurface(point.getSensitivityType());
        double expiry = point.getExpiry();
        UnitParameterSensitivity unitSens = surface.zValueParameterSensitivity(expiry, point.getTenor());
        return unitSens.multipliedBy(point.getCurrency(), point.getSensitivity());
    }

    private Surface getSurface(SabrParameterType type) {
        switch (type) {
            case ALPHA: {
                return this.parameters.getAlphaSurface();
            }
            case BETA: {
                return this.parameters.getBetaSurface();
            }
            case RHO: {
                return this.parameters.getRhoSurface();
            }
            case NU: {
                return this.parameters.getNuSurface();
            }
            case SHIFT: {
                return this.parameters.getShiftSurface();
            }
        }
        throw new IllegalStateException("Invalid enum value");
    }

    @Override
    public double price(double expiry, double tenor, PutCall putCall, double strike, double forward, double volatility) {
        double shift = this.parameters.shift(expiry, tenor);
        return BlackFormulaRepository.price(forward + shift, strike + shift, expiry, volatility, putCall.isCall());
    }

    @Override
    public double priceDelta(double expiry, double tenor, PutCall putCall, double strike, double forward, double volatility) {
        double shift = this.parameters.shift(expiry, tenor);
        return BlackFormulaRepository.delta(forward + shift, strike + shift, expiry, volatility, putCall.isCall());
    }

    @Override
    public double priceGamma(double expiry, double tenor, PutCall putCall, double strike, double forward, double volatility) {
        double shift = this.parameters.shift(expiry, tenor);
        return BlackFormulaRepository.gamma(forward + shift, strike + shift, expiry, volatility);
    }

    @Override
    public double priceTheta(double expiry, double tenor, PutCall putCall, double strike, double forward, double volatility) {
        double shift = this.parameters.shift(expiry, tenor);
        return BlackFormulaRepository.driftlessTheta(forward + shift, strike + shift, expiry, volatility);
    }

    @Override
    public double priceVega(double expiry, double tenor, PutCall putCall, double strike, double forward, double volatility) {
        double shift = this.parameters.shift(expiry, tenor);
        return BlackFormulaRepository.vega(forward + shift, strike + shift, expiry, volatility);
    }

    @Override
    public double relativeTime(ZonedDateTime dateTime) {
        ArgChecker.notNull((Object)dateTime, (String)"dateTime");
        LocalDate valuationDate = this.valuationDateTime.toLocalDate();
        LocalDate date = dateTime.toLocalDate();
        return this.getDayCount().relativeYearFraction(valuationDate, date);
    }

    @Override
    public double tenor(LocalDate startDate, LocalDate endDate) {
        return Math.round((double)(endDate.toEpochDay() - startDate.toEpochDay()) / 365.25 * 12.0) / 12L;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private SabrParametersSwaptionVolatilities(SwaptionVolatilitiesName name, FixedFloatSwapConvention convention, ZonedDateTime valuationDateTime, SabrInterestRateParameters parameters, List<DoubleArray> dataSensitivityAlpha, List<DoubleArray> dataSensitivityBeta, List<DoubleArray> dataSensitivityRho, List<DoubleArray> dataSensitivityNu) {
        JodaBeanUtils.notNull((Object)name, (String)"name");
        JodaBeanUtils.notNull((Object)convention, (String)"convention");
        JodaBeanUtils.notNull((Object)valuationDateTime, (String)"valuationDateTime");
        JodaBeanUtils.notNull((Object)parameters, (String)"parameters");
        this.name = name;
        this.convention = convention;
        this.valuationDateTime = valuationDateTime;
        this.parameters = parameters;
        this.dataSensitivityAlpha = dataSensitivityAlpha != null ? ImmutableList.copyOf(dataSensitivityAlpha) : null;
        this.dataSensitivityBeta = dataSensitivityBeta != null ? ImmutableList.copyOf(dataSensitivityBeta) : null;
        this.dataSensitivityRho = dataSensitivityRho != null ? ImmutableList.copyOf(dataSensitivityRho) : null;
        this.dataSensitivityNu = dataSensitivityNu != null ? ImmutableList.copyOf(dataSensitivityNu) : null;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public SwaptionVolatilitiesName getName() {
        return this.name;
    }

    @Override
    public FixedFloatSwapConvention getConvention() {
        return this.convention;
    }

    @Override
    public ZonedDateTime getValuationDateTime() {
        return this.valuationDateTime;
    }

    public SabrInterestRateParameters getParameters() {
        return this.parameters;
    }

    public Optional<ImmutableList<DoubleArray>> getDataSensitivityAlpha() {
        return Optional.ofNullable(this.dataSensitivityAlpha);
    }

    public Optional<ImmutableList<DoubleArray>> getDataSensitivityBeta() {
        return Optional.ofNullable(this.dataSensitivityBeta);
    }

    public Optional<ImmutableList<DoubleArray>> getDataSensitivityRho() {
        return Optional.ofNullable(this.dataSensitivityRho);
    }

    public Optional<ImmutableList<DoubleArray>> getDataSensitivityNu() {
        return Optional.ofNullable(this.dataSensitivityNu);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SabrParametersSwaptionVolatilities other = (SabrParametersSwaptionVolatilities)obj;
            return JodaBeanUtils.equal((Object)this.name, (Object)other.name) && JodaBeanUtils.equal((Object)this.convention, (Object)other.convention) && JodaBeanUtils.equal((Object)this.valuationDateTime, (Object)other.valuationDateTime) && JodaBeanUtils.equal((Object)this.parameters, (Object)other.parameters) && JodaBeanUtils.equal(this.dataSensitivityAlpha, other.dataSensitivityAlpha) && JodaBeanUtils.equal(this.dataSensitivityBeta, other.dataSensitivityBeta) && JodaBeanUtils.equal(this.dataSensitivityRho, other.dataSensitivityRho) && JodaBeanUtils.equal(this.dataSensitivityNu, other.dataSensitivityNu);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.convention);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.valuationDateTime);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.parameters);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.dataSensitivityAlpha);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.dataSensitivityBeta);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.dataSensitivityRho);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.dataSensitivityNu);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(288);
        buf.append("SabrParametersSwaptionVolatilities{");
        buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
        buf.append("convention").append('=').append(JodaBeanUtils.toString((Object)this.convention)).append(',').append(' ');
        buf.append("valuationDateTime").append('=').append(JodaBeanUtils.toString((Object)this.valuationDateTime)).append(',').append(' ');
        buf.append("parameters").append('=').append(JodaBeanUtils.toString((Object)this.parameters)).append(',').append(' ');
        buf.append("dataSensitivityAlpha").append('=').append(JodaBeanUtils.toString(this.dataSensitivityAlpha)).append(',').append(' ');
        buf.append("dataSensitivityBeta").append('=').append(JodaBeanUtils.toString(this.dataSensitivityBeta)).append(',').append(' ');
        buf.append("dataSensitivityRho").append('=').append(JodaBeanUtils.toString(this.dataSensitivityRho)).append(',').append(' ');
        buf.append("dataSensitivityNu").append('=').append(JodaBeanUtils.toString(this.dataSensitivityNu));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<SabrParametersSwaptionVolatilities> {
        private SwaptionVolatilitiesName name;
        private FixedFloatSwapConvention convention;
        private ZonedDateTime valuationDateTime;
        private SabrInterestRateParameters parameters;
        private List<DoubleArray> dataSensitivityAlpha;
        private List<DoubleArray> dataSensitivityBeta;
        private List<DoubleArray> dataSensitivityRho;
        private List<DoubleArray> dataSensitivityNu;

        private Builder() {
        }

        private Builder(SabrParametersSwaptionVolatilities beanToCopy) {
            this.name = beanToCopy.getName();
            this.convention = beanToCopy.getConvention();
            this.valuationDateTime = beanToCopy.getValuationDateTime();
            this.parameters = beanToCopy.getParameters();
            this.dataSensitivityAlpha = beanToCopy.dataSensitivityAlpha;
            this.dataSensitivityBeta = beanToCopy.dataSensitivityBeta;
            this.dataSensitivityRho = beanToCopy.dataSensitivityRho;
            this.dataSensitivityNu = beanToCopy.dataSensitivityNu;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 2039569265: {
                    return this.convention;
                }
                case -949589828: {
                    return this.valuationDateTime;
                }
                case 458736106: {
                    return this.parameters;
                }
                case 1650101705: {
                    return this.dataSensitivityAlpha;
                }
                case -85295067: {
                    return this.dataSensitivityBeta;
                }
                case 967095332: {
                    return this.dataSensitivityRho;
                }
                case -1077182148: {
                    return this.dataSensitivityNu;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (SwaptionVolatilitiesName)newValue;
                    break;
                }
                case 2039569265: {
                    this.convention = (FixedFloatSwapConvention)newValue;
                    break;
                }
                case -949589828: {
                    this.valuationDateTime = (ZonedDateTime)newValue;
                    break;
                }
                case 458736106: {
                    this.parameters = (SabrInterestRateParameters)newValue;
                    break;
                }
                case 1650101705: {
                    this.dataSensitivityAlpha = (List)newValue;
                    break;
                }
                case -85295067: {
                    this.dataSensitivityBeta = (List)newValue;
                    break;
                }
                case 967095332: {
                    this.dataSensitivityRho = (List)newValue;
                    break;
                }
                case -1077182148: {
                    this.dataSensitivityNu = (List)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public SabrParametersSwaptionVolatilities build() {
            return new SabrParametersSwaptionVolatilities(this.name, this.convention, this.valuationDateTime, this.parameters, this.dataSensitivityAlpha, this.dataSensitivityBeta, this.dataSensitivityRho, this.dataSensitivityNu);
        }

        public Builder name(SwaptionVolatilitiesName name) {
            JodaBeanUtils.notNull((Object)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder convention(FixedFloatSwapConvention convention) {
            JodaBeanUtils.notNull((Object)convention, (String)"convention");
            this.convention = convention;
            return this;
        }

        public Builder valuationDateTime(ZonedDateTime valuationDateTime) {
            JodaBeanUtils.notNull((Object)valuationDateTime, (String)"valuationDateTime");
            this.valuationDateTime = valuationDateTime;
            return this;
        }

        public Builder parameters(SabrInterestRateParameters parameters) {
            JodaBeanUtils.notNull((Object)parameters, (String)"parameters");
            this.parameters = parameters;
            return this;
        }

        public Builder dataSensitivityAlpha(List<DoubleArray> dataSensitivityAlpha) {
            this.dataSensitivityAlpha = dataSensitivityAlpha;
            return this;
        }

        public Builder dataSensitivityAlpha(DoubleArray ... dataSensitivityAlpha) {
            return this.dataSensitivityAlpha((List<DoubleArray>)ImmutableList.copyOf((Object[])dataSensitivityAlpha));
        }

        public Builder dataSensitivityBeta(List<DoubleArray> dataSensitivityBeta) {
            this.dataSensitivityBeta = dataSensitivityBeta;
            return this;
        }

        public Builder dataSensitivityBeta(DoubleArray ... dataSensitivityBeta) {
            return this.dataSensitivityBeta((List<DoubleArray>)ImmutableList.copyOf((Object[])dataSensitivityBeta));
        }

        public Builder dataSensitivityRho(List<DoubleArray> dataSensitivityRho) {
            this.dataSensitivityRho = dataSensitivityRho;
            return this;
        }

        public Builder dataSensitivityRho(DoubleArray ... dataSensitivityRho) {
            return this.dataSensitivityRho((List<DoubleArray>)ImmutableList.copyOf((Object[])dataSensitivityRho));
        }

        public Builder dataSensitivityNu(List<DoubleArray> dataSensitivityNu) {
            this.dataSensitivityNu = dataSensitivityNu;
            return this;
        }

        public Builder dataSensitivityNu(DoubleArray ... dataSensitivityNu) {
            return this.dataSensitivityNu((List<DoubleArray>)ImmutableList.copyOf((Object[])dataSensitivityNu));
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(288);
            buf.append("SabrParametersSwaptionVolatilities.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("convention").append('=').append(JodaBeanUtils.toString((Object)this.convention)).append(',').append(' ');
            buf.append("valuationDateTime").append('=').append(JodaBeanUtils.toString((Object)this.valuationDateTime)).append(',').append(' ');
            buf.append("parameters").append('=').append(JodaBeanUtils.toString((Object)this.parameters)).append(',').append(' ');
            buf.append("dataSensitivityAlpha").append('=').append(JodaBeanUtils.toString(this.dataSensitivityAlpha)).append(',').append(' ');
            buf.append("dataSensitivityBeta").append('=').append(JodaBeanUtils.toString(this.dataSensitivityBeta)).append(',').append(' ');
            buf.append("dataSensitivityRho").append('=').append(JodaBeanUtils.toString(this.dataSensitivityRho)).append(',').append(' ');
            buf.append("dataSensitivityNu").append('=').append(JodaBeanUtils.toString(this.dataSensitivityNu));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SwaptionVolatilitiesName> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", SabrParametersSwaptionVolatilities.class, SwaptionVolatilitiesName.class);
        private final MetaProperty<FixedFloatSwapConvention> convention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"convention", SabrParametersSwaptionVolatilities.class, FixedFloatSwapConvention.class);
        private final MetaProperty<ZonedDateTime> valuationDateTime = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valuationDateTime", SabrParametersSwaptionVolatilities.class, ZonedDateTime.class);
        private final MetaProperty<SabrInterestRateParameters> parameters = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"parameters", SabrParametersSwaptionVolatilities.class, SabrInterestRateParameters.class);
        private final MetaProperty<ImmutableList<DoubleArray>> dataSensitivityAlpha = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dataSensitivityAlpha", SabrParametersSwaptionVolatilities.class, ImmutableList.class);
        private final MetaProperty<ImmutableList<DoubleArray>> dataSensitivityBeta = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dataSensitivityBeta", SabrParametersSwaptionVolatilities.class, ImmutableList.class);
        private final MetaProperty<ImmutableList<DoubleArray>> dataSensitivityRho = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dataSensitivityRho", SabrParametersSwaptionVolatilities.class, ImmutableList.class);
        private final MetaProperty<ImmutableList<DoubleArray>> dataSensitivityNu = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dataSensitivityNu", SabrParametersSwaptionVolatilities.class, ImmutableList.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "convention", "valuationDateTime", "parameters", "dataSensitivityAlpha", "dataSensitivityBeta", "dataSensitivityRho", "dataSensitivityNu"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 2039569265: {
                    return this.convention;
                }
                case -949589828: {
                    return this.valuationDateTime;
                }
                case 458736106: {
                    return this.parameters;
                }
                case 1650101705: {
                    return this.dataSensitivityAlpha;
                }
                case -85295067: {
                    return this.dataSensitivityBeta;
                }
                case 967095332: {
                    return this.dataSensitivityRho;
                }
                case -1077182148: {
                    return this.dataSensitivityNu;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends SabrParametersSwaptionVolatilities> beanType() {
            return SabrParametersSwaptionVolatilities.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SwaptionVolatilitiesName> name() {
            return this.name;
        }

        public MetaProperty<FixedFloatSwapConvention> convention() {
            return this.convention;
        }

        public MetaProperty<ZonedDateTime> valuationDateTime() {
            return this.valuationDateTime;
        }

        public MetaProperty<SabrInterestRateParameters> parameters() {
            return this.parameters;
        }

        public MetaProperty<ImmutableList<DoubleArray>> dataSensitivityAlpha() {
            return this.dataSensitivityAlpha;
        }

        public MetaProperty<ImmutableList<DoubleArray>> dataSensitivityBeta() {
            return this.dataSensitivityBeta;
        }

        public MetaProperty<ImmutableList<DoubleArray>> dataSensitivityRho() {
            return this.dataSensitivityRho;
        }

        public MetaProperty<ImmutableList<DoubleArray>> dataSensitivityNu() {
            return this.dataSensitivityNu;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((SabrParametersSwaptionVolatilities)bean).getName();
                }
                case 2039569265: {
                    return ((SabrParametersSwaptionVolatilities)bean).getConvention();
                }
                case -949589828: {
                    return ((SabrParametersSwaptionVolatilities)bean).getValuationDateTime();
                }
                case 458736106: {
                    return ((SabrParametersSwaptionVolatilities)bean).getParameters();
                }
                case 1650101705: {
                    return ((SabrParametersSwaptionVolatilities)bean).dataSensitivityAlpha;
                }
                case -85295067: {
                    return ((SabrParametersSwaptionVolatilities)bean).dataSensitivityBeta;
                }
                case 967095332: {
                    return ((SabrParametersSwaptionVolatilities)bean).dataSensitivityRho;
                }
                case -1077182148: {
                    return ((SabrParametersSwaptionVolatilities)bean).dataSensitivityNu;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

