/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.swaption;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.model.SabrParameterType;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.impl.option.BlackFormulaRepository;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.DiscountingSwapProductPricer;
import com.opengamma.strata.pricer.swaption.SabrSwaptionVolatilities;
import com.opengamma.strata.pricer.swaption.SwaptionSabrSensitivity;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilitiesName;
import com.opengamma.strata.pricer.swaption.VolatilitySwaptionPhysicalProductPricer;
import com.opengamma.strata.product.swap.ResolvedSwap;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;
import com.opengamma.strata.product.swaption.ResolvedSwaption;
import java.time.ZonedDateTime;

public class SabrSwaptionPhysicalProductPricer
extends VolatilitySwaptionPhysicalProductPricer {
    public static final SabrSwaptionPhysicalProductPricer DEFAULT = new SabrSwaptionPhysicalProductPricer(DiscountingSwapProductPricer.DEFAULT);

    public SabrSwaptionPhysicalProductPricer(DiscountingSwapProductPricer swapPricer) {
        super(swapPricer);
    }

    public PointSensitivityBuilder presentValueSensitivityRatesStickyModel(ResolvedSwaption swaption, RatesProvider ratesProvider, SabrSwaptionVolatilities swaptionVolatilities) {
        this.validate(swaption, ratesProvider, swaptionVolatilities);
        ZonedDateTime expiryDateTime = swaption.getExpiry();
        double expiry = swaptionVolatilities.relativeTime(expiryDateTime);
        ResolvedSwap underlying = swaption.getUnderlying();
        ResolvedSwapLeg fixedLeg = this.fixedLeg(underlying);
        if (expiry < 0.0) {
            return PointSensitivityBuilder.none();
        }
        double forward = this.forwardRate(swaption, ratesProvider);
        double pvbp = this.getSwapPricer().getLegPricer().pvbp(fixedLeg, ratesProvider);
        double strike = this.getSwapPricer().getLegPricer().couponEquivalent(fixedLeg, ratesProvider, pvbp);
        double tenor = swaptionVolatilities.tenor(fixedLeg.getStartDate(), fixedLeg.getEndDate());
        double shift = swaptionVolatilities.shift(expiry, tenor);
        ValueDerivatives volatilityAdj = swaptionVolatilities.volatilityAdjoint(expiry, tenor, strike, forward);
        boolean isCall = fixedLeg.getPayReceive().isPay();
        PointSensitivityBuilder pvbpDr = this.getSwapPricer().getLegPricer().pvbpSensitivity(fixedLeg, ratesProvider);
        PointSensitivityBuilder forwardDr = this.getSwapPricer().parRateSensitivity(underlying, ratesProvider);
        double shiftedForward = forward + shift;
        double shiftedStrike = strike + shift;
        double price = BlackFormulaRepository.price(shiftedForward, shiftedStrike, expiry, volatilityAdj.getValue(), isCall);
        double delta = BlackFormulaRepository.delta(shiftedForward, shiftedStrike, expiry, volatilityAdj.getValue(), isCall);
        double vega = BlackFormulaRepository.vega(shiftedForward, shiftedStrike, expiry, volatilityAdj.getValue());
        double sign = swaption.getLongShort().sign();
        return pvbpDr.multipliedBy(price * sign * Math.signum(pvbp)).combinedWith(forwardDr.multipliedBy((delta + vega * volatilityAdj.getDerivative(0)) * Math.abs(pvbp) * sign));
    }

    public PointSensitivityBuilder presentValueSensitivityModelParamsSabr(ResolvedSwaption swaption, RatesProvider ratesProvider, SabrSwaptionVolatilities swaptionVolatilities) {
        this.validate(swaption, ratesProvider, swaptionVolatilities);
        double expiry = swaptionVolatilities.relativeTime(swaption.getExpiry());
        ResolvedSwap underlying = swaption.getUnderlying();
        ResolvedSwapLeg fixedLeg = this.fixedLeg(underlying);
        double tenor = swaptionVolatilities.tenor(fixedLeg.getStartDate(), fixedLeg.getEndDate());
        double shift = swaptionVolatilities.shift(expiry, tenor);
        double pvbp = this.getSwapPricer().getLegPricer().pvbp(fixedLeg, ratesProvider);
        double strike = this.getSwapPricer().getLegPricer().couponEquivalent(fixedLeg, ratesProvider, pvbp);
        if (expiry < 0.0) {
            return PointSensitivityBuilder.none();
        }
        double forward = this.forwardRate(swaption, ratesProvider);
        double volatility = swaptionVolatilities.volatility(expiry, tenor, strike, forward);
        DoubleArray derivative = swaptionVolatilities.volatilityAdjoint(expiry, tenor, strike, forward).getDerivatives();
        double vega = Math.abs(pvbp) * BlackFormulaRepository.vega(forward + shift, strike + shift, expiry, volatility) * (double)swaption.getLongShort().sign();
        Currency ccy = fixedLeg.getCurrency();
        SwaptionVolatilitiesName name = swaptionVolatilities.getName();
        return PointSensitivityBuilder.of((PointSensitivity[])new PointSensitivity[]{SwaptionSabrSensitivity.of(name, expiry, tenor, SabrParameterType.ALPHA, ccy, vega * derivative.get(2)), SwaptionSabrSensitivity.of(name, expiry, tenor, SabrParameterType.BETA, ccy, vega * derivative.get(3)), SwaptionSabrSensitivity.of(name, expiry, tenor, SabrParameterType.RHO, ccy, vega * derivative.get(4)), SwaptionSabrSensitivity.of(name, expiry, tenor, SabrParameterType.NU, ccy, vega * derivative.get(5))});
    }
}

