/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.swaption;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.surface.SurfaceName;
import com.opengamma.strata.pricer.swaption.SabrParametersSwaptionVolatilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class SabrSwaptionRawDataSensitivityCalculator {
    public static final SabrSwaptionRawDataSensitivityCalculator DEFAULT = new SabrSwaptionRawDataSensitivityCalculator();

    public CurrencyParameterSensitivity parallelSensitivity(CurrencyParameterSensitivities paramSensitivities, SabrParametersSwaptionVolatilities volatilities) {
        ArrayList sensitivityToRawData = new ArrayList(4);
        Optional<ImmutableList<DoubleArray>> alphaInfo = volatilities.getDataSensitivityAlpha();
        sensitivityToRawData.add(alphaInfo.orElse(null));
        Optional<ImmutableList<DoubleArray>> betaInfo = volatilities.getDataSensitivityBeta();
        sensitivityToRawData.add(betaInfo.orElse(null));
        Optional<ImmutableList<DoubleArray>> rhoInfo = volatilities.getDataSensitivityRho();
        sensitivityToRawData.add(rhoInfo.orElse(null));
        Optional<ImmutableList<DoubleArray>> nuInfo = volatilities.getDataSensitivityNu();
        sensitivityToRawData.add(nuInfo.orElse(null));
        ArgChecker.isTrue((alphaInfo.isPresent() || betaInfo.isPresent() || rhoInfo.isPresent() || nuInfo.isPresent() ? 1 : 0) != 0, (String)"at least one sensitivity to raw data must be available");
        SabrSwaptionRawDataSensitivityCalculator.checkCurrency(paramSensitivities);
        int nbSurfaceNode = ((List)sensitivityToRawData.get(0)).size();
        double[] sensitivityRawArray = new double[nbSurfaceNode];
        Currency ccy = null;
        ImmutableList metadataResult = null;
        for (CurrencyParameterSensitivity s : paramSensitivities.getSensitivities()) {
            ccy = s.getCurrency();
            MarketDataName name = s.getMarketDataName();
            if (!(name instanceof SurfaceName)) continue;
            if (volatilities.getParameters().getAlphaSurface().getName().equals((Object)name) && alphaInfo.isPresent()) {
                SabrSwaptionRawDataSensitivityCalculator.updateSensitivity(s, (List)sensitivityToRawData.get(0), sensitivityRawArray);
                metadataResult = s.getParameterMetadata();
            }
            if (volatilities.getParameters().getBetaSurface().getName().equals((Object)name) && betaInfo.isPresent()) {
                SabrSwaptionRawDataSensitivityCalculator.updateSensitivity(s, (List)sensitivityToRawData.get(1), sensitivityRawArray);
                metadataResult = s.getParameterMetadata();
            }
            if (volatilities.getParameters().getRhoSurface().getName().equals((Object)name) && rhoInfo.isPresent()) {
                SabrSwaptionRawDataSensitivityCalculator.updateSensitivity(s, (List)sensitivityToRawData.get(2), sensitivityRawArray);
                metadataResult = s.getParameterMetadata();
            }
            if (!volatilities.getParameters().getNuSurface().getName().equals((Object)name) || !nuInfo.isPresent()) continue;
            SabrSwaptionRawDataSensitivityCalculator.updateSensitivity(s, (List)sensitivityToRawData.get(3), sensitivityRawArray);
            metadataResult = s.getParameterMetadata();
        }
        DoubleArray sensitivityRaw = DoubleArray.ofUnsafe((double[])sensitivityRawArray);
        return CurrencyParameterSensitivity.of((MarketDataName)SurfaceName.of((String)"RawDataParallelSensitivity"), metadataResult, (Currency)ccy, (DoubleArray)sensitivityRaw);
    }

    private static void updateSensitivity(CurrencyParameterSensitivity s, List<DoubleArray> sensitivityInfoParam, double[] sensitivityRawArray) {
        int nbSurfaceNode = sensitivityInfoParam.size();
        ArgChecker.isTrue((s.getSensitivity().size() == nbSurfaceNode ? 1 : 0) != 0, (String)"sensitivity and surface info are not of the same size");
        for (int loopnode = 0; loopnode < nbSurfaceNode; ++loopnode) {
            double sum = sensitivityInfoParam.get(loopnode).sum();
            int n = loopnode;
            sensitivityRawArray[n] = sensitivityRawArray[n] + s.getSensitivity().get(loopnode) * sum;
        }
    }

    private static void checkCurrency(CurrencyParameterSensitivities paramSensitivities) {
        ImmutableList sensitivitiesList = paramSensitivities.getSensitivities();
        if (sensitivitiesList.size() > 0) {
            Currency ccy = ((CurrencyParameterSensitivity)sensitivitiesList.get(0)).getCurrency();
            for (int i = 1; i < sensitivitiesList.size(); ++i) {
                ArgChecker.isTrue((boolean)ccy.equals((Object)((CurrencyParameterSensitivity)sensitivitiesList.get(i)).getCurrency()), (String)"sensitivities must be in the same currency for aggregation");
            }
        }
    }
}

