/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.swaption;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.model.SabrParameterType;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.swaption.SwaptionSabrSensitivity;
import com.opengamma.strata.pricer.swaption.SwaptionSensitivity;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilities;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilitiesName;

public interface SabrSwaptionVolatilities
extends SwaptionVolatilities {
    @Override
    public SabrSwaptionVolatilities withParameter(int var1, double var2);

    @Override
    public SabrSwaptionVolatilities withPerturbation(ParameterPerturbation var1);

    public double alpha(double var1, double var3);

    public double beta(double var1, double var3);

    public double rho(double var1, double var3);

    public double nu(double var1, double var3);

    public double shift(double var1, double var3);

    public ValueDerivatives volatilityAdjoint(double var1, double var3, double var5, double var7);

    default public PointSensitivityBuilder convertSwaptionSensitivity(SwaptionSensitivity swptSensi) {
        double expiry = swptSensi.getExpiry();
        double tenor = swptSensi.getTenor();
        DoubleArray derivative = this.volatilityAdjoint(expiry, swptSensi.getTenor(), swptSensi.getStrike(), swptSensi.getForward()).getDerivatives();
        SwaptionVolatilitiesName name = this.getName();
        Currency ccy = swptSensi.getCurrency();
        double vega = swptSensi.getSensitivity();
        return PointSensitivityBuilder.of((PointSensitivity[])new PointSensitivity[]{SwaptionSabrSensitivity.of(name, expiry, tenor, SabrParameterType.ALPHA, ccy, vega * derivative.get(2)), SwaptionSabrSensitivity.of(name, expiry, tenor, SabrParameterType.BETA, ccy, vega * derivative.get(3)), SwaptionSabrSensitivity.of(name, expiry, tenor, SabrParameterType.RHO, ccy, vega * derivative.get(4)), SwaptionSabrSensitivity.of(name, expiry, tenor, SabrParameterType.NU, ccy, vega * derivative.get(5))});
    }
}

