/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.swaption;

import com.google.common.collect.ComparisonChain;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.market.model.SabrParameterType;
import com.opengamma.strata.market.sensitivity.MutablePointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilitiesName;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.DoubleUnaryOperator;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class SwaptionSabrSensitivity
implements PointSensitivity,
PointSensitivityBuilder,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final SwaptionVolatilitiesName volatilitiesName;
    @PropertyDefinition(validate="notNull")
    private final double expiry;
    @PropertyDefinition
    private final double tenor;
    @PropertyDefinition
    private final SabrParameterType sensitivityType;
    @PropertyDefinition(overrideGet=true)
    private final Currency currency;
    @PropertyDefinition(overrideGet=true)
    private final double sensitivity;
    private static final long serialVersionUID = 1L;

    public static SwaptionSabrSensitivity of(SwaptionVolatilitiesName volatilitiesName, double expiry, double tenor, SabrParameterType sensitivityType, Currency sensitivityCurrency, double sensitivity) {
        return new SwaptionSabrSensitivity(volatilitiesName, expiry, tenor, sensitivityType, sensitivityCurrency, sensitivity);
    }

    public SwaptionSabrSensitivity withCurrency(Currency currency) {
        if (this.currency.equals((Object)currency)) {
            return this;
        }
        return new SwaptionSabrSensitivity(this.volatilitiesName, this.expiry, this.tenor, this.sensitivityType, currency, this.sensitivity);
    }

    public SwaptionSabrSensitivity withSensitivity(double sensitivity) {
        return new SwaptionSabrSensitivity(this.volatilitiesName, this.expiry, this.tenor, this.sensitivityType, this.currency, sensitivity);
    }

    public int compareKey(PointSensitivity other) {
        if (other instanceof SwaptionSabrSensitivity) {
            SwaptionSabrSensitivity otherSwpt = (SwaptionSabrSensitivity)other;
            return ComparisonChain.start().compare((Comparable)((Object)this.volatilitiesName), (Comparable)((Object)otherSwpt.volatilitiesName)).compare((Comparable)this.currency, (Comparable)otherSwpt.currency).compare(this.expiry, otherSwpt.expiry).compare(this.tenor, otherSwpt.tenor).compare((Comparable)this.sensitivityType, (Comparable)otherSwpt.sensitivityType).result();
        }
        return this.getClass().getSimpleName().compareTo(other.getClass().getSimpleName());
    }

    public SwaptionSabrSensitivity convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        return (SwaptionSabrSensitivity)super.convertedTo(resultCurrency, rateProvider);
    }

    public SwaptionSabrSensitivity multipliedBy(double factor) {
        return new SwaptionSabrSensitivity(this.volatilitiesName, this.expiry, this.tenor, this.sensitivityType, this.currency, this.sensitivity * factor);
    }

    public SwaptionSabrSensitivity mapSensitivity(DoubleUnaryOperator operator) {
        return new SwaptionSabrSensitivity(this.volatilitiesName, this.expiry, this.tenor, this.sensitivityType, this.currency, operator.applyAsDouble(this.sensitivity));
    }

    public SwaptionSabrSensitivity normalize() {
        return this;
    }

    public MutablePointSensitivities buildInto(MutablePointSensitivities combination) {
        return combination.add((PointSensitivity)this);
    }

    public SwaptionSabrSensitivity cloned() {
        return this;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private SwaptionSabrSensitivity(SwaptionVolatilitiesName volatilitiesName, double expiry, double tenor, SabrParameterType sensitivityType, Currency currency, double sensitivity) {
        JodaBeanUtils.notNull((Object)volatilitiesName, (String)"volatilitiesName");
        JodaBeanUtils.notNull((Object)expiry, (String)"expiry");
        this.volatilitiesName = volatilitiesName;
        this.expiry = expiry;
        this.tenor = tenor;
        this.sensitivityType = sensitivityType;
        this.currency = currency;
        this.sensitivity = sensitivity;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public SwaptionVolatilitiesName getVolatilitiesName() {
        return this.volatilitiesName;
    }

    public double getExpiry() {
        return this.expiry;
    }

    public double getTenor() {
        return this.tenor;
    }

    public SabrParameterType getSensitivityType() {
        return this.sensitivityType;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public double getSensitivity() {
        return this.sensitivity;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SwaptionSabrSensitivity other = (SwaptionSabrSensitivity)obj;
            return JodaBeanUtils.equal((Object)this.volatilitiesName, (Object)other.volatilitiesName) && JodaBeanUtils.equal((double)this.expiry, (double)other.expiry) && JodaBeanUtils.equal((double)this.tenor, (double)other.tenor) && JodaBeanUtils.equal((Object)this.sensitivityType, (Object)other.sensitivityType) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.sensitivity, (double)other.sensitivity);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.volatilitiesName);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.expiry);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.tenor);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.sensitivityType);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.sensitivity);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(224);
        buf.append("SwaptionSabrSensitivity{");
        buf.append("volatilitiesName").append('=').append(JodaBeanUtils.toString((Object)this.volatilitiesName)).append(',').append(' ');
        buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
        buf.append("tenor").append('=').append(JodaBeanUtils.toString((Object)this.tenor)).append(',').append(' ');
        buf.append("sensitivityType").append('=').append(JodaBeanUtils.toString((Object)this.sensitivityType)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<SwaptionSabrSensitivity> {
        private SwaptionVolatilitiesName volatilitiesName;
        private double expiry;
        private double tenor;
        private SabrParameterType sensitivityType;
        private Currency currency;
        private double sensitivity;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 2100884654: {
                    return this.volatilitiesName;
                }
                case -1289159373: {
                    return this.expiry;
                }
                case 110246592: {
                    return this.tenor;
                }
                case 1598929529: {
                    return this.sensitivityType;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 2100884654: {
                    this.volatilitiesName = (SwaptionVolatilitiesName)newValue;
                    break;
                }
                case -1289159373: {
                    this.expiry = (Double)newValue;
                    break;
                }
                case 110246592: {
                    this.tenor = (Double)newValue;
                    break;
                }
                case 1598929529: {
                    this.sensitivityType = (SabrParameterType)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 564403871: {
                    this.sensitivity = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public SwaptionSabrSensitivity build() {
            return new SwaptionSabrSensitivity(this.volatilitiesName, this.expiry, this.tenor, this.sensitivityType, this.currency, this.sensitivity);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(224);
            buf.append("SwaptionSabrSensitivity.Builder{");
            buf.append("volatilitiesName").append('=').append(JodaBeanUtils.toString((Object)this.volatilitiesName)).append(',').append(' ');
            buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
            buf.append("tenor").append('=').append(JodaBeanUtils.toString((Object)this.tenor)).append(',').append(' ');
            buf.append("sensitivityType").append('=').append(JodaBeanUtils.toString((Object)this.sensitivityType)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SwaptionVolatilitiesName> volatilitiesName = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"volatilitiesName", SwaptionSabrSensitivity.class, SwaptionVolatilitiesName.class);
        private final MetaProperty<Double> expiry = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiry", SwaptionSabrSensitivity.class, Double.TYPE);
        private final MetaProperty<Double> tenor = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"tenor", SwaptionSabrSensitivity.class, Double.TYPE);
        private final MetaProperty<SabrParameterType> sensitivityType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sensitivityType", SwaptionSabrSensitivity.class, SabrParameterType.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", SwaptionSabrSensitivity.class, Currency.class);
        private final MetaProperty<Double> sensitivity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sensitivity", SwaptionSabrSensitivity.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"volatilitiesName", "expiry", "tenor", "sensitivityType", "currency", "sensitivity"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 2100884654: {
                    return this.volatilitiesName;
                }
                case -1289159373: {
                    return this.expiry;
                }
                case 110246592: {
                    return this.tenor;
                }
                case 1598929529: {
                    return this.sensitivityType;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends SwaptionSabrSensitivity> builder() {
            return new Builder();
        }

        public Class<? extends SwaptionSabrSensitivity> beanType() {
            return SwaptionSabrSensitivity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SwaptionVolatilitiesName> volatilitiesName() {
            return this.volatilitiesName;
        }

        public MetaProperty<Double> expiry() {
            return this.expiry;
        }

        public MetaProperty<Double> tenor() {
            return this.tenor;
        }

        public MetaProperty<SabrParameterType> sensitivityType() {
            return this.sensitivityType;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> sensitivity() {
            return this.sensitivity;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 2100884654: {
                    return ((SwaptionSabrSensitivity)bean).getVolatilitiesName();
                }
                case -1289159373: {
                    return ((SwaptionSabrSensitivity)bean).getExpiry();
                }
                case 110246592: {
                    return ((SwaptionSabrSensitivity)bean).getTenor();
                }
                case 1598929529: {
                    return ((SwaptionSabrSensitivity)bean).getSensitivityType();
                }
                case 575402001: {
                    return ((SwaptionSabrSensitivity)bean).getCurrency();
                }
                case 564403871: {
                    return ((SwaptionSabrSensitivity)bean).getSensitivity();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

