/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.swaption;

import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.market.param.ParameterMetadata;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class SwaptionSurfaceExpiryStrikeParameterMetadata
implements ParameterMetadata,
ImmutableBean,
Serializable {
    @PropertyDefinition
    private final double yearFraction;
    @PropertyDefinition
    private final double strike;
    @PropertyDefinition(validate="notEmpty", overrideGet=true)
    private final String label;
    private static final long serialVersionUID = 1L;

    public static SwaptionSurfaceExpiryStrikeParameterMetadata of(double yearFraction, double strike) {
        String label = Pair.of((Object)yearFraction, (Object)strike).toString();
        return new SwaptionSurfaceExpiryStrikeParameterMetadata(yearFraction, strike, label);
    }

    public static SwaptionSurfaceExpiryStrikeParameterMetadata of(double yearFraction, double strike, String label) {
        return new SwaptionSurfaceExpiryStrikeParameterMetadata(yearFraction, strike, label);
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.label == null) {
            builder.label = Pair.of((Object)builder.yearFraction, (Object)builder.strike).toString();
        }
    }

    public Pair<Double, Double> getIdentifier() {
        return Pair.of((Object)this.yearFraction, (Object)this.strike);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private SwaptionSurfaceExpiryStrikeParameterMetadata(double yearFraction, double strike, String label) {
        JodaBeanUtils.notEmpty((String)label, (String)"label");
        this.yearFraction = yearFraction;
        this.strike = strike;
        this.label = label;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public double getYearFraction() {
        return this.yearFraction;
    }

    public double getStrike() {
        return this.strike;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SwaptionSurfaceExpiryStrikeParameterMetadata other = (SwaptionSurfaceExpiryStrikeParameterMetadata)obj;
            return JodaBeanUtils.equal((double)this.yearFraction, (double)other.yearFraction) && JodaBeanUtils.equal((double)this.strike, (double)other.strike) && JodaBeanUtils.equal((Object)this.label, (Object)other.label);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.yearFraction);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.strike);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.label);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("SwaptionSurfaceExpiryStrikeParameterMetadata{");
        buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction)).append(',').append(' ');
        buf.append("strike").append('=').append(JodaBeanUtils.toString((Object)this.strike)).append(',').append(' ');
        buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<SwaptionSurfaceExpiryStrikeParameterMetadata> {
        private double yearFraction;
        private double strike;
        private String label;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1731780257: {
                    return this.yearFraction;
                }
                case -891985998: {
                    return this.strike;
                }
                case 102727412: {
                    return this.label;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1731780257: {
                    this.yearFraction = (Double)newValue;
                    break;
                }
                case -891985998: {
                    this.strike = (Double)newValue;
                    break;
                }
                case 102727412: {
                    this.label = (String)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public SwaptionSurfaceExpiryStrikeParameterMetadata build() {
            SwaptionSurfaceExpiryStrikeParameterMetadata.preBuild(this);
            return new SwaptionSurfaceExpiryStrikeParameterMetadata(this.yearFraction, this.strike, this.label);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("SwaptionSurfaceExpiryStrikeParameterMetadata.Builder{");
            buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction)).append(',').append(' ');
            buf.append("strike").append('=').append(JodaBeanUtils.toString((Object)this.strike)).append(',').append(' ');
            buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Double> yearFraction = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yearFraction", SwaptionSurfaceExpiryStrikeParameterMetadata.class, Double.TYPE);
        private final MetaProperty<Double> strike = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"strike", SwaptionSurfaceExpiryStrikeParameterMetadata.class, Double.TYPE);
        private final MetaProperty<String> label = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"label", SwaptionSurfaceExpiryStrikeParameterMetadata.class, String.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"yearFraction", "strike", "label"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1731780257: {
                    return this.yearFraction;
                }
                case -891985998: {
                    return this.strike;
                }
                case 102727412: {
                    return this.label;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends SwaptionSurfaceExpiryStrikeParameterMetadata> builder() {
            return new Builder();
        }

        public Class<? extends SwaptionSurfaceExpiryStrikeParameterMetadata> beanType() {
            return SwaptionSurfaceExpiryStrikeParameterMetadata.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Double> yearFraction() {
            return this.yearFraction;
        }

        public MetaProperty<Double> strike() {
            return this.strike;
        }

        public MetaProperty<String> label() {
            return this.label;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1731780257: {
                    return ((SwaptionSurfaceExpiryStrikeParameterMetadata)bean).getYearFraction();
                }
                case -891985998: {
                    return ((SwaptionSurfaceExpiryStrikeParameterMetadata)bean).getStrike();
                }
                case 102727412: {
                    return ((SwaptionSurfaceExpiryStrikeParameterMetadata)bean).getLabel();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

