/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.swaption;

import com.opengamma.strata.market.MarketDataView;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.ParameterizedData;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilitiesName;
import com.opengamma.strata.product.common.PutCall;
import com.opengamma.strata.product.swap.type.FixedFloatSwapConvention;
import java.time.LocalDate;
import java.time.ZonedDateTime;

public interface SwaptionVolatilities
extends MarketDataView,
ParameterizedData {
    public SwaptionVolatilitiesName getName();

    public FixedFloatSwapConvention getConvention();

    public ValueType getVolatilityType();

    default public LocalDate getValuationDate() {
        return this.getValuationDateTime().toLocalDate();
    }

    public ZonedDateTime getValuationDateTime();

    public SwaptionVolatilities withParameter(int var1, double var2);

    public SwaptionVolatilities withPerturbation(ParameterPerturbation var1);

    default public double volatility(ZonedDateTime expiryDateTime, double tenor, double strike, double forward) {
        return this.volatility(this.relativeTime(expiryDateTime), tenor, strike, forward);
    }

    public double volatility(double var1, double var3, double var5, double var7);

    default public CurrencyParameterSensitivities parameterSensitivity(PointSensitivity ... pointSensitivities) {
        return this.parameterSensitivity(PointSensitivities.of((PointSensitivity[])pointSensitivities));
    }

    public CurrencyParameterSensitivities parameterSensitivity(PointSensitivities var1);

    public double price(double var1, double var3, PutCall var5, double var6, double var8, double var10);

    public double priceDelta(double var1, double var3, PutCall var5, double var6, double var8, double var10);

    public double priceGamma(double var1, double var3, PutCall var5, double var6, double var8, double var10);

    public double priceTheta(double var1, double var3, PutCall var5, double var6, double var8, double var10);

    public double priceVega(double var1, double var3, PutCall var5, double var6, double var8, double var10);

    public double relativeTime(ZonedDateTime var1);

    public double tenor(LocalDate var1, LocalDate var2);
}

