/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.swaption;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.DiscountingSwapProductPricer;
import com.opengamma.strata.pricer.swaption.SwaptionSensitivity;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilities;
import com.opengamma.strata.product.common.PutCall;
import com.opengamma.strata.product.common.SettlementType;
import com.opengamma.strata.product.swap.ResolvedSwap;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;
import com.opengamma.strata.product.swap.SwapLegType;
import com.opengamma.strata.product.swaption.ResolvedSwaption;

public class VolatilitySwaptionPhysicalProductPricer {
    public static final VolatilitySwaptionPhysicalProductPricer DEFAULT = new VolatilitySwaptionPhysicalProductPricer(DiscountingSwapProductPricer.DEFAULT);
    private final DiscountingSwapProductPricer swapPricer;

    public VolatilitySwaptionPhysicalProductPricer(DiscountingSwapProductPricer swapPricer) {
        this.swapPricer = (DiscountingSwapProductPricer)ArgChecker.notNull((Object)swapPricer, (String)"swapPricer");
    }

    protected DiscountingSwapProductPricer getSwapPricer() {
        return this.swapPricer;
    }

    public CurrencyAmount presentValue(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        this.validate(swaption, ratesProvider, swaptionVolatilities);
        double expiry = swaptionVolatilities.relativeTime(swaption.getExpiry());
        ResolvedSwap underlying = swaption.getUnderlying();
        ResolvedSwapLeg fixedLeg = this.fixedLeg(underlying);
        if (expiry < 0.0) {
            return CurrencyAmount.of((Currency)fixedLeg.getCurrency(), (double)0.0);
        }
        double forward = this.forwardRate(swaption, ratesProvider);
        double pvbp = this.swapPricer.getLegPricer().pvbp(fixedLeg, ratesProvider);
        double strike = this.swapPricer.getLegPricer().couponEquivalent(fixedLeg, ratesProvider, pvbp);
        double tenor = swaptionVolatilities.tenor(fixedLeg.getStartDate(), fixedLeg.getEndDate());
        double volatility = swaptionVolatilities.volatility(expiry, tenor, strike, forward);
        PutCall putCall = PutCall.ofPut((boolean)fixedLeg.getPayReceive().isReceive());
        double price = Math.abs(pvbp) * swaptionVolatilities.price(expiry, tenor, putCall, strike, forward, volatility);
        return CurrencyAmount.of((Currency)fixedLeg.getCurrency(), (double)(price * (double)swaption.getLongShort().sign()));
    }

    public MultiCurrencyAmount currencyExposure(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{this.presentValue(swaption, ratesProvider, swaptionVolatilities)});
    }

    public double impliedVolatility(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        this.validate(swaption, ratesProvider, swaptionVolatilities);
        double expiry = swaptionVolatilities.relativeTime(swaption.getExpiry());
        ResolvedSwap underlying = swaption.getUnderlying();
        ResolvedSwapLeg fixedLeg = this.fixedLeg(underlying);
        ArgChecker.isTrue((expiry >= 0.0 ? 1 : 0) != 0, (String)"Option must be before expiry to compute an implied volatility");
        double forward = this.forwardRate(swaption, ratesProvider);
        double pvbp = this.getSwapPricer().getLegPricer().pvbp(fixedLeg, ratesProvider);
        double strike = this.getSwapPricer().getLegPricer().couponEquivalent(fixedLeg, ratesProvider, pvbp);
        double tenor = swaptionVolatilities.tenor(fixedLeg.getStartDate(), fixedLeg.getEndDate());
        return swaptionVolatilities.volatility(expiry, tenor, strike, forward);
    }

    public double forwardRate(ResolvedSwaption swaption, RatesProvider ratesProvider) {
        return this.swapPricer.parRate(swaption.getUnderlying(), ratesProvider);
    }

    public CurrencyAmount presentValueDelta(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        this.validate(swaption, ratesProvider, swaptionVolatilities);
        double expiry = swaptionVolatilities.relativeTime(swaption.getExpiry());
        ResolvedSwap underlying = swaption.getUnderlying();
        ResolvedSwapLeg fixedLeg = this.fixedLeg(underlying);
        if (expiry < 0.0) {
            return CurrencyAmount.of((Currency)fixedLeg.getCurrency(), (double)0.0);
        }
        double forward = this.forwardRate(swaption, ratesProvider);
        double pvbp = this.getSwapPricer().getLegPricer().pvbp(fixedLeg, ratesProvider);
        double numeraire = Math.abs(pvbp);
        double strike = this.getSwapPricer().getLegPricer().couponEquivalent(fixedLeg, ratesProvider, pvbp);
        double tenor = swaptionVolatilities.tenor(fixedLeg.getStartDate(), fixedLeg.getEndDate());
        double volatility = swaptionVolatilities.volatility(expiry, tenor, strike, forward);
        PutCall putCall = PutCall.ofPut((boolean)fixedLeg.getPayReceive().isReceive());
        double delta = numeraire * swaptionVolatilities.priceDelta(expiry, tenor, putCall, strike, forward, volatility);
        return CurrencyAmount.of((Currency)fixedLeg.getCurrency(), (double)(delta * (double)swaption.getLongShort().sign()));
    }

    public CurrencyAmount presentValueGamma(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        this.validate(swaption, ratesProvider, swaptionVolatilities);
        double expiry = swaptionVolatilities.relativeTime(swaption.getExpiry());
        ResolvedSwap underlying = swaption.getUnderlying();
        ResolvedSwapLeg fixedLeg = this.fixedLeg(underlying);
        if (expiry < 0.0) {
            return CurrencyAmount.of((Currency)fixedLeg.getCurrency(), (double)0.0);
        }
        double forward = this.forwardRate(swaption, ratesProvider);
        double pvbp = this.getSwapPricer().getLegPricer().pvbp(fixedLeg, ratesProvider);
        double numeraire = Math.abs(pvbp);
        double strike = this.getSwapPricer().getLegPricer().couponEquivalent(fixedLeg, ratesProvider, pvbp);
        double tenor = swaptionVolatilities.tenor(fixedLeg.getStartDate(), fixedLeg.getEndDate());
        double volatility = swaptionVolatilities.volatility(expiry, tenor, strike, forward);
        PutCall putCall = PutCall.ofPut((boolean)fixedLeg.getPayReceive().isReceive());
        double gamma = numeraire * swaptionVolatilities.priceGamma(expiry, tenor, putCall, strike, forward, volatility);
        return CurrencyAmount.of((Currency)fixedLeg.getCurrency(), (double)(gamma * (double)swaption.getLongShort().sign()));
    }

    public CurrencyAmount presentValueTheta(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        this.validate(swaption, ratesProvider, swaptionVolatilities);
        double expiry = swaptionVolatilities.relativeTime(swaption.getExpiry());
        ResolvedSwap underlying = swaption.getUnderlying();
        ResolvedSwapLeg fixedLeg = this.fixedLeg(underlying);
        if (expiry < 0.0) {
            return CurrencyAmount.of((Currency)fixedLeg.getCurrency(), (double)0.0);
        }
        double forward = this.forwardRate(swaption, ratesProvider);
        double pvbp = this.getSwapPricer().getLegPricer().pvbp(fixedLeg, ratesProvider);
        double numeraire = Math.abs(pvbp);
        double strike = this.getSwapPricer().getLegPricer().couponEquivalent(fixedLeg, ratesProvider, pvbp);
        double tenor = swaptionVolatilities.tenor(fixedLeg.getStartDate(), fixedLeg.getEndDate());
        double volatility = swaptionVolatilities.volatility(expiry, tenor, strike, forward);
        PutCall putCall = PutCall.ofPut((boolean)fixedLeg.getPayReceive().isReceive());
        double theta = numeraire * swaptionVolatilities.priceTheta(expiry, tenor, putCall, strike, forward, volatility);
        return CurrencyAmount.of((Currency)fixedLeg.getCurrency(), (double)(theta * (double)swaption.getLongShort().sign()));
    }

    public PointSensitivityBuilder presentValueSensitivityRatesStickyStrike(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        this.validate(swaption, ratesProvider, swaptionVolatilities);
        double expiry = swaptionVolatilities.relativeTime(swaption.getExpiry());
        ResolvedSwap underlying = swaption.getUnderlying();
        ResolvedSwapLeg fixedLeg = this.fixedLeg(underlying);
        if (expiry < 0.0) {
            return PointSensitivityBuilder.none();
        }
        double forward = this.forwardRate(swaption, ratesProvider);
        double pvbp = this.getSwapPricer().getLegPricer().pvbp(fixedLeg, ratesProvider);
        double strike = this.getSwapPricer().getLegPricer().couponEquivalent(fixedLeg, ratesProvider, pvbp);
        double tenor = swaptionVolatilities.tenor(fixedLeg.getStartDate(), fixedLeg.getEndDate());
        double volatility = swaptionVolatilities.volatility(expiry, tenor, strike, forward);
        PutCall putCall = PutCall.ofPut((boolean)fixedLeg.getPayReceive().isReceive());
        double price = swaptionVolatilities.price(expiry, tenor, putCall, strike, forward, volatility);
        double delta = swaptionVolatilities.priceDelta(expiry, tenor, putCall, strike, forward, volatility);
        PointSensitivityBuilder pvbpDr = this.getSwapPricer().getLegPricer().pvbpSensitivity(fixedLeg, ratesProvider);
        PointSensitivityBuilder forwardDr = this.getSwapPricer().parRateSensitivity(underlying, ratesProvider);
        double sign = swaption.getLongShort().sign();
        return pvbpDr.multipliedBy(price * sign * Math.signum(pvbp)).combinedWith(forwardDr.multipliedBy(delta * Math.abs(pvbp) * sign));
    }

    public SwaptionSensitivity presentValueSensitivityModelParamsVolatility(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        this.validate(swaption, ratesProvider, swaptionVolatilities);
        double expiry = swaptionVolatilities.relativeTime(swaption.getExpiry());
        ResolvedSwap underlying = swaption.getUnderlying();
        ResolvedSwapLeg fixedLeg = this.fixedLeg(underlying);
        double tenor = swaptionVolatilities.tenor(fixedLeg.getStartDate(), fixedLeg.getEndDate());
        double pvbp = this.getSwapPricer().getLegPricer().pvbp(fixedLeg, ratesProvider);
        double strike = this.getSwapPricer().getLegPricer().couponEquivalent(fixedLeg, ratesProvider, pvbp);
        if (expiry < 0.0) {
            return SwaptionSensitivity.of(swaptionVolatilities.getName(), expiry, tenor, strike, 0.0, fixedLeg.getCurrency(), 0.0);
        }
        double forward = this.forwardRate(swaption, ratesProvider);
        double numeraire = Math.abs(pvbp);
        double volatility = swaptionVolatilities.volatility(expiry, tenor, strike, forward);
        PutCall putCall = PutCall.ofPut((boolean)fixedLeg.getPayReceive().isReceive());
        double vega = numeraire * swaptionVolatilities.priceVega(expiry, tenor, putCall, strike, forward, volatility);
        return SwaptionSensitivity.of(swaptionVolatilities.getName(), expiry, tenor, strike, forward, fixedLeg.getCurrency(), vega * (double)swaption.getLongShort().sign());
    }

    protected ResolvedSwapLeg fixedLeg(ResolvedSwap swap) {
        ArgChecker.isFalse((boolean)swap.isCrossCurrency(), (String)"Swap must be single currency");
        ImmutableList fixedLegs = swap.getLegs(SwapLegType.FIXED);
        if (fixedLegs.isEmpty()) {
            throw new IllegalArgumentException("Swap must contain a fixed leg");
        }
        return (ResolvedSwapLeg)fixedLegs.get(0);
    }

    protected void validate(ResolvedSwaption swaption, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        ArgChecker.isTrue((boolean)swaptionVolatilities.getValuationDate().equals(ratesProvider.getValuationDate()), (String)"Volatility and rate data must be for the same date");
        this.validateSwaption(swaption);
    }

    protected void validateSwaption(ResolvedSwaption swaption) {
        ArgChecker.isFalse((boolean)swaption.getUnderlying().isCrossCurrency(), (String)"Underlying swap must be single currency");
        ArgChecker.isTrue((boolean)swaption.getSwaptionSettlement().getSettlementType().equals((Object)SettlementType.PHYSICAL), (String)"Swaption must be physical settlement");
    }
}

