/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.swaption;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountingPaymentPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swaption.SwaptionSensitivity;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilities;
import com.opengamma.strata.pricer.swaption.VolatilitySwaptionProductPricer;
import com.opengamma.strata.product.swaption.ResolvedSwaption;
import com.opengamma.strata.product.swaption.ResolvedSwaptionTrade;
import java.time.LocalDate;

public class VolatilitySwaptionTradePricer {
    public static final VolatilitySwaptionTradePricer DEFAULT = new VolatilitySwaptionTradePricer(VolatilitySwaptionProductPricer.DEFAULT, DiscountingPaymentPricer.DEFAULT);
    private final VolatilitySwaptionProductPricer productPricer;
    private final DiscountingPaymentPricer paymentPricer;

    public VolatilitySwaptionTradePricer(VolatilitySwaptionProductPricer productPricer, DiscountingPaymentPricer paymentPricer) {
        this.productPricer = (VolatilitySwaptionProductPricer)ArgChecker.notNull((Object)productPricer, (String)"productPricer");
        this.paymentPricer = (DiscountingPaymentPricer)ArgChecker.notNull((Object)paymentPricer, (String)"paymentPricer");
    }

    public CurrencyAmount presentValue(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        ResolvedSwaption product = trade.getProduct();
        CurrencyAmount pvProduct = this.productPricer.presentValue(product, ratesProvider, swaptionVolatilities);
        Payment premium = trade.getPremium();
        CurrencyAmount pvPremium = this.paymentPricer.presentValue(premium, ratesProvider);
        return pvProduct.plus(pvPremium);
    }

    public PointSensitivities presentValueSensitivityRatesStickyStrike(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        ResolvedSwaption product = trade.getProduct();
        PointSensitivityBuilder pvcsProduct = this.productPricer.presentValueSensitivityRatesStickyStrike(product, ratesProvider, swaptionVolatilities);
        Payment premium = trade.getPremium();
        PointSensitivityBuilder pvcsPremium = this.paymentPricer.presentValueSensitivity(premium, ratesProvider);
        return pvcsProduct.combinedWith(pvcsPremium).build();
    }

    public PointSensitivities presentValueSensitivityModelParamsVolatility(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        ResolvedSwaption product = trade.getProduct();
        SwaptionSensitivity pointSens = this.productPricer.presentValueSensitivityModelParamsVolatility(product, ratesProvider, swaptionVolatilities);
        return PointSensitivities.of((PointSensitivity[])new PointSensitivity[]{pointSens});
    }

    public MultiCurrencyAmount currencyExposure(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{this.presentValue(trade, ratesProvider, swaptionVolatilities)});
    }

    public double impliedVolatility(ResolvedSwaptionTrade swaptionTrade, RatesProvider ratesProvider, SwaptionVolatilities swaptionVolatilities) {
        return this.productPricer.impliedVolatility(swaptionTrade.getProduct(), ratesProvider, swaptionVolatilities);
    }

    public double forwardRate(ResolvedSwaptionTrade swaptionTrade, RatesProvider ratesProvider) {
        return this.productPricer.forwardRate(swaptionTrade.getProduct(), ratesProvider);
    }

    public CurrencyAmount currentCash(ResolvedSwaptionTrade trade, LocalDate valuationDate) {
        Payment premium = trade.getPremium();
        if (premium.getDate().equals(valuationDate)) {
            return CurrencyAmount.of((Currency)premium.getCurrency(), (double)premium.getAmount());
        }
        return CurrencyAmount.of((Currency)premium.getCurrency(), (double)0.0);
    }
}

