/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.pricer.DiscountFactors;
import java.time.LocalDate;
import java.util.Set;

public interface BaseProvider
extends FxRateProvider {
    public LocalDate getValuationDate();

    public Set<Currency> getDiscountCurrencies();

    public <T> T data(MarketDataId<T> var1);

    public double fxRate(Currency var1, Currency var2);

    default public double fxRate(CurrencyPair currencyPair) {
        return this.fxRate(currencyPair.getBase(), currencyPair.getCounter());
    }

    public DiscountFactors discountFactors(Currency var1);

    default public double discountFactor(Currency currency, LocalDate date) {
        return this.discountFactors(currency).discountFactor(date);
    }
}

