/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.market.amount.CashFlow;
import com.opengamma.strata.market.amount.CashFlows;
import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMap;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.BaseProvider;
import com.opengamma.strata.pricer.CompoundedRateType;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import java.time.LocalDate;

public class DiscountingPaymentPricer {
    public static final DiscountingPaymentPricer DEFAULT = new DiscountingPaymentPricer();

    public CurrencyAmount presentValue(Payment payment, BaseProvider provider) {
        if (provider.getValuationDate().isAfter(payment.getDate())) {
            return CurrencyAmount.zero((Currency)payment.getCurrency());
        }
        double df = provider.discountFactor(payment.getCurrency(), payment.getDate());
        return payment.getValue().multipliedBy(df);
    }

    public CurrencyAmount presentValue(Payment payment, DiscountFactors discountFactors) {
        if (discountFactors.getValuationDate().isAfter(payment.getDate())) {
            return CurrencyAmount.zero((Currency)payment.getCurrency());
        }
        return payment.getValue().multipliedBy(discountFactors.discountFactor(payment.getDate()));
    }

    public double presentValueAmount(Payment payment, BaseProvider provider) {
        if (provider.getValuationDate().isAfter(payment.getDate())) {
            return 0.0;
        }
        double df = provider.discountFactor(payment.getCurrency(), payment.getDate());
        return payment.getAmount() * df;
    }

    public CurrencyAmount presentValueWithSpread(Payment payment, DiscountFactors discountFactors, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        if (discountFactors.getValuationDate().isAfter(payment.getDate())) {
            return CurrencyAmount.zero((Currency)payment.getCurrency());
        }
        double df = discountFactors.discountFactorWithSpread(payment.getDate(), zSpread, compoundedRateType, periodsPerYear);
        return payment.getValue().multipliedBy(df);
    }

    public ExplainMap explainPresentValue(Payment payment, BaseProvider provider) {
        Currency currency = payment.getCurrency();
        LocalDate paymentDate = payment.getDate();
        ExplainMapBuilder builder = ExplainMap.builder();
        builder.put(ExplainKey.ENTRY_TYPE, (Object)"Payment");
        builder.put(ExplainKey.PAYMENT_DATE, (Object)paymentDate);
        builder.put(ExplainKey.PAYMENT_CURRENCY, (Object)currency);
        if (paymentDate.isBefore(provider.getValuationDate())) {
            builder.put(ExplainKey.COMPLETED, (Object)Boolean.TRUE);
            builder.put(ExplainKey.FORECAST_VALUE, (Object)CurrencyAmount.zero((Currency)currency));
            builder.put(ExplainKey.PRESENT_VALUE, (Object)CurrencyAmount.zero((Currency)currency));
        } else {
            builder.put(ExplainKey.DISCOUNT_FACTOR, (Object)provider.discountFactor(currency, paymentDate));
            builder.put(ExplainKey.FORECAST_VALUE, (Object)this.forecastValue(payment, provider));
            builder.put(ExplainKey.PRESENT_VALUE, (Object)this.presentValue(payment, provider));
        }
        return builder.build();
    }

    public PointSensitivityBuilder presentValueSensitivity(Payment payment, BaseProvider provider) {
        if (provider.getValuationDate().isAfter(payment.getDate())) {
            return PointSensitivityBuilder.none();
        }
        DiscountFactors discountFactors = provider.discountFactors(payment.getCurrency());
        return discountFactors.zeroRatePointSensitivity(payment.getDate()).multipliedBy(payment.getAmount());
    }

    public PointSensitivityBuilder presentValueSensitivity(Payment payment, DiscountFactors discountFactors) {
        if (discountFactors.getValuationDate().isAfter(payment.getDate())) {
            return PointSensitivityBuilder.none();
        }
        return discountFactors.zeroRatePointSensitivity(payment.getDate()).multipliedBy(payment.getAmount());
    }

    public PointSensitivityBuilder presentValueSensitivityWithSpread(Payment payment, DiscountFactors discountFactors, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        if (discountFactors.getValuationDate().isAfter(payment.getDate())) {
            return PointSensitivityBuilder.none();
        }
        ZeroRateSensitivity sensi = discountFactors.zeroRatePointSensitivityWithSpread(payment.getDate(), zSpread, compoundedRateType, periodsPerYear);
        return sensi.multipliedBy(payment.getAmount());
    }

    public CurrencyAmount forecastValue(Payment payment, BaseProvider provider) {
        if (provider.getValuationDate().isAfter(payment.getDate())) {
            return CurrencyAmount.zero((Currency)payment.getCurrency());
        }
        return payment.getValue();
    }

    public double forecastValueAmount(Payment payment, BaseProvider provider) {
        if (provider.getValuationDate().isAfter(payment.getDate())) {
            return 0.0;
        }
        return payment.getAmount();
    }

    public CashFlows cashFlows(Payment payment, BaseProvider provider) {
        if (provider.getValuationDate().isAfter(payment.getDate())) {
            return CashFlows.NONE;
        }
        double df = provider.discountFactor(payment.getCurrency(), payment.getDate());
        CashFlow flow = CashFlow.ofForecastValue((LocalDate)payment.getDate(), (Currency)payment.getCurrency(), (double)payment.getAmount(), (double)df);
        return CashFlows.of((CashFlow)flow);
    }

    public MultiCurrencyAmount currencyExposure(Payment payment, BaseProvider provider) {
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{this.presentValue(payment, provider)});
    }

    public CurrencyAmount currentCash(Payment payment, BaseProvider provider) {
        if (payment.getDate().isEqual(provider.getValuationDate())) {
            return payment.getValue();
        }
        return CurrencyAmount.zero((Currency)payment.getCurrency());
    }
}

