/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer;

import com.google.common.collect.ComparisonChain;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.market.sensitivity.MutablePointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.DoubleUnaryOperator;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class ZeroRateSensitivity
implements PointSensitivity,
PointSensitivityBuilder,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Currency curveCurrency;
    @PropertyDefinition
    private final double yearFraction;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    @PropertyDefinition(overrideGet=true)
    private final double sensitivity;
    private static final long serialVersionUID = 1L;

    public static ZeroRateSensitivity of(Currency currency, double yearFraction, double sensitivity) {
        return new ZeroRateSensitivity(currency, yearFraction, currency, sensitivity);
    }

    public static ZeroRateSensitivity of(Currency curveCurrency, double yearFraction, Currency sensitivityCurrency, double sensitivity) {
        return new ZeroRateSensitivity(curveCurrency, yearFraction, sensitivityCurrency, sensitivity);
    }

    public ZeroRateSensitivity withCurrency(Currency currency) {
        if (this.currency.equals((Object)currency)) {
            return this;
        }
        return new ZeroRateSensitivity(this.curveCurrency, this.yearFraction, currency, this.sensitivity);
    }

    public ZeroRateSensitivity withSensitivity(double sensitivity) {
        return new ZeroRateSensitivity(this.curveCurrency, this.yearFraction, this.currency, sensitivity);
    }

    public int compareKey(PointSensitivity other) {
        if (other instanceof ZeroRateSensitivity) {
            ZeroRateSensitivity otherZero = (ZeroRateSensitivity)other;
            return ComparisonChain.start().compare((Comparable)this.curveCurrency, (Comparable)otherZero.curveCurrency).compare((Comparable)this.currency, (Comparable)otherZero.currency).compare(this.yearFraction, otherZero.yearFraction).result();
        }
        return this.getClass().getSimpleName().compareTo(other.getClass().getSimpleName());
    }

    public ZeroRateSensitivity convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        return (ZeroRateSensitivity)super.convertedTo(resultCurrency, rateProvider);
    }

    public ZeroRateSensitivity multipliedBy(double factor) {
        return new ZeroRateSensitivity(this.curveCurrency, this.yearFraction, this.currency, this.sensitivity * factor);
    }

    public ZeroRateSensitivity mapSensitivity(DoubleUnaryOperator operator) {
        return new ZeroRateSensitivity(this.curveCurrency, this.yearFraction, this.currency, operator.applyAsDouble(this.sensitivity));
    }

    public ZeroRateSensitivity normalize() {
        return this;
    }

    public MutablePointSensitivities buildInto(MutablePointSensitivities combination) {
        return combination.add((PointSensitivity)this);
    }

    public ZeroRateSensitivity cloned() {
        return this;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private ZeroRateSensitivity(Currency curveCurrency, double yearFraction, Currency currency, double sensitivity) {
        JodaBeanUtils.notNull((Object)curveCurrency, (String)"curveCurrency");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        this.curveCurrency = curveCurrency;
        this.yearFraction = yearFraction;
        this.currency = currency;
        this.sensitivity = sensitivity;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Currency getCurveCurrency() {
        return this.curveCurrency;
    }

    public double getYearFraction() {
        return this.yearFraction;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public double getSensitivity() {
        return this.sensitivity;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ZeroRateSensitivity other = (ZeroRateSensitivity)obj;
            return JodaBeanUtils.equal((Object)this.curveCurrency, (Object)other.curveCurrency) && JodaBeanUtils.equal((double)this.yearFraction, (double)other.yearFraction) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.sensitivity, (double)other.sensitivity);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.curveCurrency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.yearFraction);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.sensitivity);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("ZeroRateSensitivity{");
        buf.append("curveCurrency").append('=').append(JodaBeanUtils.toString((Object)this.curveCurrency)).append(',').append(' ');
        buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ZeroRateSensitivity> {
        private Currency curveCurrency;
        private double yearFraction;
        private Currency currency;
        private double sensitivity;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1303639584: {
                    return this.curveCurrency;
                }
                case -1731780257: {
                    return this.yearFraction;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1303639584: {
                    this.curveCurrency = (Currency)newValue;
                    break;
                }
                case -1731780257: {
                    this.yearFraction = (Double)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 564403871: {
                    this.sensitivity = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ZeroRateSensitivity build() {
            return new ZeroRateSensitivity(this.curveCurrency, this.yearFraction, this.currency, this.sensitivity);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("ZeroRateSensitivity.Builder{");
            buf.append("curveCurrency").append('=').append(JodaBeanUtils.toString((Object)this.curveCurrency)).append(',').append(' ');
            buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Currency> curveCurrency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"curveCurrency", ZeroRateSensitivity.class, Currency.class);
        private final MetaProperty<Double> yearFraction = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yearFraction", ZeroRateSensitivity.class, Double.TYPE);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", ZeroRateSensitivity.class, Currency.class);
        private final MetaProperty<Double> sensitivity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sensitivity", ZeroRateSensitivity.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"curveCurrency", "yearFraction", "currency", "sensitivity"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1303639584: {
                    return this.curveCurrency;
                }
                case -1731780257: {
                    return this.yearFraction;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ZeroRateSensitivity> builder() {
            return new Builder();
        }

        public Class<? extends ZeroRateSensitivity> beanType() {
            return ZeroRateSensitivity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Currency> curveCurrency() {
            return this.curveCurrency;
        }

        public MetaProperty<Double> yearFraction() {
            return this.yearFraction;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> sensitivity() {
            return this.sensitivity;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1303639584: {
                    return ((ZeroRateSensitivity)bean).getCurveCurrency();
                }
                case -1731780257: {
                    return ((ZeroRateSensitivity)bean).getYearFraction();
                }
                case 575402001: {
                    return ((ZeroRateSensitivity)bean).getCurrency();
                }
                case 564403871: {
                    return ((ZeroRateSensitivity)bean).getSensitivity();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

