/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.bond;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.bond.BlackBondFutureOptionMarginedProductPricer;
import com.opengamma.strata.pricer.bond.BlackBondFutureVolatilities;
import com.opengamma.strata.pricer.bond.BondFutureOptionSensitivity;
import com.opengamma.strata.pricer.bond.BondFutureVolatilities;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.product.bond.ResolvedBondFuture;
import com.opengamma.strata.product.bond.ResolvedBondFutureOption;
import com.opengamma.strata.product.bond.ResolvedBondFutureOptionTrade;
import java.time.LocalDate;

public final class BlackBondFutureOptionMarginedTradePricer {
    public static final BlackBondFutureOptionMarginedTradePricer DEFAULT = new BlackBondFutureOptionMarginedTradePricer(BlackBondFutureOptionMarginedProductPricer.DEFAULT);
    private final BlackBondFutureOptionMarginedProductPricer productPricer;

    public BlackBondFutureOptionMarginedTradePricer(BlackBondFutureOptionMarginedProductPricer productPricer) {
        this.productPricer = (BlackBondFutureOptionMarginedProductPricer)ArgChecker.notNull((Object)productPricer, (String)"productPricer");
    }

    public double price(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingProvider discountingProvider, BondFutureVolatilities volatilities) {
        return this.productPricer.price(trade.getProduct(), discountingProvider, volatilities);
    }

    public CurrencyAmount presentValue(ResolvedBondFutureOptionTrade trade, LocalDate valuationDate, double currentOptionPrice, double lastOptionSettlementPrice) {
        ResolvedBondFutureOption option = trade.getProduct();
        double referencePrice = this.referencePrice(trade, valuationDate, lastOptionSettlementPrice);
        double priceIndex = this.productPricer.marginIndex(option, currentOptionPrice);
        double referenceIndex = this.productPricer.marginIndex(option, referencePrice);
        double pv = (priceIndex - referenceIndex) * trade.getQuantity();
        return CurrencyAmount.of((Currency)option.getUnderlyingFuture().getCurrency(), (double)pv);
    }

    public CurrencyAmount presentValue(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingProvider discountingProvider, BondFutureVolatilities volatilities, double lastOptionSettlementPrice) {
        double price = this.price(trade, discountingProvider, volatilities);
        return this.presentValue(trade, discountingProvider.getValuationDate(), price, lastOptionSettlementPrice);
    }

    public CurrencyAmount presentValue(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingProvider discountingProvider, BlackBondFutureVolatilities volatilities, double futurePrice, double lastOptionSettlementPrice) {
        double optionPrice = this.productPricer.price(trade.getProduct(), discountingProvider, volatilities, futurePrice);
        return this.presentValue(trade, discountingProvider.getValuationDate(), optionPrice, lastOptionSettlementPrice);
    }

    public PointSensitivities presentValueSensitivityRates(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingProvider discountingProvider, BondFutureVolatilities volatilities) {
        ResolvedBondFutureOption product = trade.getProduct();
        PointSensitivities priceSensi = this.productPricer.priceSensitivity(product, discountingProvider, volatilities);
        PointSensitivities marginIndexSensi = this.productPricer.marginIndexSensitivity(product, priceSensi);
        return marginIndexSensi.multipliedBy(trade.getQuantity());
    }

    public BondFutureOptionSensitivity presentValueSensitivityModelParamsVolatility(ResolvedBondFutureOptionTrade futureOptionTrade, LegalEntityDiscountingProvider discountingProvider, BlackBondFutureVolatilities volatilities) {
        ResolvedBondFuture future = futureOptionTrade.getProduct().getUnderlyingFuture();
        double futurePrice = this.productPricer.getFuturePricer().price(future, discountingProvider);
        return this.presentValueSensitivityModelParamsVolatility(futureOptionTrade, discountingProvider, volatilities, futurePrice);
    }

    public BondFutureOptionSensitivity presentValueSensitivityModelParamsVolatility(ResolvedBondFutureOptionTrade futureOptionTrade, LegalEntityDiscountingProvider discountingProvider, BlackBondFutureVolatilities volatilities, double futurePrice) {
        ResolvedBondFutureOption product = futureOptionTrade.getProduct();
        BondFutureOptionSensitivity priceSensitivity = this.productPricer.priceSensitivityModelParamsVolatility(product, discountingProvider, volatilities, futurePrice);
        double factor = this.productPricer.marginIndex(product, 1.0) * futureOptionTrade.getQuantity();
        return priceSensitivity.multipliedBy(factor);
    }

    public MultiCurrencyAmount currencyExposure(ResolvedBondFutureOptionTrade trade, LegalEntityDiscountingProvider discountingProvider, BondFutureVolatilities volatilities, double lastOptionSettlementPrice) {
        double price = this.price(trade, discountingProvider, volatilities);
        return this.currencyExposure(trade, discountingProvider.getValuationDate(), price, lastOptionSettlementPrice);
    }

    public MultiCurrencyAmount currencyExposure(ResolvedBondFutureOptionTrade trade, LocalDate valuationDate, double currentOptionPrice, double lastOptionSettlementPrice) {
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{this.presentValue(trade, valuationDate, currentOptionPrice, lastOptionSettlementPrice)});
    }

    private double referencePrice(ResolvedBondFutureOptionTrade trade, LocalDate valuationDate, double lastSettlementPrice) {
        ArgChecker.notNull((Object)valuationDate, (String)"valuationDate");
        return trade.getTradedPrice().filter(tp -> tp.getTradeDate().equals(valuationDate)).map(tp -> tp.getPrice()).orElse(lastSettlementPrice);
    }
}

