/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.bond;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.bond.BondYieldSensitivity;
import com.opengamma.strata.pricer.bond.BondYieldVolatilities;
import com.opengamma.strata.pricer.bond.DiscountingFixedCouponBondProductPricer;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.pricer.bond.RepoCurveZeroRateSensitivity;
import com.opengamma.strata.pricer.impl.option.BlackFormulaRepository;
import com.opengamma.strata.product.bond.ResolvedFixedCouponBond;
import com.opengamma.strata.product.bond.ResolvedFixedCouponBondOption;
import java.time.LocalDate;

public class BlackFixedCouponBondOptionPricer {
    private final DiscountingFixedCouponBondProductPricer bondPricer;
    public static final BlackFixedCouponBondOptionPricer DEFAULT = new BlackFixedCouponBondOptionPricer(DiscountingFixedCouponBondProductPricer.DEFAULT);

    public BlackFixedCouponBondOptionPricer(DiscountingFixedCouponBondProductPricer bondPricer) {
        this.bondPricer = (DiscountingFixedCouponBondProductPricer)ArgChecker.notNull((Object)bondPricer, (String)"bondPricer");
    }

    protected DiscountingFixedCouponBondProductPricer getBondPricer() {
        return this.bondPricer;
    }

    public CurrencyAmount presentValue(ResolvedFixedCouponBondOption bondOption, LegalEntityDiscountingProvider legalEntityProvider, BondYieldVolatilities volatilities) {
        Currency ccy = bondOption.getCurrency();
        double expiry = volatilities.relativeTime(bondOption.getExpiry());
        ResolvedFixedCouponBond underlying = bondOption.getUnderlying();
        LocalDate settlementDate = bondOption.getSettlement().getSettlementDate();
        double cleanPriceStrike = bondOption.getSettlement().getPrice();
        double dirtyPriceStrike = this.bondPricer.dirtyPriceFromCleanPrice(underlying, settlementDate, cleanPriceStrike);
        double yieldStrike = this.bondPricer.yieldFromDirtyPrice(underlying, settlementDate, dirtyPriceStrike);
        double dirtyPriceSettle = this.bondPricer.dirtyPriceFromCurves(underlying, legalEntityProvider, settlementDate);
        double yieldSettle = this.bondPricer.yieldFromDirtyPrice(underlying, settlementDate, dirtyPriceSettle);
        double modifiedDurationSettle = this.bondPricer.modifiedDurationFromYield(underlying, settlementDate, yieldSettle);
        double priceVolatility = volatilities.priceVolatilityEquivalent(expiry, modifiedDurationSettle, yieldStrike, yieldSettle);
        boolean isCall = bondOption.getQuantity() > 0.0;
        double dfSettle = legalEntityProvider.repoCurveDiscountFactors(underlying.getSecurityId(), underlying.getLegalEntityId(), ccy).discountFactor(settlementDate);
        double price = dfSettle * BlackFormulaRepository.price(dirtyPriceSettle, dirtyPriceStrike, expiry, priceVolatility, isCall);
        return CurrencyAmount.of((Currency)ccy, (double)(price * Math.abs(bondOption.getQuantity()) * (double)bondOption.getLongShort().sign()));
    }

    public PointSensitivities presentValueSensitivityRatesStickyStrike(ResolvedFixedCouponBondOption bondOption, LegalEntityDiscountingProvider legalEntityProvider, BondYieldVolatilities volatilities) {
        Currency ccy = bondOption.getCurrency();
        double expiry = volatilities.relativeTime(bondOption.getExpiry());
        ResolvedFixedCouponBond underlying = bondOption.getUnderlying();
        LocalDate settlementDate = bondOption.getSettlement().getSettlementDate();
        double cleanPriceStrike = bondOption.getSettlement().getPrice();
        double dirtyPriceStrike = this.bondPricer.dirtyPriceFromCleanPrice(underlying, settlementDate, cleanPriceStrike);
        double yieldStrike = this.bondPricer.yieldFromDirtyPrice(underlying, settlementDate, dirtyPriceStrike);
        double dirtyPriceSettle = this.bondPricer.dirtyPriceFromCurves(underlying, legalEntityProvider, settlementDate);
        ValueDerivatives yieldSettle = this.bondPricer.yieldFromDirtyPriceAd(underlying, settlementDate, dirtyPriceSettle);
        ValueDerivatives modifiedDurationSettle = this.bondPricer.modifiedDurationFromYieldAd(underlying, settlementDate, yieldSettle.getValue());
        ValueDerivatives priceVolatility = volatilities.priceVolatilityEquivalentAd(expiry, modifiedDurationSettle.getValue(), yieldStrike, yieldSettle.getValue());
        boolean isCall = bondOption.getQuantity() > 0.0;
        double dfSettle = legalEntityProvider.repoCurveDiscountFactors(underlying.getSecurityId(), underlying.getLegalEntityId(), ccy).discountFactor(settlementDate);
        ValueDerivatives black = BlackFormulaRepository.priceAdjoint(dirtyPriceSettle, dirtyPriceStrike, expiry, priceVolatility.getValue(), isCall);
        double pvBar = 1.0;
        double priceBar = Math.abs(bondOption.getQuantity()) * (double)bondOption.getLongShort().sign() * pvBar;
        double dfSettleBar = black.getValue() * priceBar;
        double blackBar = dfSettle * priceBar;
        double dirtyPriceSettleBar = black.getDerivative(0) * blackBar;
        double priceVolatilityBar = black.getDerivative(3) * blackBar;
        double modifiedDurationSettleBar = priceVolatility.getDerivative(0) * priceVolatilityBar;
        double yieldSettleBar = modifiedDurationSettle.getDerivative(0) * modifiedDurationSettleBar;
        PointSensitivityBuilder sensitivity = PointSensitivityBuilder.none();
        RepoCurveZeroRateSensitivity dfSettleDr = legalEntityProvider.repoCurveDiscountFactors(underlying.getSecurityId(), underlying.getLegalEntityId(), ccy).zeroRatePointSensitivity(settlementDate);
        sensitivity = sensitivity.combinedWith((PointSensitivityBuilder)dfSettleDr.multipliedBy(dfSettleBar));
        PointSensitivityBuilder dirtyPriceSettleDr = this.bondPricer.dirtyPriceSensitivity(underlying, legalEntityProvider, settlementDate);
        sensitivity = sensitivity.combinedWith(dirtyPriceSettleDr.multipliedBy(dirtyPriceSettleBar += yieldSettle.getDerivative(0) * yieldSettleBar));
        return sensitivity.build();
    }

    public BondYieldSensitivity presentValueSensitivityModelParamsVolatility(ResolvedFixedCouponBondOption bondOption, LegalEntityDiscountingProvider legalEntityProvider, BondYieldVolatilities volatilities) {
        Currency ccy = bondOption.getCurrency();
        double expiry = volatilities.relativeTime(bondOption.getExpiry());
        ResolvedFixedCouponBond underlying = bondOption.getUnderlying();
        LocalDate settlementDate = bondOption.getSettlement().getSettlementDate();
        double cleanPriceStrike = bondOption.getSettlement().getPrice();
        double dirtyPriceStrike = this.bondPricer.dirtyPriceFromCleanPrice(underlying, settlementDate, cleanPriceStrike);
        double yieldStrike = this.bondPricer.yieldFromDirtyPrice(underlying, settlementDate, dirtyPriceStrike);
        double dirtyPriceSettle = this.bondPricer.dirtyPriceFromCurves(underlying, legalEntityProvider, settlementDate);
        double yieldSettle = this.bondPricer.yieldFromDirtyPrice(underlying, settlementDate, dirtyPriceSettle);
        double modifiedDurationSettle = this.bondPricer.modifiedDurationFromYield(underlying, settlementDate, yieldSettle);
        ValueDerivatives priceVolatility = volatilities.priceVolatilityEquivalentAd(expiry, modifiedDurationSettle, yieldStrike, yieldSettle);
        boolean isCall = bondOption.getQuantity() > 0.0;
        double dfSettle = legalEntityProvider.repoCurveDiscountFactors(underlying.getSecurityId(), underlying.getLegalEntityId(), ccy).discountFactor(settlementDate);
        ValueDerivatives black = BlackFormulaRepository.priceAdjoint(dirtyPriceSettle, dirtyPriceStrike, expiry, priceVolatility.getValue(), isCall);
        double pvBar = 1.0;
        double priceBar = pvBar * Math.abs(bondOption.getQuantity()) * (double)bondOption.getLongShort().sign();
        double blackBar = dfSettle * priceBar;
        double priceVolatilityBar = black.getDerivative(3) * blackBar;
        double yieldVolatilityBar = priceVolatility.getDerivative(1) * priceVolatilityBar;
        return BondYieldSensitivity.of(volatilities.getName(), expiry, modifiedDurationSettle, yieldStrike, yieldSettle, ccy, yieldVolatilityBar);
    }
}

