/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.bond;

import com.opengamma.strata.market.MarketDataView;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.ParameterizedData;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.pricer.bond.BondFutureVolatilitiesName;
import java.time.LocalDate;
import java.time.ZonedDateTime;

public interface BondFutureVolatilities
extends MarketDataView,
ParameterizedData {
    public BondFutureVolatilitiesName getName();

    public ValueType getVolatilityType();

    default public LocalDate getValuationDate() {
        return this.getValuationDateTime().toLocalDate();
    }

    public ZonedDateTime getValuationDateTime();

    public BondFutureVolatilities withParameter(int var1, double var2);

    public BondFutureVolatilities withPerturbation(ParameterPerturbation var1);

    default public double volatility(ZonedDateTime expiryDateTime, LocalDate fixingDate, double strike, double forward) {
        return this.volatility(this.relativeTime(expiryDateTime), fixingDate, strike, forward);
    }

    public double volatility(double var1, LocalDate var3, double var4, double var6);

    default public CurrencyParameterSensitivities parameterSensitivity(PointSensitivity ... pointSensitivities) {
        return this.parameterSensitivity(PointSensitivities.of((PointSensitivity[])pointSensitivities));
    }

    public CurrencyParameterSensitivities parameterSensitivity(PointSensitivities var1);

    public double relativeTime(ZonedDateTime var1);
}

