/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.bond;

import com.opengamma.strata.basics.value.Rounding;
import com.opengamma.strata.pricer.bond.DiscountingFixedCouponBondProductPricer;
import com.opengamma.strata.product.bond.ResolvedFixedCouponBond;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;

public class BondFuturesUtils {
    public static final DiscountingFixedCouponBondProductPricer PRICER_BOND = DiscountingFixedCouponBondProductPricer.DEFAULT;
    public static final Rounding ROUNDING_EUREX_DE = Rounding.ofDecimalPlaces((int)6);
    public static final Rounding ROUNDING_ICE_UK = Rounding.ofDecimalPlaces((int)7);
    public static final Rounding ROUNDING_CME_US = Rounding.ofDecimalPlaces((int)4);

    private BondFuturesUtils() {
    }

    public static double conversionFactorEurexDE(ResolvedFixedCouponBond bond, LocalDate deliveryDate, double notionalCoupon) {
        double cleanPrice;
        double dirtyPrice = PRICER_BOND.dirtyPriceFromYield(bond, deliveryDate, notionalCoupon);
        double factorRaw = cleanPrice = PRICER_BOND.cleanPriceFromDirtyPrice(bond, deliveryDate, dirtyPrice);
        return ROUNDING_EUREX_DE.round(factorRaw);
    }

    public static double priceFactorIceUK(ResolvedFixedCouponBond bond, LocalDate deliveryDate, double notionalCoupon) {
        double cleanPrice;
        double dirtyPrice = PRICER_BOND.dirtyPriceFromYield(bond, deliveryDate, notionalCoupon);
        double factorRaw = cleanPrice = PRICER_BOND.cleanPriceFromDirtyPrice(bond, deliveryDate, dirtyPrice);
        return ROUNDING_ICE_UK.round(factorRaw);
    }

    public static double conversionFactorCmeUsShort(ResolvedFixedCouponBond bond, LocalDate deliveryDate, double notionalCoupon) {
        double factorOnPeriod = 1.0 / (1.0 + 0.5 * notionalCoupon);
        double coupon = bond.getFixedRate();
        LocalDate maturity = bond.getUnadjustedEndDate();
        long n = ChronoUnit.YEARS.between(deliveryDate, maturity);
        LocalDate referenceDate = deliveryDate.plusYears(n);
        long z = ChronoUnit.MONTHS.between(referenceDate, maturity);
        long v = z < 7L ? z : z - 6L;
        double a = Math.pow(factorOnPeriod, (double)v / 6.0);
        double b = coupon / 2.0 * (6.0 - (double)v) / 6.0;
        double c = z < 7L ? Math.pow(factorOnPeriod, 2L * n) : Math.pow(factorOnPeriod, 2L * n + 1L);
        double d = coupon / notionalCoupon * (1.0 - c);
        double factorRaw = a * (0.5 * coupon + c + d) - b;
        return ROUNDING_CME_US.round(factorRaw);
    }

    public static double conversionFactorCmeUsLong(ResolvedFixedCouponBond bond, LocalDate deliveryDate, double notionalCoupon) {
        double factorOnPeriod = 1.0 / (1.0 + 0.5 * notionalCoupon);
        double coupon = bond.getFixedRate();
        LocalDate maturity = bond.getUnadjustedEndDate();
        long n = ChronoUnit.YEARS.between(deliveryDate, maturity);
        LocalDate referenceDate = deliveryDate.plusYears(n);
        long z = (long)(Math.floor((double)ChronoUnit.MONTHS.between(referenceDate, maturity) / 3.0) * 3.0);
        long v = z < 7L ? z : 3L;
        double a = Math.pow(factorOnPeriod, (double)v / 6.0);
        double b = coupon / 2.0 * (6.0 - (double)v) / 6.0;
        double c = z < 7L ? Math.pow(factorOnPeriod, 2L * n) : Math.pow(factorOnPeriod, 2L * n + 1L);
        double d = coupon / notionalCoupon * (1.0 - c);
        double factorRaw = a * (0.5 * coupon + c + d) - b;
        return ROUNDING_CME_US.round(factorRaw);
    }
}

