/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.bond;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.CompoundedRateType;
import com.opengamma.strata.pricer.DiscountingPaymentPricer;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.bond.DiscountingBillProductPricer;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.pricer.bond.RepoCurveDiscountFactors;
import com.opengamma.strata.pricer.bond.RepoCurveZeroRateSensitivity;
import com.opengamma.strata.product.bond.ResolvedBillTrade;
import java.time.LocalDate;

public class DiscountingBillTradePricer {
    public static final DiscountingBillTradePricer DEFAULT = new DiscountingBillTradePricer(DiscountingBillProductPricer.DEFAULT, DiscountingPaymentPricer.DEFAULT);
    private final DiscountingBillProductPricer productPricer;
    private final DiscountingPaymentPricer paymentPricer;

    public DiscountingBillTradePricer(DiscountingBillProductPricer productPricer, DiscountingPaymentPricer paymentPricer) {
        this.productPricer = (DiscountingBillProductPricer)ArgChecker.notNull((Object)productPricer, (String)"productPricer");
        this.paymentPricer = (DiscountingPaymentPricer)ArgChecker.notNull((Object)paymentPricer, (String)"paymentPricer");
    }

    public DiscountingBillProductPricer getProductPricer() {
        return this.productPricer;
    }

    public CurrencyAmount presentValue(ResolvedBillTrade trade, LegalEntityDiscountingProvider provider) {
        if (provider.getValuationDate().isAfter(trade.getProduct().getNotional().getDate())) {
            return CurrencyAmount.of((Currency)trade.getProduct().getCurrency(), (double)0.0);
        }
        CurrencyAmount pvProduct = this.productPricer.presentValue(trade.getProduct(), provider).multipliedBy(trade.getQuantity());
        if (trade.getSettlement().isPresent()) {
            RepoCurveDiscountFactors repoDf = DiscountingBillProductPricer.repoCurveDf(trade.getProduct(), provider);
            CurrencyAmount pvSettle = this.paymentPricer.presentValue((Payment)trade.getSettlement().get(), repoDf.getDiscountFactors());
            return pvProduct.plus(pvSettle);
        }
        return pvProduct;
    }

    public CurrencyAmount presentValueWithZSpread(ResolvedBillTrade trade, LegalEntityDiscountingProvider provider, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        if (provider.getValuationDate().isAfter(trade.getProduct().getNotional().getDate())) {
            return CurrencyAmount.of((Currency)trade.getProduct().getCurrency(), (double)0.0);
        }
        CurrencyAmount pvProduct = this.productPricer.presentValueWithZSpread(trade.getProduct(), provider, zSpread, compoundedRateType, periodsPerYear).multipliedBy(trade.getQuantity());
        if (trade.getSettlement().isPresent()) {
            RepoCurveDiscountFactors repoDf = DiscountingBillProductPricer.repoCurveDf(trade.getProduct(), provider);
            CurrencyAmount pvSettle = this.paymentPricer.presentValue((Payment)trade.getSettlement().get(), repoDf.getDiscountFactors());
            return pvProduct.plus(pvSettle);
        }
        return pvProduct;
    }

    public PointSensitivities presentValueSensitivity(ResolvedBillTrade trade, LegalEntityDiscountingProvider provider) {
        if (provider.getValuationDate().isAfter(trade.getProduct().getNotional().getDate())) {
            return PointSensitivities.empty();
        }
        PointSensitivities sensiProduct = this.productPricer.presentValueSensitivity(trade.getProduct(), provider).multipliedBy(trade.getQuantity());
        if (!trade.getSettlement().isPresent()) {
            return sensiProduct;
        }
        Payment settlement = (Payment)trade.getSettlement().get();
        RepoCurveDiscountFactors repoDf = DiscountingBillProductPricer.repoCurveDf(trade.getProduct(), provider);
        PointSensitivities sensiSettle = this.presentValueSensitivitySettlement(settlement, repoDf);
        return sensiProduct.combinedWith(sensiSettle);
    }

    public PointSensitivities presentValueSensitivityWithZSpread(ResolvedBillTrade trade, LegalEntityDiscountingProvider provider, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        if (provider.getValuationDate().isAfter(trade.getProduct().getNotional().getDate())) {
            return PointSensitivities.empty();
        }
        PointSensitivities sensiProduct = this.productPricer.presentValueSensitivityWithZSpread(trade.getProduct(), provider, zSpread, compoundedRateType, periodsPerYear).multipliedBy(trade.getQuantity());
        if (!trade.getSettlement().isPresent()) {
            return sensiProduct;
        }
        Payment settlement = (Payment)trade.getSettlement().get();
        RepoCurveDiscountFactors repoDf = DiscountingBillProductPricer.repoCurveDf(trade.getProduct(), provider);
        PointSensitivities sensiSettle = this.presentValueSensitivitySettlement(settlement, repoDf);
        return sensiProduct.combinedWith(sensiSettle);
    }

    public MultiCurrencyAmount currencyExposure(ResolvedBillTrade trade, LegalEntityDiscountingProvider provider) {
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{this.presentValue(trade, provider)});
    }

    public MultiCurrencyAmount currencyExposureWithZSpread(ResolvedBillTrade trade, LegalEntityDiscountingProvider provider, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{this.presentValueWithZSpread(trade, provider, zSpread, compoundedRateType, periodsPerYear)});
    }

    public CurrencyAmount currentCash(ResolvedBillTrade trade, LocalDate valuationDate) {
        if (trade.getProduct().getNotional().getDate().equals(valuationDate)) {
            return trade.getProduct().getNotional().getValue().multipliedBy(trade.getQuantity());
        }
        if (trade.getSettlement().isPresent() && ((Payment)trade.getSettlement().get()).getDate().equals(valuationDate)) {
            return ((Payment)trade.getSettlement().get()).getValue();
        }
        return CurrencyAmount.zero((Currency)trade.getProduct().getCurrency());
    }

    public LocalDate settlementDate(ResolvedBillTrade trade, LocalDate valuationDate) {
        return trade.getSettlement().map(settle -> settle.getDate()).orElse(valuationDate);
    }

    private PointSensitivities presentValueSensitivitySettlement(Payment settlement, RepoCurveDiscountFactors repoDf) {
        PointSensitivityBuilder pointSettle = this.paymentPricer.presentValueSensitivity(settlement, repoDf.getDiscountFactors());
        if (pointSettle instanceof ZeroRateSensitivity) {
            return RepoCurveZeroRateSensitivity.of((ZeroRateSensitivity)pointSettle, repoDf.getRepoGroup()).build();
        }
        return pointSettle.build();
    }
}

