/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.bond;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.CompoundedRateType;
import com.opengamma.strata.pricer.bond.DiscountingBondFutureProductPricer;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.product.bond.ResolvedBondFuture;
import com.opengamma.strata.product.bond.ResolvedBondFutureTrade;
import java.time.LocalDate;

public final class DiscountingBondFutureTradePricer {
    public static final DiscountingBondFutureTradePricer DEFAULT = new DiscountingBondFutureTradePricer(DiscountingBondFutureProductPricer.DEFAULT);
    private final DiscountingBondFutureProductPricer productPricer;

    public DiscountingBondFutureTradePricer(DiscountingBondFutureProductPricer productPricer) {
        this.productPricer = (DiscountingBondFutureProductPricer)ArgChecker.notNull((Object)productPricer, (String)"productPricer");
    }

    CurrencyAmount presentValue(ResolvedBondFutureTrade trade, double currentPrice, double referencePrice) {
        ResolvedBondFuture future = trade.getProduct();
        double priceIndex = this.productPricer.marginIndex(future, currentPrice);
        double referenceIndex = this.productPricer.marginIndex(future, referencePrice);
        double pv = (priceIndex - referenceIndex) * trade.getQuantity();
        return CurrencyAmount.of((Currency)future.getCurrency(), (double)pv);
    }

    public double price(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        return this.productPricer.price(trade.getProduct(), discountingProvider);
    }

    public double priceWithZSpread(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider discountingProvider, double zSpread, CompoundedRateType compoundedRateType, int periodPerYear) {
        return this.productPricer.priceWithZSpread(trade.getProduct(), discountingProvider, zSpread, compoundedRateType, periodPerYear);
    }

    public CurrencyAmount presentValue(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider discountingProvider, double lastSettlementPrice) {
        double price = this.price(trade, discountingProvider);
        double referencePrice = this.referencePrice(trade, discountingProvider.getValuationDate(), lastSettlementPrice);
        return this.presentValue(trade, price, referencePrice);
    }

    public CurrencyAmount presentValueWithZSpread(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider discountingProvider, double lastSettlementPrice, double zSpread, CompoundedRateType compoundedRateType, int periodPerYear) {
        double price = this.priceWithZSpread(trade, discountingProvider, zSpread, compoundedRateType, periodPerYear);
        double referencePrice = this.referencePrice(trade, discountingProvider.getValuationDate(), lastSettlementPrice);
        return this.presentValue(trade, price, referencePrice);
    }

    public PointSensitivities presentValueSensitivity(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        ResolvedBondFuture product = trade.getProduct();
        PointSensitivities priceSensi = this.productPricer.priceSensitivity(product, discountingProvider);
        PointSensitivities marginIndexSensi = this.productPricer.marginIndexSensitivity(product, priceSensi);
        return marginIndexSensi.multipliedBy(trade.getQuantity());
    }

    public PointSensitivities presentValueSensitivityWithZSpread(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider discountingProvider, double zSpread, CompoundedRateType compoundedRateType, int periodPerYear) {
        ResolvedBondFuture product = trade.getProduct();
        PointSensitivities priceSensi = this.productPricer.priceSensitivityWithZSpread(product, discountingProvider, zSpread, compoundedRateType, periodPerYear);
        PointSensitivities marginIndexSensi = this.productPricer.marginIndexSensitivity(product, priceSensi);
        return marginIndexSensi.multipliedBy(trade.getQuantity());
    }

    public double parSpread(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider discountingProvider, double lastSettlementPrice) {
        double referencePrice = this.referencePrice(trade, discountingProvider.getValuationDate(), lastSettlementPrice);
        return this.price(trade, discountingProvider) - referencePrice;
    }

    public double parSpreadWithZSpread(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider discountingProvider, double lastSettlementPrice, double zSpread, CompoundedRateType compoundedRateType, int periodPerYear) {
        double referencePrice = this.referencePrice(trade, discountingProvider.getValuationDate(), lastSettlementPrice);
        return this.priceWithZSpread(trade, discountingProvider, zSpread, compoundedRateType, periodPerYear) - referencePrice;
    }

    public PointSensitivities parSpreadSensitivity(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider discountingProvider) {
        return this.productPricer.priceSensitivity(trade.getProduct(), discountingProvider);
    }

    public PointSensitivities parSpreadSensitivityWithZSpread(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider discountingProvider, double zSpread, CompoundedRateType compoundedRateType, int periodPerYear) {
        return this.productPricer.priceSensitivityWithZSpread(trade.getProduct(), discountingProvider, zSpread, compoundedRateType, periodPerYear);
    }

    public MultiCurrencyAmount currencyExposure(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider discountingProvider, double lastSettlementPrice) {
        double price = this.price(trade, discountingProvider);
        double referencePrice = this.referencePrice(trade, discountingProvider.getValuationDate(), lastSettlementPrice);
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{this.presentValue(trade, price, referencePrice)});
    }

    public MultiCurrencyAmount currencyExposureWithZSpread(ResolvedBondFutureTrade trade, LegalEntityDiscountingProvider discountingProvider, double lastSettlementPrice, double zSpread, CompoundedRateType compoundedRateType, int periodPerYear) {
        double price = this.priceWithZSpread(trade, discountingProvider, zSpread, compoundedRateType, periodPerYear);
        double referencePrice = this.referencePrice(trade, discountingProvider.getValuationDate(), lastSettlementPrice);
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{this.presentValue(trade, price, referencePrice)});
    }

    private double referencePrice(ResolvedBondFutureTrade trade, LocalDate valuationDate, double lastSettlementPrice) {
        ArgChecker.notNull((Object)valuationDate, (String)"valuationDate");
        return trade.getTradedPrice().filter(tp -> tp.getTradeDate().equals(valuationDate)).map(tp -> tp.getPrice()).orElse(lastSettlementPrice);
    }
}

