/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.bond;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.CompoundedRateType;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.bond.IssuerCurveDiscountFactors;
import com.opengamma.strata.pricer.bond.IssuerCurveZeroRateSensitivity;
import com.opengamma.strata.pricer.rate.RateComputationFn;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.bond.CapitalIndexedBondPaymentPeriod;
import com.opengamma.strata.product.rate.RateComputation;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;

public class DiscountingCapitalIndexedBondPaymentPeriodPricer {
    public static final DiscountingCapitalIndexedBondPaymentPeriodPricer DEFAULT = new DiscountingCapitalIndexedBondPaymentPeriodPricer(RateComputationFn.standard());
    private final RateComputationFn<RateComputation> rateComputationFn;

    public DiscountingCapitalIndexedBondPaymentPeriodPricer(RateComputationFn<RateComputation> rateComputationFn) {
        this.rateComputationFn = (RateComputationFn)ArgChecker.notNull(rateComputationFn, (String)"rateComputationFn");
    }

    public RateComputationFn<RateComputation> getRateComputationFn() {
        return this.rateComputationFn;
    }

    public double presentValue(CapitalIndexedBondPaymentPeriod period, RatesProvider ratesProvider, IssuerCurveDiscountFactors issuerDiscountFactors) {
        double df = issuerDiscountFactors.discountFactor(period.getPaymentDate());
        return df * this.forecastValue(period, ratesProvider);
    }

    public double presentValueWithZSpread(CapitalIndexedBondPaymentPeriod period, RatesProvider ratesProvider, IssuerCurveDiscountFactors issuerDiscountFactors, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        double df = issuerDiscountFactors.getDiscountFactors().discountFactorWithSpread(period.getPaymentDate(), zSpread, compoundedRateType, periodsPerYear);
        return df * this.forecastValue(period, ratesProvider);
    }

    public double forecastValue(CapitalIndexedBondPaymentPeriod period, RatesProvider ratesProvider) {
        if (period.getPaymentDate().isBefore(ratesProvider.getValuationDate())) {
            return 0.0;
        }
        double rate = this.rateComputationFn.rate(period.getRateComputation(), period.getStartDate(), period.getEndDate(), ratesProvider);
        return period.getNotional() * period.getRealCoupon() * (rate + 1.0);
    }

    public PointSensitivityBuilder presentValueSensitivity(CapitalIndexedBondPaymentPeriod period, RatesProvider ratesProvider, IssuerCurveDiscountFactors issuerDiscountFactors) {
        if (period.getPaymentDate().isBefore(ratesProvider.getValuationDate())) {
            return PointSensitivityBuilder.none();
        }
        double rate = this.rateComputationFn.rate(period.getRateComputation(), period.getStartDate(), period.getEndDate(), ratesProvider);
        PointSensitivityBuilder rateSensi = this.rateComputationFn.rateSensitivity(period.getRateComputation(), period.getStartDate(), period.getEndDate(), ratesProvider);
        double df = issuerDiscountFactors.discountFactor(period.getPaymentDate());
        IssuerCurveZeroRateSensitivity dfSensi = issuerDiscountFactors.zeroRatePointSensitivity(period.getPaymentDate());
        double factor = period.getNotional() * period.getRealCoupon();
        return rateSensi.multipliedBy(df * factor).combinedWith(dfSensi.multipliedBy((rate + 1.0) * factor));
    }

    public PointSensitivityBuilder presentValueSensitivityWithZSpread(CapitalIndexedBondPaymentPeriod period, RatesProvider ratesProvider, IssuerCurveDiscountFactors issuerDiscountFactors, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        if (period.getPaymentDate().isBefore(ratesProvider.getValuationDate())) {
            return PointSensitivityBuilder.none();
        }
        double rate = this.rateComputationFn.rate(period.getRateComputation(), period.getStartDate(), period.getEndDate(), ratesProvider);
        PointSensitivityBuilder rateSensi = this.rateComputationFn.rateSensitivity(period.getRateComputation(), period.getStartDate(), period.getEndDate(), ratesProvider);
        double df = issuerDiscountFactors.getDiscountFactors().discountFactorWithSpread(period.getPaymentDate(), zSpread, compoundedRateType, periodsPerYear);
        ZeroRateSensitivity zeroSensi = issuerDiscountFactors.getDiscountFactors().zeroRatePointSensitivityWithSpread(period.getPaymentDate(), zSpread, compoundedRateType, periodsPerYear);
        IssuerCurveZeroRateSensitivity dfSensi = IssuerCurveZeroRateSensitivity.of(zeroSensi, issuerDiscountFactors.getLegalEntityGroup());
        double factor = period.getNotional() * period.getRealCoupon();
        return rateSensi.multipliedBy(df * factor).combinedWith((PointSensitivityBuilder)dfSensi.multipliedBy((rate + 1.0) * factor));
    }

    public PointSensitivityBuilder forecastValueSensitivity(CapitalIndexedBondPaymentPeriod period, RatesProvider ratesProvider) {
        if (period.getPaymentDate().isBefore(ratesProvider.getValuationDate())) {
            return PointSensitivityBuilder.none();
        }
        PointSensitivityBuilder rateSensi = this.rateComputationFn.rateSensitivity(period.getRateComputation(), period.getStartDate(), period.getEndDate(), ratesProvider);
        return rateSensi.multipliedBy(period.getNotional() * period.getRealCoupon());
    }

    public void explainPresentValue(CapitalIndexedBondPaymentPeriod period, RatesProvider ratesProvider, IssuerCurveDiscountFactors issuerDiscountFactors, ExplainMapBuilder builder) {
        Currency currency = period.getCurrency();
        LocalDate paymentDate = period.getPaymentDate();
        builder.put(ExplainKey.ENTRY_TYPE, (Object)"CapitalIndexedBondPaymentPeriod");
        builder.put(ExplainKey.PAYMENT_DATE, (Object)paymentDate);
        builder.put(ExplainKey.PAYMENT_CURRENCY, (Object)currency);
        builder.put(ExplainKey.START_DATE, (Object)period.getStartDate());
        builder.put(ExplainKey.UNADJUSTED_START_DATE, (Object)period.getUnadjustedStartDate());
        builder.put(ExplainKey.END_DATE, (Object)period.getEndDate());
        builder.put(ExplainKey.UNADJUSTED_END_DATE, (Object)period.getUnadjustedEndDate());
        builder.put(ExplainKey.DAYS, (Object)((int)ChronoUnit.DAYS.between(period.getUnadjustedStartDate(), period.getUnadjustedEndDate())));
        if (paymentDate.isBefore(ratesProvider.getValuationDate())) {
            builder.put(ExplainKey.COMPLETED, (Object)Boolean.TRUE);
            builder.put(ExplainKey.FORECAST_VALUE, (Object)CurrencyAmount.zero((Currency)currency));
            builder.put(ExplainKey.PRESENT_VALUE, (Object)CurrencyAmount.zero((Currency)currency));
        } else {
            builder.put(ExplainKey.DISCOUNT_FACTOR, (Object)issuerDiscountFactors.discountFactor(paymentDate));
            builder.put(ExplainKey.FORECAST_VALUE, (Object)CurrencyAmount.of((Currency)currency, (double)this.forecastValue(period, ratesProvider)));
            builder.put(ExplainKey.PRESENT_VALUE, (Object)CurrencyAmount.of((Currency)currency, (double)this.presentValue(period, ratesProvider, issuerDiscountFactors)));
        }
    }

    public void explainPresentValueWithZSpread(CapitalIndexedBondPaymentPeriod period, RatesProvider ratesProvider, IssuerCurveDiscountFactors issuerDiscountFactors, ExplainMapBuilder builder, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        Currency currency = period.getCurrency();
        LocalDate paymentDate = period.getPaymentDate();
        builder.put(ExplainKey.ENTRY_TYPE, (Object)"CapitalIndexedBondPaymentPeriod");
        builder.put(ExplainKey.PAYMENT_DATE, (Object)paymentDate);
        builder.put(ExplainKey.PAYMENT_CURRENCY, (Object)currency);
        builder.put(ExplainKey.START_DATE, (Object)period.getStartDate());
        builder.put(ExplainKey.UNADJUSTED_START_DATE, (Object)period.getUnadjustedStartDate());
        builder.put(ExplainKey.END_DATE, (Object)period.getEndDate());
        builder.put(ExplainKey.UNADJUSTED_END_DATE, (Object)period.getUnadjustedEndDate());
        builder.put(ExplainKey.DAYS, (Object)((int)ChronoUnit.DAYS.between(period.getUnadjustedStartDate(), period.getUnadjustedEndDate())));
        if (paymentDate.isBefore(ratesProvider.getValuationDate())) {
            builder.put(ExplainKey.COMPLETED, (Object)Boolean.TRUE);
            builder.put(ExplainKey.FORECAST_VALUE, (Object)CurrencyAmount.zero((Currency)currency));
            builder.put(ExplainKey.PRESENT_VALUE, (Object)CurrencyAmount.zero((Currency)currency));
        } else {
            builder.put(ExplainKey.DISCOUNT_FACTOR, (Object)issuerDiscountFactors.discountFactor(paymentDate));
            builder.put(ExplainKey.FORECAST_VALUE, (Object)CurrencyAmount.of((Currency)currency, (double)this.forecastValue(period, ratesProvider)));
            builder.put(ExplainKey.PRESENT_VALUE, (Object)CurrencyAmount.of((Currency)currency, (double)this.presentValueWithZSpread(period, ratesProvider, issuerDiscountFactors, zSpread, compoundedRateType, periodsPerYear)));
        }
    }
}

