/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.bond;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.math.impl.rootfinding.BracketRoot;
import com.opengamma.strata.math.impl.rootfinding.BrentSingleRootFinder;
import com.opengamma.strata.math.impl.rootfinding.RealSingleRootFinder;
import com.opengamma.strata.pricer.CompoundedRateType;
import com.opengamma.strata.pricer.bond.DiscountingCapitalIndexedBondPaymentPeriodPricer;
import com.opengamma.strata.pricer.bond.IssuerCurveDiscountFactors;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.pricer.bond.RepoCurveDiscountFactors;
import com.opengamma.strata.pricer.bond.RepoCurveZeroRateSensitivity;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.bond.CapitalIndexedBondPaymentPeriod;
import com.opengamma.strata.product.bond.CapitalIndexedBondYieldConvention;
import com.opengamma.strata.product.bond.ResolvedCapitalIndexedBond;
import com.opengamma.strata.product.rate.InflationEndInterpolatedRateComputation;
import com.opengamma.strata.product.rate.InflationEndMonthRateComputation;
import com.opengamma.strata.product.rate.RateComputation;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.temporal.ChronoUnit;
import java.util.function.Function;

public class DiscountingCapitalIndexedBondProductPricer {
    public static final DiscountingCapitalIndexedBondProductPricer DEFAULT = new DiscountingCapitalIndexedBondProductPricer(DiscountingCapitalIndexedBondPaymentPeriodPricer.DEFAULT);
    private static final RealSingleRootFinder ROOT_FINDER = new BrentSingleRootFinder();
    private static final BracketRoot ROOT_BRACKETER = new BracketRoot();
    private static final double FD_EPS = 1.0E-5;
    private final DiscountingCapitalIndexedBondPaymentPeriodPricer periodPricer;

    public DiscountingCapitalIndexedBondProductPricer(DiscountingCapitalIndexedBondPaymentPeriodPricer periodPricer) {
        this.periodPricer = (DiscountingCapitalIndexedBondPaymentPeriodPricer)ArgChecker.notNull((Object)periodPricer, (String)"periodPricer");
    }

    public DiscountingCapitalIndexedBondPaymentPeriodPricer getPeriodPricer() {
        return this.periodPricer;
    }

    public CurrencyAmount presentValue(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider) {
        this.validate(ratesProvider, discountingProvider);
        return this.presentValue(bond, ratesProvider, discountingProvider, ratesProvider.getValuationDate());
    }

    CurrencyAmount presentValue(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, LocalDate referenceDate) {
        IssuerCurveDiscountFactors issuerDf = DiscountingCapitalIndexedBondProductPricer.issuerCurveDf(bond, discountingProvider);
        double pvNominal = this.periodPricer.presentValue(bond.getNominalPayment(), ratesProvider, issuerDf);
        double pvCoupon = 0.0;
        for (CapitalIndexedBondPaymentPeriod period : bond.getPeriodicPayments()) {
            if ((!bond.hasExCouponPeriod() || !period.getDetachmentDate().isAfter(referenceDate)) && (bond.hasExCouponPeriod() || !period.getPaymentDate().isAfter(referenceDate))) continue;
            pvCoupon += this.periodPricer.presentValue(period, ratesProvider, issuerDf);
        }
        return CurrencyAmount.of((Currency)bond.getCurrency(), (double)(pvCoupon + pvNominal));
    }

    public CurrencyAmount presentValueWithZSpread(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        this.validate(ratesProvider, discountingProvider);
        return this.presentValueWithZSpread(bond, ratesProvider, discountingProvider, ratesProvider.getValuationDate(), zSpread, compoundedRateType, periodsPerYear);
    }

    CurrencyAmount presentValueWithZSpread(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, LocalDate referenceDate, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        IssuerCurveDiscountFactors issuerDf = DiscountingCapitalIndexedBondProductPricer.issuerCurveDf(bond, discountingProvider);
        double pvNominal = this.periodPricer.presentValueWithZSpread(bond.getNominalPayment(), ratesProvider, issuerDf, zSpread, compoundedRateType, periodsPerYear);
        double pvCoupon = 0.0;
        for (CapitalIndexedBondPaymentPeriod period : bond.getPeriodicPayments()) {
            if ((!bond.hasExCouponPeriod() || !period.getDetachmentDate().isAfter(referenceDate)) && (bond.hasExCouponPeriod() || !period.getPaymentDate().isAfter(referenceDate))) continue;
            pvCoupon += this.periodPricer.presentValueWithZSpread(period, ratesProvider, issuerDf, zSpread, compoundedRateType, periodsPerYear);
        }
        return CurrencyAmount.of((Currency)bond.getCurrency(), (double)(pvCoupon + pvNominal));
    }

    public PointSensitivityBuilder presentValueSensitivity(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider) {
        this.validate(ratesProvider, discountingProvider);
        return this.presentValueSensitivity(bond, ratesProvider, discountingProvider, ratesProvider.getValuationDate());
    }

    public PointSensitivityBuilder presentValueSensitivity(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, LocalDate referenceDate) {
        IssuerCurveDiscountFactors issuerDf = DiscountingCapitalIndexedBondProductPricer.issuerCurveDf(bond, discountingProvider);
        PointSensitivityBuilder pointNominal = this.periodPricer.presentValueSensitivity(bond.getNominalPayment(), ratesProvider, issuerDf);
        PointSensitivityBuilder pointCoupon = PointSensitivityBuilder.none();
        for (CapitalIndexedBondPaymentPeriod period : bond.getPeriodicPayments()) {
            if ((!bond.hasExCouponPeriod() || !period.getDetachmentDate().isAfter(referenceDate)) && (bond.hasExCouponPeriod() || !period.getPaymentDate().isAfter(referenceDate))) continue;
            pointCoupon = pointCoupon.combinedWith(this.periodPricer.presentValueSensitivity(period, ratesProvider, issuerDf));
        }
        return pointNominal.combinedWith(pointCoupon);
    }

    public PointSensitivityBuilder presentValueSensitivityWithZSpread(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        this.validate(ratesProvider, discountingProvider);
        return this.presentValueSensitivityWithZSpread(bond, ratesProvider, discountingProvider, ratesProvider.getValuationDate(), zSpread, compoundedRateType, periodsPerYear);
    }

    PointSensitivityBuilder presentValueSensitivityWithZSpread(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, LocalDate referenceDate, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        IssuerCurveDiscountFactors issuerDf = DiscountingCapitalIndexedBondProductPricer.issuerCurveDf(bond, discountingProvider);
        PointSensitivityBuilder pointNominal = this.periodPricer.presentValueSensitivityWithZSpread(bond.getNominalPayment(), ratesProvider, issuerDf, zSpread, compoundedRateType, periodsPerYear);
        PointSensitivityBuilder pointCoupon = PointSensitivityBuilder.none();
        for (CapitalIndexedBondPaymentPeriod period : bond.getPeriodicPayments()) {
            if ((!bond.hasExCouponPeriod() || !period.getDetachmentDate().isAfter(referenceDate)) && (bond.hasExCouponPeriod() || !period.getPaymentDate().isAfter(referenceDate))) continue;
            pointCoupon = pointCoupon.combinedWith(this.periodPricer.presentValueSensitivityWithZSpread(period, ratesProvider, issuerDf, zSpread, compoundedRateType, periodsPerYear));
        }
        return pointNominal.combinedWith(pointCoupon);
    }

    public MultiCurrencyAmount currencyExposure(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, LocalDate referenceDate) {
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{this.presentValue(bond, ratesProvider, discountingProvider, referenceDate)});
    }

    public MultiCurrencyAmount currencyExposureWithZSpread(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, LocalDate referenceDate, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{this.presentValueWithZSpread(bond, ratesProvider, discountingProvider, referenceDate, zSpread, compoundedRateType, periodsPerYear)});
    }

    public CurrencyAmount currentCash(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LocalDate settlementDate) {
        LocalDate valuationDate = ratesProvider.getValuationDate();
        Currency currency = bond.getCurrency();
        CurrencyAmount currentCash = CurrencyAmount.zero((Currency)currency);
        if (settlementDate.isBefore(valuationDate)) {
            double cashCoupon = bond.hasExCouponPeriod() ? 0.0 : this.currentCashPayment(bond, ratesProvider, valuationDate);
            CapitalIndexedBondPaymentPeriod nominal = bond.getNominalPayment();
            double cashNominal = nominal.getPaymentDate().isEqual(valuationDate) ? this.periodPricer.forecastValue(nominal, ratesProvider) : 0.0;
            currentCash = currentCash.plus(CurrencyAmount.of((Currency)currency, (double)(cashCoupon + cashNominal)));
        }
        return currentCash;
    }

    private double currentCashPayment(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LocalDate valuationDate) {
        double cash = 0.0;
        for (CapitalIndexedBondPaymentPeriod period : bond.getPeriodicPayments()) {
            if (!period.getPaymentDate().isEqual(valuationDate)) continue;
            cash += this.periodPricer.forecastValue(period, ratesProvider);
        }
        return cash;
    }

    public double dirtyNominalPriceFromCurves(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, ReferenceData refData) {
        this.validate(ratesProvider, discountingProvider);
        LocalDate settlementDate = bond.calculateSettlementDateFromValuation(ratesProvider.getValuationDate(), refData);
        return this.dirtyNominalPriceFromCurves(bond, ratesProvider, discountingProvider, settlementDate);
    }

    public double dirtyNominalPriceFromCurves(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, LocalDate settlementDate) {
        CurrencyAmount pv = this.presentValue(bond, ratesProvider, discountingProvider, settlementDate);
        RepoCurveDiscountFactors repoDf = DiscountingCapitalIndexedBondProductPricer.repoCurveDf(bond, discountingProvider);
        double df = repoDf.discountFactor(settlementDate);
        double notional = bond.getNotional();
        return pv.getAmount() / (df * notional);
    }

    public double dirtyNominalPriceFromCurvesWithZSpread(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, ReferenceData refData, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        this.validate(ratesProvider, discountingProvider);
        LocalDate settlementDate = bond.calculateSettlementDateFromValuation(ratesProvider.getValuationDate(), refData);
        return this.dirtyNominalPriceFromCurvesWithZSpread(bond, ratesProvider, discountingProvider, settlementDate, zSpread, compoundedRateType, periodsPerYear);
    }

    double dirtyNominalPriceFromCurvesWithZSpread(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, LocalDate settlementDate, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        CurrencyAmount pv = this.presentValueWithZSpread(bond, ratesProvider, discountingProvider, settlementDate, zSpread, compoundedRateType, periodsPerYear);
        RepoCurveDiscountFactors repoDf = DiscountingCapitalIndexedBondProductPricer.repoCurveDf(bond, discountingProvider);
        double df = repoDf.discountFactor(settlementDate);
        double notional = bond.getNotional();
        return pv.getAmount() / (df * notional);
    }

    public PointSensitivityBuilder dirtyNominalPriceSensitivity(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, ReferenceData refData) {
        this.validate(ratesProvider, discountingProvider);
        LocalDate settlementDate = bond.calculateSettlementDateFromValuation(ratesProvider.getValuationDate(), refData);
        return this.dirtyNominalPriceSensitivity(bond, ratesProvider, discountingProvider, settlementDate);
    }

    public PointSensitivityBuilder dirtyNominalPriceSensitivity(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, LocalDate settlementDate) {
        double notional = bond.getNotional();
        CurrencyAmount pv = this.presentValue(bond, ratesProvider, discountingProvider, settlementDate);
        RepoCurveDiscountFactors repoDf = DiscountingCapitalIndexedBondProductPricer.repoCurveDf(bond, discountingProvider);
        double df = repoDf.discountFactor(settlementDate);
        PointSensitivityBuilder pvSensi = this.presentValueSensitivity(bond, ratesProvider, discountingProvider, settlementDate).multipliedBy(1.0 / (df * notional));
        RepoCurveZeroRateSensitivity dfSensi = repoDf.zeroRatePointSensitivity(settlementDate).multipliedBy(-pv.getAmount() / (df * df * notional));
        return pvSensi.combinedWith((PointSensitivityBuilder)dfSensi);
    }

    public PointSensitivityBuilder dirtyNominalPriceSensitivityWithZSpread(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, ReferenceData refData, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        this.validate(ratesProvider, discountingProvider);
        LocalDate settlementDate = bond.calculateSettlementDateFromValuation(ratesProvider.getValuationDate(), refData);
        return this.dirtyNominalPriceSensitivityWithZSpread(bond, ratesProvider, discountingProvider, settlementDate, zSpread, compoundedRateType, periodsPerYear);
    }

    PointSensitivityBuilder dirtyNominalPriceSensitivityWithZSpread(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, LocalDate settlementDate, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        double notional = bond.getNotional();
        CurrencyAmount pv = this.presentValueWithZSpread(bond, ratesProvider, discountingProvider, settlementDate, zSpread, compoundedRateType, periodsPerYear);
        RepoCurveDiscountFactors repoDf = DiscountingCapitalIndexedBondProductPricer.repoCurveDf(bond, discountingProvider);
        double df = repoDf.discountFactor(settlementDate);
        PointSensitivityBuilder pvSensi = this.presentValueSensitivityWithZSpread(bond, ratesProvider, discountingProvider, settlementDate, zSpread, compoundedRateType, periodsPerYear).multipliedBy(1.0 / (df * notional));
        RepoCurveZeroRateSensitivity dfSensi = repoDf.zeroRatePointSensitivity(settlementDate).multipliedBy(-pv.getAmount() / df / df / notional);
        return pvSensi.combinedWith((PointSensitivityBuilder)dfSensi);
    }

    public double dirtyPriceFromRealYield(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LocalDate settlementDate, double yield) {
        ArgChecker.isTrue((boolean)settlementDate.isBefore(bond.getUnadjustedEndDate()), (String)"settlement date must be before end date");
        int periodIndex = bond.findPeriodIndex(settlementDate).orElseThrow(() -> new IllegalArgumentException("Date outside range of bond"));
        CapitalIndexedBondPaymentPeriod period = (CapitalIndexedBondPaymentPeriod)bond.getPeriodicPayments().get(periodIndex);
        int nbCoupon = bond.getPeriodicPayments().size() - periodIndex;
        double couponPerYear = bond.getFrequency().eventsPerYear();
        CapitalIndexedBondYieldConvention yieldConvention = bond.getYieldConvention();
        if (yieldConvention.equals((Object)CapitalIndexedBondYieldConvention.US_IL_REAL)) {
            double pvAtFirstCoupon;
            double cpnRate = ((CapitalIndexedBondPaymentPeriod)bond.getPeriodicPayments().get(0)).getRealCoupon();
            if (Math.abs(yield) > 1.0E-8) {
                double factorOnPeriod = 1.0 + yield / couponPerYear;
                double vn = Math.pow(factorOnPeriod, 1 - nbCoupon);
                pvAtFirstCoupon = cpnRate * couponPerYear / yield * (factorOnPeriod - vn) + vn;
            } else {
                pvAtFirstCoupon = cpnRate * (double)nbCoupon + 1.0;
            }
            return pvAtFirstCoupon / (1.0 + this.factorToNextCoupon(bond, settlementDate) * yield / couponPerYear);
        }
        double realRate = period.getRealCoupon();
        double firstYearFraction = bond.yearFraction(period.getUnadjustedStartDate(), period.getUnadjustedEndDate());
        double v = 1.0 / (1.0 + yield / couponPerYear);
        double rs = this.ratioPeriodToNextCoupon(period, settlementDate);
        if (yieldConvention.equals((Object)CapitalIndexedBondYieldConvention.GB_IL_FLOAT)) {
            RateComputation obs = period.getRateComputation();
            LocalDateDoubleTimeSeries ts = ratesProvider.priceIndexValues(bond.getRateCalculation().getIndex()).getFixings();
            YearMonth lastKnownFixingMonth = YearMonth.from(ts.getLatestDate());
            double indexRatio = ts.getLatestValue() / bond.getFirstIndexValue();
            YearMonth endFixingMonth = null;
            if (obs instanceof InflationEndInterpolatedRateComputation) {
                endFixingMonth = ((InflationEndInterpolatedRateComputation)obs).getEndSecondObservation().getFixingMonth();
            } else if (obs instanceof InflationEndMonthRateComputation) {
                endFixingMonth = ((InflationEndMonthRateComputation)obs).getEndObservation().getFixingMonth();
            } else {
                throw new IllegalArgumentException("The rate observation " + obs.toString() + " is not supported.");
            }
            double nbMonth = Math.abs(ChronoUnit.MONTHS.between(endFixingMonth, lastKnownFixingMonth));
            double u = Math.sqrt(0.970873786407767);
            double a = indexRatio * Math.pow(u, nbMonth / 6.0);
            if (nbCoupon == 1) {
                return (realRate + 1.0) * a / u * Math.pow(u * v, rs);
            }
            double firstCashFlow = firstYearFraction * realRate * indexRatio * couponPerYear;
            CapitalIndexedBondPaymentPeriod secondPeriod = (CapitalIndexedBondPaymentPeriod)bond.getPeriodicPayments().get(periodIndex + 1);
            double secondYearFraction = bond.yearFraction(secondPeriod.getUnadjustedStartDate(), secondPeriod.getUnadjustedEndDate());
            double secondCashFlow = secondYearFraction * realRate * indexRatio * couponPerYear;
            double vn = Math.pow(v, nbCoupon - 1);
            double pvAtFirstCoupon = firstCashFlow + secondCashFlow * u * v + a * realRate * v * v * (1.0 - vn / v) / (1.0 - v) + a * vn;
            return pvAtFirstCoupon * Math.pow(u * v, rs);
        }
        if (yieldConvention.equals((Object)CapitalIndexedBondYieldConvention.GB_IL_BOND)) {
            double indexRatio = this.indexRatio(bond, ratesProvider, settlementDate);
            double firstCashFlow = realRate * indexRatio * firstYearFraction * couponPerYear;
            if (nbCoupon == 1) {
                return Math.pow(v, rs) * (firstCashFlow + 1.0);
            }
            CapitalIndexedBondPaymentPeriod secondPeriod = (CapitalIndexedBondPaymentPeriod)bond.getPeriodicPayments().get(periodIndex + 1);
            double secondYearFraction = bond.yearFraction(secondPeriod.getUnadjustedStartDate(), secondPeriod.getUnadjustedEndDate());
            double secondCashFlow = realRate * indexRatio * secondYearFraction * couponPerYear;
            double vn = Math.pow(v, nbCoupon - 1);
            double pvAtFirstCoupon = firstCashFlow + secondCashFlow * v + realRate * v * v * (1.0 - vn / v) / (1.0 - v) + vn;
            return pvAtFirstCoupon * Math.pow(v, rs);
        }
        if (yieldConvention.equals((Object)CapitalIndexedBondYieldConvention.JP_IL_SIMPLE)) {
            LocalDate maturityDate = bond.getEndDate();
            double maturity = bond.yearFraction(settlementDate, maturityDate);
            double cleanPrice = (1.0 + realRate * couponPerYear * maturity) / (1.0 + yield * maturity);
            return this.dirtyRealPriceFromCleanRealPrice(bond, settlementDate, cleanPrice);
        }
        if (yieldConvention.equals((Object)CapitalIndexedBondYieldConvention.JP_IL_COMPOUND)) {
            double pvAtFirstCoupon = 0.0;
            for (int loopcpn = 0; loopcpn < nbCoupon; ++loopcpn) {
                CapitalIndexedBondPaymentPeriod paymentPeriod = (CapitalIndexedBondPaymentPeriod)bond.getPeriodicPayments().get(loopcpn + periodIndex);
                pvAtFirstCoupon += paymentPeriod.getRealCoupon() * Math.pow(v, loopcpn);
            }
            double factorToNext = this.factorToNextCoupon(bond, settlementDate);
            return (pvAtFirstCoupon += Math.pow(v, nbCoupon - 1)) * Math.pow(v, factorToNext);
        }
        throw new IllegalArgumentException("The convention " + bond.getYieldConvention().toString() + " is not supported.");
    }

    public ValueDerivatives dirtyPriceFromRealYieldAd(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LocalDate settlementDate, double yield) {
        ArgChecker.isTrue((boolean)settlementDate.isBefore(bond.getUnadjustedEndDate()), (String)"settlement date must be before end date");
        int periodIndex = bond.findPeriodIndex(settlementDate).orElseThrow(() -> new IllegalArgumentException("Date outside range of bond"));
        CapitalIndexedBondPaymentPeriod period = (CapitalIndexedBondPaymentPeriod)bond.getPeriodicPayments().get(periodIndex);
        int nbCoupon = bond.getPeriodicPayments().size() - periodIndex;
        double couponPerYear = bond.getFrequency().eventsPerYear();
        CapitalIndexedBondYieldConvention yieldConvention = bond.getYieldConvention();
        if (yieldConvention.equals((Object)CapitalIndexedBondYieldConvention.US_IL_REAL)) {
            double pvAtFirstCouponDeriv;
            double pvAtFirstCoupon;
            double cpnRate = ((CapitalIndexedBondPaymentPeriod)bond.getPeriodicPayments().get(0)).getRealCoupon();
            if (Math.abs(yield) > 1.0E-8) {
                double factorOnPeriod = 1.0 + yield / couponPerYear;
                double factorOnPeriodDeriv = 1.0 / couponPerYear;
                double vn = Math.pow(factorOnPeriod, 1 - nbCoupon);
                double vnDeriv = (1.0 - (double)nbCoupon) * Math.pow(factorOnPeriod, -nbCoupon) * factorOnPeriodDeriv;
                pvAtFirstCoupon = cpnRate * couponPerYear / yield * (factorOnPeriod - vn) + vn;
                pvAtFirstCouponDeriv = -cpnRate * couponPerYear / yield / yield * (factorOnPeriod - vn) + cpnRate * couponPerYear / yield * (factorOnPeriodDeriv - vnDeriv) + vnDeriv;
            } else {
                pvAtFirstCoupon = cpnRate * (double)nbCoupon + 1.0;
                pvAtFirstCouponDeriv = (1.0 - (double)nbCoupon) / couponPerYear + 0.5 * (1.0 - (double)nbCoupon) * (double)nbCoupon * cpnRate / couponPerYear;
            }
            double den = 1.0 + this.factorToNextCoupon(bond, settlementDate) * yield / couponPerYear;
            double denDeriv = this.factorToNextCoupon(bond, settlementDate) / couponPerYear;
            double price = pvAtFirstCoupon / den;
            double priceDeriv = pvAtFirstCouponDeriv / den - pvAtFirstCoupon / den / den * denDeriv;
            return ValueDerivatives.of((double)price, (DoubleArray)DoubleArray.of((double)priceDeriv));
        }
        double realRate = period.getRealCoupon();
        double firstYearFraction = bond.yearFraction(period.getUnadjustedStartDate(), period.getUnadjustedEndDate());
        double v = 1.0 / (1.0 + yield / couponPerYear);
        double vDeriv = -v * v / couponPerYear;
        double rs = this.ratioPeriodToNextCoupon(period, settlementDate);
        if (yieldConvention.equals((Object)CapitalIndexedBondYieldConvention.GB_IL_FLOAT)) {
            RateComputation obs = period.getRateComputation();
            LocalDateDoubleTimeSeries ts = ratesProvider.priceIndexValues(bond.getRateCalculation().getIndex()).getFixings();
            YearMonth lastKnownFixingMonth = YearMonth.from(ts.getLatestDate());
            double indexRatio = ts.getLatestValue() / bond.getFirstIndexValue();
            YearMonth endFixingMonth = null;
            if (obs instanceof InflationEndInterpolatedRateComputation) {
                endFixingMonth = ((InflationEndInterpolatedRateComputation)obs).getEndSecondObservation().getFixingMonth();
            } else if (obs instanceof InflationEndMonthRateComputation) {
                endFixingMonth = ((InflationEndMonthRateComputation)obs).getEndObservation().getFixingMonth();
            } else {
                throw new IllegalArgumentException("The rate observation " + obs.toString() + " is not supported.");
            }
            double nbMonth = Math.abs(ChronoUnit.MONTHS.between(endFixingMonth, lastKnownFixingMonth));
            double u = Math.sqrt(0.970873786407767);
            double a = indexRatio * Math.pow(u, nbMonth / 6.0);
            if (nbCoupon == 1) {
                double price = (realRate + 1.0) * a / u * Math.pow(u * v, rs);
                double priceDeriv = (realRate + 1.0) * a / u * Math.pow(u * v, rs - 1.0) * rs * u * vDeriv;
                return ValueDerivatives.of((double)price, (DoubleArray)DoubleArray.of((double)priceDeriv));
            }
            double firstCashFlow = firstYearFraction * realRate * indexRatio * couponPerYear;
            CapitalIndexedBondPaymentPeriod secondPeriod = (CapitalIndexedBondPaymentPeriod)bond.getPeriodicPayments().get(periodIndex + 1);
            double secondYearFraction = bond.yearFraction(secondPeriod.getUnadjustedStartDate(), secondPeriod.getUnadjustedEndDate());
            double secondCashFlow = secondYearFraction * realRate * indexRatio * couponPerYear;
            double vn = Math.pow(v, nbCoupon - 1);
            double vnDeriv = ((double)nbCoupon - 1.0) * Math.pow(v, nbCoupon - 2) * vDeriv;
            double pvAtFirstCoupon = firstCashFlow + secondCashFlow * u * v + a * realRate * v * v * (1.0 - vn / v) / (1.0 - v) + a * vn;
            double pvAtFirstCouponDeriv = secondCashFlow * u * vDeriv + a * vnDeriv + 2.0 * a * realRate * v * vDeriv * (1.0 - vn / v) / (1.0 - v) - a * realRate * v * vnDeriv / (1.0 - v) + a * realRate * vn * vDeriv / (1.0 - v) + a * realRate * v * v * (1.0 - vn / v) / Math.pow(1.0 - v, 2.0) * vDeriv;
            double price = pvAtFirstCoupon * Math.pow(u * v, rs);
            double priceDeriv = pvAtFirstCouponDeriv * Math.pow(u * v, rs) + rs * u * vDeriv * pvAtFirstCoupon * Math.pow(u * v, rs - 1.0);
            return ValueDerivatives.of((double)price, (DoubleArray)DoubleArray.of((double)priceDeriv));
        }
        if (yieldConvention.equals((Object)CapitalIndexedBondYieldConvention.GB_IL_BOND)) {
            double indexRatio = this.indexRatio(bond, ratesProvider, settlementDate);
            double firstCashFlow = realRate * indexRatio * firstYearFraction * couponPerYear;
            if (nbCoupon == 1) {
                double price = Math.pow(v, rs) * (firstCashFlow + 1.0);
                double priceDeriv = rs * vDeriv * Math.pow(v, rs - 1.0) * (firstCashFlow + 1.0);
                return ValueDerivatives.of((double)price, (DoubleArray)DoubleArray.of((double)priceDeriv));
            }
            CapitalIndexedBondPaymentPeriod secondPeriod = (CapitalIndexedBondPaymentPeriod)bond.getPeriodicPayments().get(periodIndex + 1);
            double secondYearFraction = bond.yearFraction(secondPeriod.getUnadjustedStartDate(), secondPeriod.getUnadjustedEndDate());
            double secondCashFlow = realRate * indexRatio * secondYearFraction * couponPerYear;
            double vn = Math.pow(v, nbCoupon - 1);
            double vnDeriv = ((double)nbCoupon - 1.0) * vDeriv * Math.pow(v, nbCoupon - 2);
            double pvAtFirstCoupon = firstCashFlow + secondCashFlow * v + realRate * v * v * (1.0 - vn / v) / (1.0 - v) + vn;
            double pvAtFirstCouponDeriv = secondCashFlow * vDeriv + vnDeriv + 2.0 * realRate * v * vDeriv * (1.0 - vn / v) / (1.0 - v) - realRate * v * vnDeriv / (1.0 - v) + realRate * vDeriv * vn / (1.0 - v) + realRate * v * v * vDeriv * (1.0 - vn / v) / Math.pow(1.0 - v, 2.0);
            double price = pvAtFirstCoupon * Math.pow(v, rs);
            double priceDeriv = pvAtFirstCouponDeriv * Math.pow(v, rs) + pvAtFirstCoupon * Math.pow(v, rs - 1.0) * vDeriv * rs;
            return ValueDerivatives.of((double)price, (DoubleArray)DoubleArray.of((double)priceDeriv));
        }
        if (yieldConvention.equals((Object)CapitalIndexedBondYieldConvention.JP_IL_SIMPLE)) {
            LocalDate maturityDate = bond.getEndDate();
            double maturity = bond.yearFraction(settlementDate, maturityDate);
            double cleanPrice = (1.0 + realRate * couponPerYear * maturity) / (1.0 + yield * maturity);
            double cleanPriceDeriv = -cleanPrice * maturity / (1.0 + yield * maturity);
            double price = this.dirtyRealPriceFromCleanRealPrice(bond, settlementDate, cleanPrice);
            return ValueDerivatives.of((double)price, (DoubleArray)DoubleArray.of((double)cleanPriceDeriv));
        }
        if (yieldConvention.equals((Object)CapitalIndexedBondYieldConvention.JP_IL_COMPOUND)) {
            double pvAtFirstCoupon = 0.0;
            double pvAtFirstCouponDeriv = 0.0;
            for (int loopcpn = 0; loopcpn < nbCoupon; ++loopcpn) {
                CapitalIndexedBondPaymentPeriod paymentPeriod = (CapitalIndexedBondPaymentPeriod)bond.getPeriodicPayments().get(loopcpn + periodIndex);
                pvAtFirstCoupon += paymentPeriod.getRealCoupon() * Math.pow(v, loopcpn);
                pvAtFirstCouponDeriv += paymentPeriod.getRealCoupon() * (double)loopcpn * Math.pow(v, loopcpn - 1) * vDeriv;
            }
            double factorToNext = this.factorToNextCoupon(bond, settlementDate);
            double price = (pvAtFirstCoupon += Math.pow(v, nbCoupon - 1)) * Math.pow(v, factorToNext);
            double priceDeriv = (pvAtFirstCouponDeriv += (double)(nbCoupon - 1) * Math.pow(v, nbCoupon - 2) * vDeriv) * Math.pow(v, factorToNext) + pvAtFirstCoupon * factorToNext * Math.pow(v, factorToNext - 1.0) * vDeriv;
            return ValueDerivatives.of((double)price, (DoubleArray)DoubleArray.of((double)priceDeriv));
        }
        throw new IllegalArgumentException("The convention " + bond.getYieldConvention().toString() + " is not supported.");
    }

    public double cleanPriceFromRealYield(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LocalDate settlementDate, double yield) {
        double dirtyPrice = this.dirtyPriceFromRealYield(bond, ratesProvider, settlementDate, yield);
        return this.cleanRealPriceFromDirtyRealPrice(bond, settlementDate, dirtyPrice);
    }

    public double realYieldFromDirtyPrice(final ResolvedCapitalIndexedBond bond, final RatesProvider ratesProvider, final LocalDate settlementDate, final double dirtyPrice) {
        Function<Double, Double> priceResidual = new Function<Double, Double>(){

            @Override
            public Double apply(Double y) {
                return DiscountingCapitalIndexedBondProductPricer.this.dirtyPriceFromRealYield(bond, ratesProvider, settlementDate, y) - dirtyPrice;
            }
        };
        double[] range = ROOT_BRACKETER.getBracketedPoints((Function)priceResidual, -0.05, 0.1);
        double yield = ROOT_FINDER.getRoot((Function)priceResidual, Double.valueOf(range[0]), Double.valueOf(range[1]));
        return yield;
    }

    public ValueDerivatives realYieldFromDirtyPriceAd(final ResolvedCapitalIndexedBond bond, final RatesProvider ratesProvider, final LocalDate settlementDate, final double dirtyPrice) {
        Function<Double, Double> priceResidual = new Function<Double, Double>(){

            @Override
            public Double apply(Double y) {
                return DiscountingCapitalIndexedBondProductPricer.this.dirtyPriceFromRealYield(bond, ratesProvider, settlementDate, y) - dirtyPrice;
            }
        };
        double[] range = ROOT_BRACKETER.getBracketedPoints((Function)priceResidual, -0.05, 0.1);
        double yield = ROOT_FINDER.getRoot((Function)priceResidual, Double.valueOf(range[0]), Double.valueOf(range[1]));
        ValueDerivatives priceDYield = this.dirtyPriceFromRealYieldAd(bond, ratesProvider, settlementDate, yield);
        return ValueDerivatives.of((double)yield, (DoubleArray)DoubleArray.of((double)(1.0 / priceDYield.getDerivative(0))));
    }

    public double realYieldFromCurves(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, ReferenceData refData) {
        this.validate(ratesProvider, discountingProvider);
        LocalDate settlementDate = bond.calculateSettlementDateFromValuation(ratesProvider.getValuationDate(), refData);
        double dirtyNominalPrice = this.dirtyNominalPriceFromCurves(bond, ratesProvider, discountingProvider, settlementDate);
        double dirtyRealPrice = this.realPriceFromNominalPrice(bond, ratesProvider, settlementDate, dirtyNominalPrice);
        return this.realYieldFromDirtyPrice(bond, ratesProvider, settlementDate, dirtyRealPrice);
    }

    public double dirtyPriceFromStandardYield(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LocalDate settlementDate, double yield) {
        int nbCoupon = bond.getPeriodicPayments().size();
        double couponPerYear = bond.getFrequency().eventsPerYear();
        double factorOnPeriod = 1.0 + yield / couponPerYear;
        double pvAtFirstCoupon = 0.0;
        int pow = 0;
        double factorToNext = this.factorToNextCoupon(bond, settlementDate);
        for (int loopcpn = 0; loopcpn < nbCoupon; ++loopcpn) {
            CapitalIndexedBondPaymentPeriod period = (CapitalIndexedBondPaymentPeriod)bond.getPeriodicPayments().get(loopcpn);
            if ((!bond.hasExCouponPeriod() || settlementDate.isAfter(period.getDetachmentDate())) && (bond.hasExCouponPeriod() || !period.getPaymentDate().isAfter(settlementDate))) continue;
            pvAtFirstCoupon += period.getRealCoupon() / Math.pow(factorOnPeriod, pow);
            ++pow;
        }
        return (pvAtFirstCoupon += 1.0 / Math.pow(factorOnPeriod, pow - 1)) * Math.pow(factorOnPeriod, -factorToNext);
    }

    public double modifiedDurationFromRealYieldFiniteDifference(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LocalDate settlementDate, double yield) {
        double price = this.cleanPriceFromRealYield(bond, ratesProvider, settlementDate, yield);
        double priceplus = this.cleanPriceFromRealYield(bond, ratesProvider, settlementDate, yield + 1.0E-5);
        double priceminus = this.cleanPriceFromRealYield(bond, ratesProvider, settlementDate, yield - 1.0E-5);
        return -0.5 * (priceplus - priceminus) / (price * 1.0E-5);
    }

    public double convexityFromRealYieldFiniteDifference(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LocalDate settlementDate, double yield) {
        double price = this.cleanPriceFromRealYield(bond, ratesProvider, settlementDate, yield);
        double priceplus = this.cleanPriceFromRealYield(bond, ratesProvider, settlementDate, yield + 1.0E-5);
        double priceminus = this.cleanPriceFromRealYield(bond, ratesProvider, settlementDate, yield - 1.0E-5);
        return (priceplus - 2.0 * price + priceminus) / (price * 1.0E-5 * 1.0E-5);
    }

    public double modifiedDurationFromStandardYield(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LocalDate settlementDate, double yield) {
        int nbCoupon = bond.getPeriodicPayments().size();
        double couponPerYear = bond.getFrequency().eventsPerYear();
        double factorOnPeriod = 1.0 + yield / couponPerYear;
        double mdAtFirstCoupon = 0.0;
        double pvAtFirstCoupon = 0.0;
        int pow = 0;
        double factorToNext = this.factorToNextCoupon(bond, settlementDate);
        for (int loopcpn = 0; loopcpn < nbCoupon; ++loopcpn) {
            CapitalIndexedBondPaymentPeriod period = (CapitalIndexedBondPaymentPeriod)bond.getPeriodicPayments().get(loopcpn);
            if ((!bond.hasExCouponPeriod() || settlementDate.isAfter(period.getDetachmentDate())) && (bond.hasExCouponPeriod() || !period.getPaymentDate().isAfter(settlementDate))) continue;
            mdAtFirstCoupon += period.getRealCoupon() / Math.pow(factorOnPeriod, pow + 1) * ((double)pow + factorToNext) / couponPerYear;
            pvAtFirstCoupon += period.getRealCoupon() / Math.pow(factorOnPeriod, pow);
            ++pow;
        }
        double dp = (pvAtFirstCoupon += 1.0 / Math.pow(factorOnPeriod, pow - 1)) * Math.pow(factorOnPeriod, -factorToNext);
        double md = (mdAtFirstCoupon += ((double)pow - 1.0 + factorToNext) / (couponPerYear * Math.pow(factorOnPeriod, pow))) * Math.pow(factorOnPeriod, -factorToNext) / dp;
        return md;
    }

    public double convexityFromStandardYield(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LocalDate settlementDate, double yield) {
        int nbCoupon = bond.getPeriodicPayments().size();
        double couponPerYear = bond.getFrequency().eventsPerYear();
        double factorOnPeriod = 1.0 + yield / couponPerYear;
        double cvAtFirstCoupon = 0.0;
        double pvAtFirstCoupon = 0.0;
        int pow = 0;
        double factorToNext = this.factorToNextCoupon(bond, settlementDate);
        for (int loopcpn = 0; loopcpn < nbCoupon; ++loopcpn) {
            CapitalIndexedBondPaymentPeriod period = (CapitalIndexedBondPaymentPeriod)bond.getPeriodicPayments().get(loopcpn);
            if ((!bond.hasExCouponPeriod() || settlementDate.isAfter(period.getDetachmentDate())) && (bond.hasExCouponPeriod() || !period.getPaymentDate().isAfter(settlementDate))) continue;
            cvAtFirstCoupon += period.getRealCoupon() * ((double)pow + factorToNext) * ((double)pow + factorToNext + 1.0) / (Math.pow(factorOnPeriod, pow + 2) * couponPerYear * couponPerYear);
            pvAtFirstCoupon += period.getRealCoupon() / Math.pow(factorOnPeriod, pow);
            ++pow;
        }
        double pv = (pvAtFirstCoupon += 1.0 / Math.pow(factorOnPeriod, pow - 1)) * Math.pow(factorOnPeriod, -factorToNext);
        double cv = (cvAtFirstCoupon += ((double)pow - 1.0 + factorToNext) * ((double)pow + factorToNext) / (Math.pow(factorOnPeriod, pow + 1) * couponPerYear * couponPerYear)) * Math.pow(factorOnPeriod, -factorToNext) / pv;
        return cv;
    }

    public double dirtyRealPriceFromCleanRealPrice(ResolvedCapitalIndexedBond bond, LocalDate settlementDate, double cleanPrice) {
        double notional = bond.getNotional();
        return cleanPrice + bond.accruedInterest(settlementDate) / notional;
    }

    public double cleanRealPriceFromDirtyRealPrice(ResolvedCapitalIndexedBond bond, LocalDate settlementDate, double dirtyPrice) {
        double notional = bond.getNotional();
        return dirtyPrice - bond.accruedInterest(settlementDate) / notional;
    }

    public double dirtyNominalPriceFromCleanNominalPrice(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LocalDate settlementDate, double cleanPrice) {
        double notional = bond.getNotional();
        double indexRatio = this.indexRatio(bond, ratesProvider, settlementDate);
        return cleanPrice + bond.accruedInterest(settlementDate) / notional * indexRatio;
    }

    public double cleanNominalPriceFromDirtyNominalPrice(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LocalDate settlementDate, double dirtyPrice) {
        double notional = bond.getNotional();
        double indexRatio = this.indexRatio(bond, ratesProvider, settlementDate);
        return dirtyPrice - bond.accruedInterest(settlementDate) / notional * indexRatio;
    }

    public double realPriceFromNominalPrice(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LocalDate settlementDate, double nominalPrice) {
        double indexRatio = this.indexRatio(bond, ratesProvider, settlementDate);
        return nominalPrice / indexRatio;
    }

    public ValueDerivatives realPriceFromNominalPriceAd(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LocalDate settlementDate, double nominalPrice) {
        double indexRatio = this.indexRatio(bond, ratesProvider, settlementDate);
        return ValueDerivatives.of((double)(nominalPrice / indexRatio), (DoubleArray)DoubleArray.of((double)(1.0 / indexRatio)));
    }

    public double nominalPriceFromRealPrice(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LocalDate settlementDate, double realPrice) {
        double indexRatio = this.indexRatio(bond, ratesProvider, settlementDate);
        return realPrice * indexRatio;
    }

    public double zSpreadFromCurvesAndCleanPrice(final ResolvedCapitalIndexedBond bond, final RatesProvider ratesProvider, final LegalEntityDiscountingProvider discountingProvider, ReferenceData refData, final double cleanPrice, final CompoundedRateType compoundedRateType, final int periodsPerYear) {
        this.validate(ratesProvider, discountingProvider);
        final LocalDate settlementDate = bond.calculateSettlementDateFromValuation(ratesProvider.getValuationDate(), refData);
        Function<Double, Double> residual = new Function<Double, Double>(){

            @Override
            public Double apply(Double z) {
                double dirtyPrice = DiscountingCapitalIndexedBondProductPricer.this.dirtyNominalPriceFromCurvesWithZSpread(bond, ratesProvider, discountingProvider, settlementDate, (double)z, compoundedRateType, periodsPerYear);
                double dirtyRealPrice = DiscountingCapitalIndexedBondProductPricer.this.realPriceFromNominalPrice(bond, ratesProvider, settlementDate, dirtyPrice);
                return DiscountingCapitalIndexedBondProductPricer.this.cleanRealPriceFromDirtyRealPrice(bond, settlementDate, dirtyRealPrice) - cleanPrice;
            }
        };
        double[] range = ROOT_BRACKETER.getBracketedPoints((Function)residual, -0.5, 0.5);
        return ROOT_FINDER.getRoot((Function)residual, Double.valueOf(range[0]), Double.valueOf(range[1]));
    }

    public double zSpreadFromCurvesAndPv(final ResolvedCapitalIndexedBond bond, final RatesProvider ratesProvider, final LegalEntityDiscountingProvider discountingProvider, ReferenceData refData, final CurrencyAmount presentValue, final CompoundedRateType compoundedRateType, final int periodsPerYear) {
        this.validate(ratesProvider, discountingProvider);
        final LocalDate settlementDate = bond.calculateSettlementDateFromValuation(ratesProvider.getValuationDate(), refData);
        Function<Double, Double> residual = new Function<Double, Double>(){

            @Override
            public Double apply(Double z) {
                return DiscountingCapitalIndexedBondProductPricer.this.presentValueWithZSpread(bond, ratesProvider, discountingProvider, settlementDate, z, compoundedRateType, periodsPerYear).getAmount() - presentValue.getAmount();
            }
        };
        double[] range = ROOT_BRACKETER.getBracketedPoints((Function)residual, -0.5, 0.5);
        return ROOT_FINDER.getRoot((Function)residual, Double.valueOf(range[0]), Double.valueOf(range[1]));
    }

    private double ratioPeriodToNextCoupon(CapitalIndexedBondPaymentPeriod bond, LocalDate settlementDate) {
        double nbDayToSpot = ChronoUnit.DAYS.between(settlementDate, bond.getUnadjustedEndDate());
        double nbDaysPeriod = ChronoUnit.DAYS.between(bond.getUnadjustedStartDate(), bond.getUnadjustedEndDate());
        return nbDayToSpot / nbDaysPeriod;
    }

    private double factorToNextCoupon(ResolvedCapitalIndexedBond bond, LocalDate settlementDate) {
        if (bond.getUnadjustedStartDate().isAfter(settlementDate)) {
            return 0.0;
        }
        int periodIndex = bond.findPeriodIndex(settlementDate).orElseThrow(() -> new IllegalArgumentException("Date outside range of bond"));
        CapitalIndexedBondPaymentPeriod period = (CapitalIndexedBondPaymentPeriod)bond.getPeriodicPayments().get(periodIndex);
        LocalDate previousAccrualDate = period.getUnadjustedStartDate();
        double factorSpot = bond.yearFraction(previousAccrualDate, settlementDate);
        double factorPeriod = bond.yearFraction(previousAccrualDate, period.getUnadjustedEndDate());
        return (factorPeriod - factorSpot) / factorPeriod;
    }

    double indexRatio(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LocalDate settlementDate) {
        LocalDate endReferenceDate = settlementDate.isBefore(ratesProvider.getValuationDate()) ? ratesProvider.getValuationDate() : settlementDate;
        RateComputation modifiedComputation = bond.getRateCalculation().createRateComputation(endReferenceDate);
        return 1.0 + this.periodPricer.getRateComputationFn().rate(modifiedComputation, bond.getUnadjustedStartDate(), bond.getUnadjustedEndDate(), ratesProvider);
    }

    PointSensitivityBuilder indexRatioSensitivity(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, LocalDate settlementDate) {
        LocalDate endReferenceDate = settlementDate.isBefore(ratesProvider.getValuationDate()) ? ratesProvider.getValuationDate() : settlementDate;
        RateComputation modifiedComputation = bond.getRateCalculation().createRateComputation(endReferenceDate);
        return this.periodPricer.getRateComputationFn().rateSensitivity(modifiedComputation, bond.getUnadjustedStartDate(), bond.getUnadjustedEndDate(), ratesProvider);
    }

    private void validate(RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider) {
        ArgChecker.isTrue((boolean)ratesProvider.getValuationDate().isEqual(discountingProvider.getValuationDate()), (String)"the rates providers should be for the same date");
    }

    double presentValueCoupon(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, IssuerCurveDiscountFactors discountFactors, LocalDate referenceDate1, LocalDate referenceDate2) {
        double pvDiff = 0.0;
        for (CapitalIndexedBondPaymentPeriod period : bond.getPeriodicPayments()) {
            if (!period.getDetachmentDate().isAfter(referenceDate1) || period.getDetachmentDate().isAfter(referenceDate2)) continue;
            pvDiff += this.periodPricer.presentValue(period, ratesProvider, discountFactors);
        }
        return pvDiff;
    }

    double presentValueCouponWithZSpread(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, IssuerCurveDiscountFactors discountFactors, LocalDate referenceDate1, LocalDate referenceDate2, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        double pvDiff = 0.0;
        for (CapitalIndexedBondPaymentPeriod period : bond.getPeriodicPayments()) {
            if (!period.getDetachmentDate().isAfter(referenceDate1) || period.getDetachmentDate().isAfter(referenceDate2)) continue;
            pvDiff += this.periodPricer.presentValueWithZSpread(period, ratesProvider, discountFactors, zSpread, compoundedRateType, periodsPerYear);
        }
        return pvDiff;
    }

    PointSensitivityBuilder presentValueSensitivityCoupon(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, IssuerCurveDiscountFactors discountFactors, LocalDate referenceDate1, LocalDate referenceDate2) {
        PointSensitivityBuilder pvSensiDiff = PointSensitivityBuilder.none();
        for (CapitalIndexedBondPaymentPeriod period : bond.getPeriodicPayments()) {
            if (!period.getDetachmentDate().isAfter(referenceDate1) || period.getDetachmentDate().isAfter(referenceDate2)) continue;
            pvSensiDiff = pvSensiDiff.combinedWith(this.periodPricer.presentValueSensitivity(period, ratesProvider, discountFactors));
        }
        return pvSensiDiff;
    }

    PointSensitivityBuilder presentValueSensitivityCouponWithZSpread(ResolvedCapitalIndexedBond bond, RatesProvider ratesProvider, IssuerCurveDiscountFactors discountFactors, LocalDate referenceDate1, LocalDate referenceDate2, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        PointSensitivityBuilder pvSensiDiff = PointSensitivityBuilder.none();
        for (CapitalIndexedBondPaymentPeriod period : bond.getPeriodicPayments()) {
            if (!period.getDetachmentDate().isAfter(referenceDate1) || period.getDetachmentDate().isAfter(referenceDate2)) continue;
            pvSensiDiff = pvSensiDiff.combinedWith(this.periodPricer.presentValueSensitivityWithZSpread(period, ratesProvider, discountFactors, zSpread, compoundedRateType, periodsPerYear));
        }
        return pvSensiDiff;
    }

    static RepoCurveDiscountFactors repoCurveDf(ResolvedCapitalIndexedBond bond, LegalEntityDiscountingProvider provider) {
        return provider.repoCurveDiscountFactors(bond.getSecurityId(), bond.getLegalEntityId(), bond.getCurrency());
    }

    static IssuerCurveDiscountFactors issuerCurveDf(ResolvedCapitalIndexedBond bond, LegalEntityDiscountingProvider provider) {
        return provider.issuerCurveDiscountFactors(bond.getLegalEntityId(), bond.getCurrency());
    }
}

