/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.bond;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.market.explain.ExplainKey;
import com.opengamma.strata.market.explain.ExplainMapBuilder;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.CompoundedRateType;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.bond.IssuerCurveDiscountFactors;
import com.opengamma.strata.pricer.bond.IssuerCurveZeroRateSensitivity;
import com.opengamma.strata.product.bond.FixedCouponBondPaymentPeriod;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;

public class DiscountingFixedCouponBondPaymentPeriodPricer {
    public static final DiscountingFixedCouponBondPaymentPeriodPricer DEFAULT = new DiscountingFixedCouponBondPaymentPeriodPricer();

    public double presentValue(FixedCouponBondPaymentPeriod period, IssuerCurveDiscountFactors discountFactors) {
        if (period.getPaymentDate().isBefore(discountFactors.getValuationDate())) {
            return 0.0;
        }
        double df = discountFactors.discountFactor(period.getPaymentDate());
        return period.getFixedRate() * period.getNotional() * period.getYearFraction() * df;
    }

    public double presentValueWithSpread(FixedCouponBondPaymentPeriod period, IssuerCurveDiscountFactors discountFactors, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        if (period.getPaymentDate().isBefore(discountFactors.getValuationDate())) {
            return 0.0;
        }
        double df = discountFactors.getDiscountFactors().discountFactorWithSpread(period.getPaymentDate(), zSpread, compoundedRateType, periodsPerYear);
        return period.getFixedRate() * period.getNotional() * period.getYearFraction() * df;
    }

    public double forecastValue(FixedCouponBondPaymentPeriod period, IssuerCurveDiscountFactors discountFactors) {
        if (period.getPaymentDate().isBefore(discountFactors.getValuationDate())) {
            return 0.0;
        }
        return period.getFixedRate() * period.getNotional() * period.getYearFraction();
    }

    public PointSensitivityBuilder presentValueSensitivity(FixedCouponBondPaymentPeriod period, IssuerCurveDiscountFactors discountFactors) {
        if (period.getPaymentDate().isBefore(discountFactors.getValuationDate())) {
            return PointSensitivityBuilder.none();
        }
        IssuerCurveZeroRateSensitivity dscSensi = discountFactors.zeroRatePointSensitivity(period.getPaymentDate());
        return dscSensi.multipliedBy(period.getFixedRate() * period.getNotional() * period.getYearFraction());
    }

    public PointSensitivityBuilder presentValueSensitivityWithSpread(FixedCouponBondPaymentPeriod period, IssuerCurveDiscountFactors discountFactors, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        if (period.getPaymentDate().isBefore(discountFactors.getValuationDate())) {
            return PointSensitivityBuilder.none();
        }
        ZeroRateSensitivity zeroSensi = discountFactors.getDiscountFactors().zeroRatePointSensitivityWithSpread(period.getPaymentDate(), zSpread, compoundedRateType, periodsPerYear);
        IssuerCurveZeroRateSensitivity dscSensi = IssuerCurveZeroRateSensitivity.of(zeroSensi, discountFactors.getLegalEntityGroup());
        return dscSensi.multipliedBy(period.getFixedRate() * period.getNotional() * period.getYearFraction());
    }

    public PointSensitivityBuilder forecastValueSensitivity(FixedCouponBondPaymentPeriod period, IssuerCurveDiscountFactors discountFactors) {
        return PointSensitivityBuilder.none();
    }

    public void explainPresentValue(FixedCouponBondPaymentPeriod period, IssuerCurveDiscountFactors discountFactors, ExplainMapBuilder builder) {
        Currency currency = period.getCurrency();
        LocalDate paymentDate = period.getPaymentDate();
        this.explainBasics(period, builder, currency, paymentDate);
        if (paymentDate.isBefore(discountFactors.getValuationDate())) {
            builder.put(ExplainKey.COMPLETED, (Object)Boolean.TRUE);
            builder.put(ExplainKey.FORECAST_VALUE, (Object)CurrencyAmount.zero((Currency)currency));
            builder.put(ExplainKey.PRESENT_VALUE, (Object)CurrencyAmount.zero((Currency)currency));
        } else {
            builder.put(ExplainKey.DISCOUNT_FACTOR, (Object)discountFactors.discountFactor(paymentDate));
            builder.put(ExplainKey.FORECAST_VALUE, (Object)CurrencyAmount.of((Currency)currency, (double)this.forecastValue(period, discountFactors)));
            builder.put(ExplainKey.PRESENT_VALUE, (Object)CurrencyAmount.of((Currency)currency, (double)this.presentValue(period, discountFactors)));
        }
    }

    public void explainPresentValueWithSpread(FixedCouponBondPaymentPeriod period, IssuerCurveDiscountFactors discountFactors, ExplainMapBuilder builder, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        Currency currency = period.getCurrency();
        LocalDate paymentDate = period.getPaymentDate();
        this.explainBasics(period, builder, currency, paymentDate);
        if (paymentDate.isBefore(discountFactors.getValuationDate())) {
            builder.put(ExplainKey.COMPLETED, (Object)Boolean.TRUE);
            builder.put(ExplainKey.FORECAST_VALUE, (Object)CurrencyAmount.zero((Currency)currency));
            builder.put(ExplainKey.PRESENT_VALUE, (Object)CurrencyAmount.zero((Currency)currency));
        } else {
            builder.put(ExplainKey.DISCOUNT_FACTOR, (Object)discountFactors.getDiscountFactors().discountFactorWithSpread(paymentDate, zSpread, compoundedRateType, periodsPerYear));
            builder.put(ExplainKey.FORECAST_VALUE, (Object)CurrencyAmount.of((Currency)currency, (double)this.forecastValue(period, discountFactors)));
            builder.put(ExplainKey.PRESENT_VALUE, (Object)CurrencyAmount.of((Currency)currency, (double)this.presentValueWithSpread(period, discountFactors, zSpread, compoundedRateType, periodsPerYear)));
        }
    }

    private void explainBasics(FixedCouponBondPaymentPeriod period, ExplainMapBuilder builder, Currency currency, LocalDate paymentDate) {
        builder.put(ExplainKey.ENTRY_TYPE, (Object)"FixedCouponBondPaymentPeriod");
        builder.put(ExplainKey.PAYMENT_DATE, (Object)paymentDate);
        builder.put(ExplainKey.PAYMENT_CURRENCY, (Object)currency);
        builder.put(ExplainKey.START_DATE, (Object)period.getStartDate());
        builder.put(ExplainKey.UNADJUSTED_START_DATE, (Object)period.getUnadjustedStartDate());
        builder.put(ExplainKey.END_DATE, (Object)period.getEndDate());
        builder.put(ExplainKey.UNADJUSTED_END_DATE, (Object)period.getUnadjustedEndDate());
        builder.put(ExplainKey.ACCRUAL_YEAR_FRACTION, (Object)period.getYearFraction());
        builder.put(ExplainKey.DAYS, (Object)((int)ChronoUnit.DAYS.between(period.getStartDate(), period.getEndDate())));
    }
}

