/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.bond;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.math.MathUtils;
import com.opengamma.strata.math.impl.rootfinding.BracketRoot;
import com.opengamma.strata.math.impl.rootfinding.BrentSingleRootFinder;
import com.opengamma.strata.math.impl.rootfinding.RealSingleRootFinder;
import com.opengamma.strata.pricer.CompoundedRateType;
import com.opengamma.strata.pricer.DiscountingPaymentPricer;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.bond.DiscountingFixedCouponBondPaymentPeriodPricer;
import com.opengamma.strata.pricer.bond.IssuerCurveDiscountFactors;
import com.opengamma.strata.pricer.bond.IssuerCurveZeroRateSensitivity;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.pricer.bond.RepoCurveDiscountFactors;
import com.opengamma.strata.pricer.bond.RepoCurveZeroRateSensitivity;
import com.opengamma.strata.product.bond.FixedCouponBondPaymentPeriod;
import com.opengamma.strata.product.bond.FixedCouponBondYieldConvention;
import com.opengamma.strata.product.bond.ResolvedFixedCouponBond;
import java.time.LocalDate;
import java.util.function.Function;

public class DiscountingFixedCouponBondProductPricer {
    public static final DiscountingFixedCouponBondProductPricer DEFAULT = new DiscountingFixedCouponBondProductPricer(DiscountingFixedCouponBondPaymentPeriodPricer.DEFAULT, DiscountingPaymentPricer.DEFAULT);
    private static final RealSingleRootFinder ROOT_FINDER = new BrentSingleRootFinder();
    private static final BracketRoot ROOT_BRACKETER = new BracketRoot();
    private final DiscountingPaymentPricer nominalPricer;
    private final DiscountingFixedCouponBondPaymentPeriodPricer periodPricer;

    public DiscountingFixedCouponBondProductPricer(DiscountingFixedCouponBondPaymentPeriodPricer periodPricer, DiscountingPaymentPricer nominalPricer) {
        this.nominalPricer = (DiscountingPaymentPricer)ArgChecker.notNull((Object)nominalPricer, (String)"nominalPricer");
        this.periodPricer = (DiscountingFixedCouponBondPaymentPeriodPricer)ArgChecker.notNull((Object)periodPricer, (String)"periodPricer");
    }

    public CurrencyAmount presentValue(ResolvedFixedCouponBond bond, LegalEntityDiscountingProvider provider) {
        return this.presentValue(bond, provider, provider.getValuationDate());
    }

    CurrencyAmount presentValue(ResolvedFixedCouponBond bond, LegalEntityDiscountingProvider provider, LocalDate referenceDate) {
        IssuerCurveDiscountFactors issuerDf = DiscountingFixedCouponBondProductPricer.issuerCurveDf(bond, provider);
        CurrencyAmount pvNominal = this.nominalPricer.presentValue(bond.getNominalPayment(), issuerDf.getDiscountFactors());
        CurrencyAmount pvCoupon = this.presentValueCoupon(bond, issuerDf, referenceDate);
        return pvNominal.plus(pvCoupon);
    }

    public CurrencyAmount presentValueWithZSpread(ResolvedFixedCouponBond bond, LegalEntityDiscountingProvider provider, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        return this.presentValueWithZSpread(bond, provider, zSpread, compoundedRateType, periodsPerYear, provider.getValuationDate());
    }

    CurrencyAmount presentValueWithZSpread(ResolvedFixedCouponBond bond, LegalEntityDiscountingProvider provider, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear, LocalDate referenceDate) {
        IssuerCurveDiscountFactors issuerDf = DiscountingFixedCouponBondProductPricer.issuerCurveDf(bond, provider);
        CurrencyAmount pvNominal = this.nominalPricer.presentValueWithSpread(bond.getNominalPayment(), issuerDf.getDiscountFactors(), zSpread, compoundedRateType, periodsPerYear);
        CurrencyAmount pvCoupon = this.presentValueCouponFromZSpread(bond, issuerDf, zSpread, compoundedRateType, periodsPerYear, referenceDate);
        return pvNominal.plus(pvCoupon);
    }

    public double dirtyPriceFromCurves(ResolvedFixedCouponBond bond, LegalEntityDiscountingProvider provider, ReferenceData refData) {
        LocalDate settlementDate = bond.getSettlementDateOffset().adjust(provider.getValuationDate(), refData);
        return this.dirtyPriceFromCurves(bond, provider, settlementDate);
    }

    public double dirtyPriceFromCurves(ResolvedFixedCouponBond bond, LegalEntityDiscountingProvider provider, LocalDate settlementDate) {
        CurrencyAmount pv = this.presentValue(bond, provider, settlementDate);
        RepoCurveDiscountFactors repoDf = DiscountingFixedCouponBondProductPricer.repoCurveDf(bond, provider);
        double df = repoDf.discountFactor(settlementDate);
        double notional = bond.getNotional();
        return pv.getAmount() / df / notional;
    }

    public double dirtyPriceFromCurvesWithZSpread(ResolvedFixedCouponBond bond, LegalEntityDiscountingProvider provider, ReferenceData refData, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        LocalDate settlementDate = bond.getSettlementDateOffset().adjust(provider.getValuationDate(), refData);
        return this.dirtyPriceFromCurvesWithZSpread(bond, provider, zSpread, compoundedRateType, periodsPerYear, settlementDate);
    }

    public double dirtyPriceFromCurvesWithZSpread(ResolvedFixedCouponBond bond, LegalEntityDiscountingProvider provider, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear, LocalDate settlementDate) {
        CurrencyAmount pv = this.presentValueWithZSpread(bond, provider, zSpread, compoundedRateType, periodsPerYear, settlementDate);
        RepoCurveDiscountFactors repoDf = DiscountingFixedCouponBondProductPricer.repoCurveDf(bond, provider);
        double df = repoDf.discountFactor(settlementDate);
        double notional = bond.getNotional();
        return pv.getAmount() / df / notional;
    }

    public double dirtyPriceFromCleanPrice(ResolvedFixedCouponBond bond, LocalDate settlementDate, double cleanPrice) {
        double notional = bond.getNotional();
        double accruedInterest = this.accruedInterest(bond, settlementDate);
        return cleanPrice + accruedInterest / notional;
    }

    public double cleanPriceFromDirtyPrice(ResolvedFixedCouponBond bond, LocalDate settlementDate, double dirtyPrice) {
        double notional = bond.getNotional();
        double accruedInterest = this.accruedInterest(bond, settlementDate);
        return dirtyPrice - accruedInterest / notional;
    }

    public double zSpreadFromCurvesAndDirtyPrice(final ResolvedFixedCouponBond bond, final LegalEntityDiscountingProvider provider, final ReferenceData refData, final double dirtyPrice, final CompoundedRateType compoundedRateType, final int periodsPerYear) {
        Function<Double, Double> residual = new Function<Double, Double>(){

            @Override
            public Double apply(Double z) {
                return DiscountingFixedCouponBondProductPricer.this.dirtyPriceFromCurvesWithZSpread(bond, provider, refData, z, compoundedRateType, periodsPerYear) - dirtyPrice;
            }
        };
        double[] range = ROOT_BRACKETER.getBracketedPoints((Function)residual, -0.01, 0.01);
        return ROOT_FINDER.getRoot((Function)residual, Double.valueOf(range[0]), Double.valueOf(range[1]));
    }

    public PointSensitivityBuilder presentValueSensitivity(ResolvedFixedCouponBond bond, LegalEntityDiscountingProvider provider) {
        return this.presentValueSensitivity(bond, provider, provider.getValuationDate());
    }

    PointSensitivityBuilder presentValueSensitivity(ResolvedFixedCouponBond bond, LegalEntityDiscountingProvider provider, LocalDate referenceDate) {
        IssuerCurveDiscountFactors issuerDf = DiscountingFixedCouponBondProductPricer.issuerCurveDf(bond, provider);
        PointSensitivityBuilder pvNominal = this.presentValueSensitivityNominal(bond, issuerDf);
        PointSensitivityBuilder pvCoupon = this.presentValueSensitivityCoupon(bond, issuerDf, referenceDate);
        return pvNominal.combinedWith(pvCoupon);
    }

    public PointSensitivityBuilder presentValueSensitivityWithZSpread(ResolvedFixedCouponBond bond, LegalEntityDiscountingProvider provider, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        return this.presentValueSensitivityWithZSpread(bond, provider, zSpread, compoundedRateType, periodsPerYear, provider.getValuationDate());
    }

    PointSensitivityBuilder presentValueSensitivityWithZSpread(ResolvedFixedCouponBond bond, LegalEntityDiscountingProvider provider, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear, LocalDate referenceDate) {
        IssuerCurveDiscountFactors issuerDf = DiscountingFixedCouponBondProductPricer.issuerCurveDf(bond, provider);
        PointSensitivityBuilder pvNominal = this.presentValueSensitivityNominalFromZSpread(bond, issuerDf, zSpread, compoundedRateType, periodsPerYear);
        PointSensitivityBuilder pvCoupon = this.presentValueSensitivityCouponFromZSpread(bond, issuerDf, zSpread, compoundedRateType, periodsPerYear, referenceDate);
        return pvNominal.combinedWith(pvCoupon);
    }

    public PointSensitivityBuilder dirtyPriceSensitivity(ResolvedFixedCouponBond bond, LegalEntityDiscountingProvider provider, ReferenceData refData) {
        LocalDate settlementDate = bond.getSettlementDateOffset().adjust(provider.getValuationDate(), refData);
        return this.dirtyPriceSensitivity(bond, provider, settlementDate);
    }

    public PointSensitivityBuilder dirtyPriceSensitivity(ResolvedFixedCouponBond bond, LegalEntityDiscountingProvider provider, LocalDate settlementDate) {
        double notional = bond.getNotional();
        CurrencyAmount pv = this.presentValue(bond, provider, settlementDate);
        RepoCurveDiscountFactors repoDf = DiscountingFixedCouponBondProductPricer.repoCurveDf(bond, provider);
        double df = repoDf.discountFactor(settlementDate);
        double priceBar = 1.0;
        double pvBar = 1.0 / df / notional * priceBar;
        double dfBar = -pv.getAmount() / (df * df) / notional * priceBar;
        RepoCurveZeroRateSensitivity dfDr = repoDf.zeroRatePointSensitivity(settlementDate);
        PointSensitivityBuilder pvDr = this.presentValueSensitivity(bond, provider, settlementDate);
        return pvDr.multipliedBy(pvBar).combinedWith((PointSensitivityBuilder)dfDr.multipliedBy(dfBar));
    }

    public PointSensitivityBuilder dirtyPriceSensitivityWithZspread(ResolvedFixedCouponBond bond, LegalEntityDiscountingProvider provider, ReferenceData refData, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        LocalDate settlementDate = bond.getSettlementDateOffset().adjust(provider.getValuationDate(), refData);
        return this.dirtyPriceSensitivityWithZspread(bond, provider, zSpread, compoundedRateType, periodsPerYear, settlementDate);
    }

    PointSensitivityBuilder dirtyPriceSensitivityWithZspread(ResolvedFixedCouponBond bond, LegalEntityDiscountingProvider provider, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear, LocalDate referenceDate) {
        RepoCurveDiscountFactors repoDf = DiscountingFixedCouponBondProductPricer.repoCurveDf(bond, provider);
        double df = repoDf.discountFactor(referenceDate);
        CurrencyAmount pv = this.presentValueWithZSpread(bond, provider, zSpread, compoundedRateType, periodsPerYear);
        double notional = bond.getNotional();
        PointSensitivityBuilder pvSensi = this.presentValueSensitivityWithZSpread(bond, provider, zSpread, compoundedRateType, periodsPerYear).multipliedBy(1.0 / df / notional);
        RepoCurveZeroRateSensitivity dfSensi = repoDf.zeroRatePointSensitivity(referenceDate).multipliedBy(-pv.getAmount() / df / df / notional);
        return pvSensi.combinedWith((PointSensitivityBuilder)dfSensi);
    }

    public double accruedInterest(ResolvedFixedCouponBond bond, LocalDate settlementDate) {
        double notional = bond.getNotional();
        return this.accruedYearFraction(bond, settlementDate) * bond.getFixedRate() * notional;
    }

    public double accruedYearFraction(ResolvedFixedCouponBond bond, LocalDate settlementDate) {
        if (bond.getUnadjustedStartDate().isAfter(settlementDate)) {
            return 0.0;
        }
        FixedCouponBondPaymentPeriod period = (FixedCouponBondPaymentPeriod)bond.findPeriod(settlementDate).orElseThrow(() -> new IllegalArgumentException("Date outside range of bond"));
        LocalDate previousAccrualDate = period.getUnadjustedStartDate();
        double accruedYearFraction = bond.yearFraction(previousAccrualDate, settlementDate);
        double result = 0.0;
        result = settlementDate.isAfter(period.getDetachmentDate()) ? accruedYearFraction - period.getYearFraction() : accruedYearFraction;
        return result;
    }

    public double dirtyPriceFromYield(ResolvedFixedCouponBond bond, LocalDate settlementDate, double yield) {
        ImmutableList payments = bond.getPeriodicPayments();
        int nCoupon = payments.size() - this.couponIndex((ImmutableList<FixedCouponBondPaymentPeriod>)payments, settlementDate);
        FixedCouponBondYieldConvention yieldConv = bond.getYieldConvention();
        if (nCoupon == 1 && (yieldConv.equals((Object)FixedCouponBondYieldConvention.US_STREET) || yieldConv.equals((Object)FixedCouponBondYieldConvention.DE_BONDS))) {
            FixedCouponBondPaymentPeriod payment = (FixedCouponBondPaymentPeriod)payments.get(payments.size() - 1);
            return (1.0 + payment.getFixedRate() * payment.getYearFraction()) / (1.0 + this.factorToNextCoupon(bond, settlementDate) * yield / (double)bond.getFrequency().eventsPerYear());
        }
        if (yieldConv.equals((Object)FixedCouponBondYieldConvention.US_STREET) || yieldConv.equals((Object)FixedCouponBondYieldConvention.GB_BUMP_DMO) || yieldConv.equals((Object)FixedCouponBondYieldConvention.DE_BONDS)) {
            return this.dirtyPriceFromYieldStandard(bond, settlementDate, yield);
        }
        if (yieldConv.equals((Object)FixedCouponBondYieldConvention.JP_SIMPLE)) {
            LocalDate maturityDate = bond.getUnadjustedEndDate();
            if (settlementDate.isAfter(maturityDate)) {
                return 0.0;
            }
            double maturity = bond.getDayCount().relativeYearFraction(settlementDate, maturityDate);
            double cleanPrice = (1.0 + bond.getFixedRate() * maturity) / (1.0 + yield * maturity);
            return this.dirtyPriceFromCleanPrice(bond, settlementDate, cleanPrice);
        }
        throw new UnsupportedOperationException("The convention " + yieldConv.name() + " is not supported.");
    }

    public ValueDerivatives dirtyPriceFromYieldAd(ResolvedFixedCouponBond bond, LocalDate settlementDate, double yield) {
        ImmutableList payments = bond.getPeriodicPayments();
        int nCoupon = payments.size() - this.couponIndex((ImmutableList<FixedCouponBondPaymentPeriod>)payments, settlementDate);
        FixedCouponBondYieldConvention yieldConv = bond.getYieldConvention();
        if (nCoupon == 1 && (yieldConv.equals((Object)FixedCouponBondYieldConvention.US_STREET) || yieldConv.equals((Object)FixedCouponBondYieldConvention.DE_BONDS))) {
            FixedCouponBondPaymentPeriod payment = (FixedCouponBondPaymentPeriod)payments.get(payments.size() - 1);
            double df = 1.0 + this.factorToNextCoupon(bond, settlementDate) * yield / (double)bond.getFrequency().eventsPerYear();
            double price = (1.0 + payment.getFixedRate() * payment.getYearFraction()) / df;
            double yieldBar = -(1.0 + payment.getFixedRate() * payment.getYearFraction()) / (df * df) * this.factorToNextCoupon(bond, settlementDate) / (double)bond.getFrequency().eventsPerYear();
            return ValueDerivatives.of((double)price, (DoubleArray)DoubleArray.of((double)yieldBar));
        }
        if (yieldConv.equals((Object)FixedCouponBondYieldConvention.US_STREET) || yieldConv.equals((Object)FixedCouponBondYieldConvention.GB_BUMP_DMO) || yieldConv.equals((Object)FixedCouponBondYieldConvention.DE_BONDS)) {
            return this.dirtyPriceFromYieldStandardAd(bond, settlementDate, yield);
        }
        if (yieldConv.equals((Object)FixedCouponBondYieldConvention.JP_SIMPLE)) {
            LocalDate maturityDate = bond.getUnadjustedEndDate();
            if (settlementDate.isAfter(maturityDate)) {
                double price = 0.0;
                return ValueDerivatives.of((double)price, (DoubleArray)DoubleArray.of((double)0.0));
            }
            double maturity = bond.getDayCount().relativeYearFraction(settlementDate, maturityDate);
            double cleanPrice = (1.0 + bond.getFixedRate() * maturity) / (1.0 + yield * maturity);
            double price = this.dirtyPriceFromCleanPrice(bond, settlementDate, cleanPrice);
            double yieldBar = -(1.0 + bond.getFixedRate() * maturity) / ((1.0 + yield * maturity) * (1.0 + yield * maturity)) * maturity;
            return ValueDerivatives.of((double)price, (DoubleArray)DoubleArray.of((double)yieldBar));
        }
        throw new UnsupportedOperationException("The convention " + yieldConv.name() + " is not supported.");
    }

    private double dirtyPriceFromYieldStandard(ResolvedFixedCouponBond bond, LocalDate settlementDate, double yield) {
        int nbCoupon = bond.getPeriodicPayments().size();
        double factorOnPeriod = 1.0 + yield / (double)bond.getFrequency().eventsPerYear();
        double fixedRate = bond.getFixedRate();
        double pvAtFirstCoupon = 0.0;
        int pow = 0;
        for (int loopcpn = 0; loopcpn < nbCoupon; ++loopcpn) {
            FixedCouponBondPaymentPeriod period = (FixedCouponBondPaymentPeriod)bond.getPeriodicPayments().get(loopcpn);
            if ((!period.hasExCouponPeriod() || settlementDate.isAfter(period.getDetachmentDate())) && (period.hasExCouponPeriod() || !period.getPaymentDate().isAfter(settlementDate))) continue;
            pvAtFirstCoupon += fixedRate * period.getYearFraction() / Math.pow(factorOnPeriod, pow);
            ++pow;
        }
        return (pvAtFirstCoupon += 1.0 / Math.pow(factorOnPeriod, pow - 1)) * Math.pow(factorOnPeriod, -this.factorToNextCoupon(bond, settlementDate));
    }

    private ValueDerivatives dirtyPriceFromYieldStandardAd(ResolvedFixedCouponBond bond, LocalDate settlementDate, double yield) {
        int nbCoupon = bond.getPeriodicPayments().size();
        double factorOnPeriod = 1.0 + yield / (double)bond.getFrequency().eventsPerYear();
        double fixedRate = bond.getFixedRate();
        double pvAtFirstCoupon = 0.0;
        int pow = 0;
        for (int loopcpn = 0; loopcpn < nbCoupon; ++loopcpn) {
            FixedCouponBondPaymentPeriod period = (FixedCouponBondPaymentPeriod)bond.getPeriodicPayments().get(loopcpn);
            if ((!period.hasExCouponPeriod() || settlementDate.isAfter(period.getDetachmentDate())) && (period.hasExCouponPeriod() || !period.getPaymentDate().isAfter(settlementDate))) continue;
            pvAtFirstCoupon += fixedRate * period.getYearFraction() * Math.pow(factorOnPeriod, -pow);
            ++pow;
        }
        double factorNextCoupon = this.factorToNextCoupon(bond, settlementDate);
        double priceAfter = Math.pow(factorOnPeriod, -factorNextCoupon);
        double price = (pvAtFirstCoupon += Math.pow(factorOnPeriod, 1.0 - (double)pow)) * priceAfter;
        double priceBar = 1.0;
        double priceAfterBar = pvAtFirstCoupon * priceBar;
        double pvAtFirstCouponBar = priceAfter * priceBar;
        double factorOnPeriodBar = (1.0 - (double)pow) * Math.pow(factorOnPeriod, -pow) * pvAtFirstCouponBar;
        int pow2 = 0;
        for (int loopcpn = 0; loopcpn < nbCoupon; ++loopcpn) {
            FixedCouponBondPaymentPeriod period = (FixedCouponBondPaymentPeriod)bond.getPeriodicPayments().get(loopcpn);
            if ((!period.hasExCouponPeriod() || settlementDate.isAfter(period.getDetachmentDate())) && (period.hasExCouponPeriod() || !period.getPaymentDate().isAfter(settlementDate))) continue;
            pvAtFirstCoupon += fixedRate * period.getYearFraction() * Math.pow(factorOnPeriod, -pow2);
            factorOnPeriodBar += fixedRate * period.getYearFraction() * (double)(-pow2) * Math.pow(factorOnPeriod, -pow2 - 1) * pvAtFirstCouponBar;
            ++pow2;
        }
        double yieldBar = 1.0 / (double)bond.getFrequency().eventsPerYear() * (factorOnPeriodBar += -factorNextCoupon * Math.pow(factorOnPeriod, -factorNextCoupon - 1.0) * priceAfterBar);
        return ValueDerivatives.of((double)price, (DoubleArray)DoubleArray.of((double)yieldBar));
    }

    public double yieldFromDirtyPrice(final ResolvedFixedCouponBond bond, final LocalDate settlementDate, final double dirtyPrice) {
        if (bond.getYieldConvention().equals((Object)FixedCouponBondYieldConvention.JP_SIMPLE)) {
            double cleanPrice = this.cleanPriceFromDirtyPrice(bond, settlementDate, dirtyPrice);
            LocalDate maturityDate = bond.getUnadjustedEndDate();
            double maturity = bond.getDayCount().relativeYearFraction(settlementDate, maturityDate);
            return (bond.getFixedRate() + (1.0 - cleanPrice) / maturity) / cleanPrice;
        }
        Function<Double, Double> priceResidual = new Function<Double, Double>(){

            @Override
            public Double apply(Double y) {
                return DiscountingFixedCouponBondProductPricer.this.dirtyPriceFromYield(bond, settlementDate, y) - dirtyPrice;
            }
        };
        double[] range = ROOT_BRACKETER.getBracketedPoints((Function)priceResidual, 0.0, 0.2);
        double yield = ROOT_FINDER.getRoot((Function)priceResidual, Double.valueOf(range[0]), Double.valueOf(range[1]));
        return yield;
    }

    public ValueDerivatives yieldFromDirtyPriceAd(final ResolvedFixedCouponBond bond, final LocalDate settlementDate, final double dirtyPrice) {
        if (bond.getYieldConvention().equals((Object)FixedCouponBondYieldConvention.JP_SIMPLE)) {
            double cleanPrice = this.cleanPriceFromDirtyPrice(bond, settlementDate, dirtyPrice);
            LocalDate maturityDate = bond.getUnadjustedEndDate();
            double maturity = bond.getDayCount().relativeYearFraction(settlementDate, maturityDate);
            double yield = (bond.getFixedRate() + (1.0 - cleanPrice) / maturity) / cleanPrice;
            double priceBar = (-1.0 / maturity * cleanPrice - (bond.getFixedRate() + (1.0 - cleanPrice) / maturity)) / (cleanPrice * cleanPrice);
            return ValueDerivatives.of((double)yield, (DoubleArray)DoubleArray.of((double)priceBar));
        }
        Function<Double, Double> priceResidual = new Function<Double, Double>(){

            @Override
            public Double apply(Double y) {
                return DiscountingFixedCouponBondProductPricer.this.dirtyPriceFromYield(bond, settlementDate, y) - dirtyPrice;
            }
        };
        double[] range = ROOT_BRACKETER.getBracketedPoints((Function)priceResidual, 0.0, 0.2);
        double yield = ROOT_FINDER.getRoot((Function)priceResidual, Double.valueOf(range[0]), Double.valueOf(range[1]));
        ValueDerivatives priceDYield = this.dirtyPriceFromYieldAd(bond, settlementDate, yield);
        return ValueDerivatives.of((double)yield, (DoubleArray)DoubleArray.of((double)(1.0 / priceDYield.getDerivative(0))));
    }

    public double modifiedDurationFromYield(ResolvedFixedCouponBond bond, LocalDate settlementDate, double yield) {
        ImmutableList payments = bond.getPeriodicPayments();
        int nCoupon = payments.size() - this.couponIndex((ImmutableList<FixedCouponBondPaymentPeriod>)payments, settlementDate);
        FixedCouponBondYieldConvention yieldConv = bond.getYieldConvention();
        if (nCoupon == 1 && (yieldConv.equals((Object)FixedCouponBondYieldConvention.US_STREET) || yieldConv.equals((Object)FixedCouponBondYieldConvention.DE_BONDS))) {
            double couponPerYear = bond.getFrequency().eventsPerYear();
            double factor = this.factorToNextCoupon(bond, settlementDate);
            return factor / couponPerYear / (1.0 + factor * yield / couponPerYear);
        }
        if (yieldConv.equals((Object)FixedCouponBondYieldConvention.US_STREET) || yieldConv.equals((Object)FixedCouponBondYieldConvention.GB_BUMP_DMO) || yieldConv.equals((Object)FixedCouponBondYieldConvention.DE_BONDS)) {
            return this.modifiedDurationFromYieldStandard(bond, settlementDate, yield);
        }
        if (yieldConv.equals((Object)FixedCouponBondYieldConvention.JP_SIMPLE)) {
            LocalDate maturityDate = bond.getUnadjustedEndDate();
            if (settlementDate.isAfter(maturityDate)) {
                return 0.0;
            }
            double maturity = bond.getDayCount().relativeYearFraction(settlementDate, maturityDate);
            double num = 1.0 + bond.getFixedRate() * maturity;
            double den = 1.0 + yield * maturity;
            double dirtyPrice = this.dirtyPriceFromCleanPrice(bond, settlementDate, num / den);
            return num * maturity / den / den / dirtyPrice;
        }
        throw new UnsupportedOperationException("The convention " + yieldConv.name() + " is not supported.");
    }

    public ValueDerivatives modifiedDurationFromYieldAd(ResolvedFixedCouponBond bond, LocalDate settlementDate, double yield) {
        ImmutableList payments = bond.getPeriodicPayments();
        int nCoupon = payments.size() - this.couponIndex((ImmutableList<FixedCouponBondPaymentPeriod>)payments, settlementDate);
        FixedCouponBondYieldConvention yieldConv = bond.getYieldConvention();
        if (nCoupon == 1 && (yieldConv.equals((Object)FixedCouponBondYieldConvention.US_STREET) || yieldConv.equals((Object)FixedCouponBondYieldConvention.DE_BONDS))) {
            double couponPerYear = bond.getFrequency().eventsPerYear();
            double factor = this.factorToNextCoupon(bond, settlementDate);
            double md = factor / couponPerYear / (1.0 + factor * yield / couponPerYear);
            double yieldBar = -factor / couponPerYear / ((1.0 + factor * yield / couponPerYear) * (1.0 + factor * yield / couponPerYear)) * factor / couponPerYear;
            return ValueDerivatives.of((double)md, (DoubleArray)DoubleArray.of((double)yieldBar));
        }
        if (yieldConv.equals((Object)FixedCouponBondYieldConvention.US_STREET) || yieldConv.equals((Object)FixedCouponBondYieldConvention.GB_BUMP_DMO) || yieldConv.equals((Object)FixedCouponBondYieldConvention.DE_BONDS)) {
            return this.modifiedDurationFromYieldStandardAd(bond, settlementDate, yield);
        }
        if (yieldConv.equals((Object)FixedCouponBondYieldConvention.JP_SIMPLE)) {
            double dirtyPriceBar;
            LocalDate maturityDate = bond.getUnadjustedEndDate();
            if (settlementDate.isAfter(maturityDate)) {
                double md = 0.0;
                double yieldBar = 0.0;
                return ValueDerivatives.of((double)md, (DoubleArray)DoubleArray.of((double)yieldBar));
            }
            double maturity = bond.getDayCount().relativeYearFraction(settlementDate, maturityDate);
            double num = 1.0 + bond.getFixedRate() * maturity;
            double den = 1.0 + yield * maturity;
            double cleanPrice = num / den;
            double dirtyPrice = this.dirtyPriceFromCleanPrice(bond, settlementDate, cleanPrice);
            double md = num * maturity / (den * den) / dirtyPrice;
            double mdBar = 1.0;
            double denBar = -2.0 * num * maturity / (den * den * den) / dirtyPrice * mdBar;
            double cleanPriceBar = dirtyPriceBar = -md / dirtyPrice * mdBar;
            double yieldBar = maturity * (denBar += -cleanPrice / den * cleanPriceBar);
            return ValueDerivatives.of((double)md, (DoubleArray)DoubleArray.of((double)yieldBar));
        }
        throw new UnsupportedOperationException("The convention " + yieldConv.name() + " is not supported.");
    }

    private double modifiedDurationFromYieldStandard(ResolvedFixedCouponBond bond, LocalDate settlementDate, double yield) {
        int nbCoupon = bond.getPeriodicPayments().size();
        double couponPerYear = bond.getFrequency().eventsPerYear();
        double factorToNextCoupon = this.factorToNextCoupon(bond, settlementDate);
        double factorOnPeriod = 1.0 + yield / couponPerYear;
        double nominal = bond.getNotional();
        double fixedRate = bond.getFixedRate();
        double mdAtFirstCoupon = 0.0;
        double pvAtFirstCoupon = 0.0;
        int pow = 0;
        for (int loopcpn = 0; loopcpn < nbCoupon; ++loopcpn) {
            FixedCouponBondPaymentPeriod period = (FixedCouponBondPaymentPeriod)bond.getPeriodicPayments().get(loopcpn);
            if ((!period.hasExCouponPeriod() || settlementDate.isAfter(period.getDetachmentDate())) && (period.hasExCouponPeriod() || !period.getPaymentDate().isAfter(settlementDate))) continue;
            mdAtFirstCoupon += period.getYearFraction() / Math.pow(factorOnPeriod, pow + 1) * ((double)pow + factorToNextCoupon) / couponPerYear;
            pvAtFirstCoupon += period.getYearFraction() / Math.pow(factorOnPeriod, pow);
            ++pow;
        }
        mdAtFirstCoupon *= fixedRate * nominal;
        pvAtFirstCoupon *= fixedRate * nominal;
        double md = (mdAtFirstCoupon += nominal / Math.pow(factorOnPeriod, pow) * ((double)(pow - 1) + factorToNextCoupon) / couponPerYear) / (pvAtFirstCoupon += nominal / Math.pow(factorOnPeriod, pow - 1));
        return md;
    }

    private ValueDerivatives modifiedDurationFromYieldStandardAd(ResolvedFixedCouponBond bond, LocalDate settlementDate, double yield) {
        int nbCoupon = bond.getPeriodicPayments().size();
        double couponPerYear = bond.getFrequency().eventsPerYear();
        double factorToNextCoupon = this.factorToNextCoupon(bond, settlementDate);
        double factorOnPeriod = 1.0 + yield / couponPerYear;
        double nominal = bond.getNotional();
        double fixedRate = bond.getFixedRate();
        double mdAtFirstCoupon = 0.0;
        double pvAtFirstCoupon = 0.0;
        int pow = 0;
        for (int loopcpn = 0; loopcpn < nbCoupon; ++loopcpn) {
            FixedCouponBondPaymentPeriod period = (FixedCouponBondPaymentPeriod)bond.getPeriodicPayments().get(loopcpn);
            if ((!period.hasExCouponPeriod() || settlementDate.isAfter(period.getDetachmentDate())) && (period.hasExCouponPeriod() || !period.getPaymentDate().isAfter(settlementDate))) continue;
            mdAtFirstCoupon += period.getYearFraction() / Math.pow(factorOnPeriod, pow + 1) * ((double)pow + factorToNextCoupon) / couponPerYear;
            pvAtFirstCoupon += period.getYearFraction() / Math.pow(factorOnPeriod, pow);
            ++pow;
        }
        mdAtFirstCoupon *= fixedRate * nominal;
        pvAtFirstCoupon *= fixedRate * nominal;
        double md = (mdAtFirstCoupon += nominal / Math.pow(factorOnPeriod, pow) * ((double)(pow - 1) + factorToNextCoupon) / couponPerYear) / (pvAtFirstCoupon += nominal * Math.pow(factorOnPeriod, 1.0 - (double)pow));
        double mdAtFirstCouponBar = 1.0 / pvAtFirstCoupon;
        double pvAtFirstCouponBar = -mdAtFirstCoupon / (pvAtFirstCoupon * pvAtFirstCoupon);
        double factorOnPeriodBar = nominal * (1.0 - (double)pow) * Math.pow(factorOnPeriod, -pow) * pvAtFirstCouponBar;
        factorOnPeriodBar += nominal * (double)(-pow) * Math.pow(factorOnPeriod, (double)(-pow) - 1.0) * ((double)(pow - 1) + factorToNextCoupon) / couponPerYear * mdAtFirstCouponBar;
        int pow2 = 0;
        for (int loopcpn = 0; loopcpn < nbCoupon; ++loopcpn) {
            FixedCouponBondPaymentPeriod period = (FixedCouponBondPaymentPeriod)bond.getPeriodicPayments().get(loopcpn);
            if ((!period.hasExCouponPeriod() || settlementDate.isAfter(period.getDetachmentDate())) && (period.hasExCouponPeriod() || !period.getPaymentDate().isAfter(settlementDate))) continue;
            factorOnPeriodBar += period.getYearFraction() * ((double)(-pow2) - 1.0) * Math.pow(factorOnPeriod, (double)(-pow2) - 2.0) * ((double)pow2 + factorToNextCoupon) / couponPerYear * fixedRate * nominal * mdAtFirstCouponBar;
            factorOnPeriodBar += period.getYearFraction() * (double)(-pow2) * Math.pow(factorOnPeriod, (double)(-pow2) - 1.0) * fixedRate * nominal * pvAtFirstCouponBar;
            ++pow2;
        }
        double yieldBar = 1.0 / couponPerYear * factorOnPeriodBar;
        return ValueDerivatives.of((double)md, (DoubleArray)DoubleArray.of((double)yieldBar));
    }

    public double macaulayDurationFromYield(ResolvedFixedCouponBond bond, LocalDate settlementDate, double yield) {
        ImmutableList payments = bond.getPeriodicPayments();
        int nCoupon = payments.size() - this.couponIndex((ImmutableList<FixedCouponBondPaymentPeriod>)payments, settlementDate);
        FixedCouponBondYieldConvention yieldConv = bond.getYieldConvention();
        if (yieldConv.equals((Object)FixedCouponBondYieldConvention.US_STREET) && nCoupon == 1) {
            return this.factorToNextCoupon(bond, settlementDate) / (double)bond.getFrequency().eventsPerYear();
        }
        if (yieldConv.equals((Object)FixedCouponBondYieldConvention.US_STREET) || yieldConv.equals((Object)FixedCouponBondYieldConvention.GB_BUMP_DMO) || yieldConv.equals((Object)FixedCouponBondYieldConvention.DE_BONDS)) {
            return this.modifiedDurationFromYield(bond, settlementDate, yield) * (1.0 + yield / (double)bond.getFrequency().eventsPerYear());
        }
        throw new UnsupportedOperationException("The convention " + yieldConv.name() + " is not supported.");
    }

    public double convexityFromYield(ResolvedFixedCouponBond bond, LocalDate settlementDate, double yield) {
        ImmutableList payments = bond.getPeriodicPayments();
        int nCoupon = payments.size() - this.couponIndex((ImmutableList<FixedCouponBondPaymentPeriod>)payments, settlementDate);
        FixedCouponBondYieldConvention yieldConv = bond.getYieldConvention();
        if (nCoupon == 1 && (yieldConv.equals((Object)FixedCouponBondYieldConvention.US_STREET) || yieldConv.equals((Object)FixedCouponBondYieldConvention.DE_BONDS))) {
            double couponPerYear = bond.getFrequency().eventsPerYear();
            double factorToNextCoupon = this.factorToNextCoupon(bond, settlementDate);
            double timeToPay = factorToNextCoupon / couponPerYear;
            double disc = 1.0 + factorToNextCoupon * yield / couponPerYear;
            return 2.0 * timeToPay * timeToPay / (disc * disc);
        }
        if (yieldConv.equals((Object)FixedCouponBondYieldConvention.US_STREET) || yieldConv.equals((Object)FixedCouponBondYieldConvention.GB_BUMP_DMO) || yieldConv.equals((Object)FixedCouponBondYieldConvention.DE_BONDS)) {
            return this.convexityFromYieldStandard(bond, settlementDate, yield);
        }
        if (yieldConv.equals((Object)FixedCouponBondYieldConvention.JP_SIMPLE)) {
            LocalDate maturityDate = bond.getUnadjustedEndDate();
            if (settlementDate.isAfter(maturityDate)) {
                return 0.0;
            }
            double maturity = bond.getDayCount().relativeYearFraction(settlementDate, maturityDate);
            double num = 1.0 + bond.getFixedRate() * maturity;
            double den = 1.0 + yield * maturity;
            double dirtyPrice = this.dirtyPriceFromCleanPrice(bond, settlementDate, num / den);
            return 2.0 * num * MathUtils.pow2((double)maturity) * Math.pow(den, -3.0) / dirtyPrice;
        }
        throw new UnsupportedOperationException("The convention " + yieldConv.name() + " is not supported.");
    }

    private double convexityFromYieldStandard(ResolvedFixedCouponBond bond, LocalDate settlementDate, double yield) {
        int nbCoupon = bond.getPeriodicPayments().size();
        double couponPerYear = bond.getFrequency().eventsPerYear();
        double factorToNextCoupon = this.factorToNextCoupon(bond, settlementDate);
        double factorOnPeriod = 1.0 + yield / couponPerYear;
        double nominal = bond.getNotional();
        double fixedRate = bond.getFixedRate();
        double cvAtFirstCoupon = 0.0;
        double pvAtFirstCoupon = 0.0;
        int pow = 0;
        for (int loopcpn = 0; loopcpn < nbCoupon; ++loopcpn) {
            FixedCouponBondPaymentPeriod period = (FixedCouponBondPaymentPeriod)bond.getPeriodicPayments().get(loopcpn);
            if ((!period.hasExCouponPeriod() || settlementDate.isAfter(period.getDetachmentDate())) && (period.hasExCouponPeriod() || !period.getPaymentDate().isAfter(settlementDate))) continue;
            cvAtFirstCoupon += period.getYearFraction() / Math.pow(factorOnPeriod, pow + 2) * ((double)pow + factorToNextCoupon) * ((double)pow + factorToNextCoupon + 1.0);
            pvAtFirstCoupon += period.getYearFraction() / Math.pow(factorOnPeriod, pow);
            ++pow;
        }
        cvAtFirstCoupon *= fixedRate * nominal / (couponPerYear * couponPerYear);
        pvAtFirstCoupon *= fixedRate * nominal;
        double pv = (pvAtFirstCoupon += nominal / Math.pow(factorOnPeriod, pow - 1)) * Math.pow(factorOnPeriod, -factorToNextCoupon);
        double cv = (cvAtFirstCoupon += nominal / Math.pow(factorOnPeriod, pow + 1) * ((double)(pow - 1) + factorToNextCoupon) * ((double)pow + factorToNextCoupon) / (couponPerYear * couponPerYear)) * Math.pow(factorOnPeriod, -factorToNextCoupon) / pv;
        return cv;
    }

    private double factorToNextCoupon(ResolvedFixedCouponBond bond, LocalDate settlementDate) {
        if (((FixedCouponBondPaymentPeriod)bond.getPeriodicPayments().get(0)).getStartDate().isAfter(settlementDate)) {
            return 0.0;
        }
        int couponIndex = this.couponIndex((ImmutableList<FixedCouponBondPaymentPeriod>)bond.getPeriodicPayments(), settlementDate);
        double factorSpot = this.accruedYearFraction(bond, settlementDate);
        double factorPeriod = ((FixedCouponBondPaymentPeriod)bond.getPeriodicPayments().get(couponIndex)).getYearFraction();
        return (factorPeriod - factorSpot) * (double)bond.getFrequency().eventsPerYear();
    }

    private int couponIndex(ImmutableList<FixedCouponBondPaymentPeriod> list, LocalDate date) {
        int nbCoupon = list.size();
        int couponIndex = 0;
        for (int loopcpn = 0; loopcpn < nbCoupon; ++loopcpn) {
            if (!((FixedCouponBondPaymentPeriod)list.get(loopcpn)).getEndDate().isAfter(date)) continue;
            couponIndex = loopcpn;
            break;
        }
        return couponIndex;
    }

    private CurrencyAmount presentValueCoupon(ResolvedFixedCouponBond bond, IssuerCurveDiscountFactors discountFactors, LocalDate referenceDate) {
        double total = 0.0;
        for (FixedCouponBondPaymentPeriod period : bond.getPeriodicPayments()) {
            if (!period.getDetachmentDate().isAfter(referenceDate)) continue;
            total += this.periodPricer.presentValue(period, discountFactors);
        }
        return CurrencyAmount.of((Currency)bond.getCurrency(), (double)total);
    }

    private CurrencyAmount presentValueCouponFromZSpread(ResolvedFixedCouponBond bond, IssuerCurveDiscountFactors discountFactors, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear, LocalDate referenceDate) {
        double total = 0.0;
        for (FixedCouponBondPaymentPeriod period : bond.getPeriodicPayments()) {
            if (period.getDetachmentDate().isBefore(referenceDate)) continue;
            total += this.periodPricer.presentValueWithSpread(period, discountFactors, zSpread, compoundedRateType, periodsPerYear);
        }
        return CurrencyAmount.of((Currency)bond.getCurrency(), (double)total);
    }

    private PointSensitivityBuilder presentValueSensitivityCoupon(ResolvedFixedCouponBond bond, IssuerCurveDiscountFactors discountFactors, LocalDate referenceDate) {
        PointSensitivityBuilder builder = PointSensitivityBuilder.none();
        for (FixedCouponBondPaymentPeriod period : bond.getPeriodicPayments()) {
            if (!period.getDetachmentDate().isAfter(referenceDate)) continue;
            builder = builder.combinedWith(this.periodPricer.presentValueSensitivity(period, discountFactors));
        }
        return builder;
    }

    private PointSensitivityBuilder presentValueSensitivityCouponFromZSpread(ResolvedFixedCouponBond bond, IssuerCurveDiscountFactors discountFactors, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear, LocalDate referenceDate) {
        PointSensitivityBuilder builder = PointSensitivityBuilder.none();
        for (FixedCouponBondPaymentPeriod period : bond.getPeriodicPayments()) {
            if (!period.getDetachmentDate().isAfter(referenceDate)) continue;
            builder = builder.combinedWith(this.periodPricer.presentValueSensitivityWithSpread(period, discountFactors, zSpread, compoundedRateType, periodsPerYear));
        }
        return builder;
    }

    private PointSensitivityBuilder presentValueSensitivityNominal(ResolvedFixedCouponBond bond, IssuerCurveDiscountFactors discountFactors) {
        Payment nominal = bond.getNominalPayment();
        PointSensitivityBuilder pt = this.nominalPricer.presentValueSensitivity(nominal, discountFactors.getDiscountFactors());
        if (pt instanceof ZeroRateSensitivity) {
            return IssuerCurveZeroRateSensitivity.of((ZeroRateSensitivity)pt, discountFactors.getLegalEntityGroup());
        }
        return pt;
    }

    private PointSensitivityBuilder presentValueSensitivityNominalFromZSpread(ResolvedFixedCouponBond bond, IssuerCurveDiscountFactors discountFactors, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        Payment nominal = bond.getNominalPayment();
        PointSensitivityBuilder pt = this.nominalPricer.presentValueSensitivityWithSpread(nominal, discountFactors.getDiscountFactors(), zSpread, compoundedRateType, periodsPerYear);
        if (pt instanceof ZeroRateSensitivity) {
            return IssuerCurveZeroRateSensitivity.of((ZeroRateSensitivity)pt, discountFactors.getLegalEntityGroup());
        }
        return pt;
    }

    double presentValueCoupon(ResolvedFixedCouponBond bond, IssuerCurveDiscountFactors discountFactors, LocalDate referenceDate1, LocalDate referenceDate2) {
        double pvDiff = 0.0;
        for (FixedCouponBondPaymentPeriod period : bond.getPeriodicPayments()) {
            if (!period.getDetachmentDate().isAfter(referenceDate1) || period.getDetachmentDate().isAfter(referenceDate2)) continue;
            pvDiff += this.periodPricer.presentValue(period, discountFactors);
        }
        return pvDiff;
    }

    double presentValueCouponWithZSpread(ResolvedFixedCouponBond expanded, IssuerCurveDiscountFactors discountFactors, LocalDate referenceDate1, LocalDate referenceDate2, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        double pvDiff = 0.0;
        for (FixedCouponBondPaymentPeriod period : expanded.getPeriodicPayments()) {
            if (!period.getDetachmentDate().isAfter(referenceDate1) || period.getDetachmentDate().isAfter(referenceDate2)) continue;
            pvDiff += this.periodPricer.presentValueWithSpread(period, discountFactors, zSpread, compoundedRateType, periodsPerYear);
        }
        return pvDiff;
    }

    static RepoCurveDiscountFactors repoCurveDf(ResolvedFixedCouponBond bond, LegalEntityDiscountingProvider provider) {
        return provider.repoCurveDiscountFactors(bond.getSecurityId(), bond.getLegalEntityId(), bond.getCurrency());
    }

    static IssuerCurveDiscountFactors issuerCurveDf(ResolvedFixedCouponBond bond, LegalEntityDiscountingProvider provider) {
        return provider.issuerCurveDiscountFactors(bond.getLegalEntityId(), bond.getCurrency());
    }
}

