/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.bond;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.CompoundedRateType;
import com.opengamma.strata.pricer.DiscountingPaymentPricer;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.bond.DiscountingFixedCouponBondProductPricer;
import com.opengamma.strata.pricer.bond.IssuerCurveDiscountFactors;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.pricer.bond.RepoCurveDiscountFactors;
import com.opengamma.strata.pricer.bond.RepoCurveZeroRateSensitivity;
import com.opengamma.strata.product.bond.FixedCouponBondPaymentPeriod;
import com.opengamma.strata.product.bond.ResolvedFixedCouponBond;
import com.opengamma.strata.product.bond.ResolvedFixedCouponBondSettlement;
import com.opengamma.strata.product.bond.ResolvedFixedCouponBondTrade;
import java.time.LocalDate;

public class DiscountingFixedCouponBondTradePricer {
    public static final DiscountingFixedCouponBondTradePricer DEFAULT = new DiscountingFixedCouponBondTradePricer(DiscountingFixedCouponBondProductPricer.DEFAULT, DiscountingPaymentPricer.DEFAULT);
    private final DiscountingFixedCouponBondProductPricer productPricer;
    private final DiscountingPaymentPricer paymentPricer;

    public DiscountingFixedCouponBondTradePricer(DiscountingFixedCouponBondProductPricer productPricer, DiscountingPaymentPricer paymentPricer) {
        this.productPricer = (DiscountingFixedCouponBondProductPricer)ArgChecker.notNull((Object)productPricer, (String)"productPricer");
        this.paymentPricer = (DiscountingPaymentPricer)ArgChecker.notNull((Object)paymentPricer, (String)"paymentPricer");
    }

    public DiscountingFixedCouponBondProductPricer getProductPricer() {
        return this.productPricer;
    }

    public CurrencyAmount presentValue(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider provider) {
        LocalDate settlementDate = this.settlementDate(trade, provider.getValuationDate());
        CurrencyAmount pvProduct = this.productPricer.presentValue(trade.getProduct(), provider, settlementDate);
        return this.presentValueFromProductPresentValue(trade, provider, pvProduct);
    }

    public CurrencyAmount presentValueWithZSpread(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider provider, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        LocalDate settlementDate = this.settlementDate(trade, provider.getValuationDate());
        CurrencyAmount pvProduct = this.productPricer.presentValueWithZSpread(trade.getProduct(), provider, zSpread, compoundedRateType, periodsPerYear, settlementDate);
        return this.presentValueFromProductPresentValue(trade, provider, pvProduct);
    }

    private CurrencyAmount presentValueFromProductPresentValue(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider provider, CurrencyAmount productPresentValue) {
        CurrencyAmount pvProduct = productPresentValue.multipliedBy(trade.getQuantity());
        CurrencyAmount pvPayment = this.presentValuePayment(trade, provider);
        return pvProduct.plus(pvPayment);
    }

    public CurrencyAmount presentValueFromCleanPrice(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider provider, ReferenceData refData, double cleanPrice) {
        ResolvedFixedCouponBond product = trade.getProduct();
        LocalDate standardSettlementDate = this.standardSettlementDate(product, provider, refData);
        LocalDate tradeSettlementDate = this.settlementDate(trade, provider.getValuationDate());
        Currency currency = product.getCurrency();
        RepoCurveDiscountFactors repoDf = DiscountingFixedCouponBondProductPricer.repoCurveDf(product, provider);
        double df = repoDf.discountFactor(standardSettlementDate);
        double pvStandard = (cleanPrice * product.getNotional() + this.productPricer.accruedInterest(product, standardSettlementDate)) * df;
        if (standardSettlementDate.isEqual(tradeSettlementDate)) {
            return this.presentValueFromProductPresentValue(trade, provider, CurrencyAmount.of((Currency)currency, (double)pvStandard));
        }
        IssuerCurveDiscountFactors issuerDf = DiscountingFixedCouponBondProductPricer.issuerCurveDf(product, provider);
        double pvDiff = 0.0;
        pvDiff = standardSettlementDate.isAfter(tradeSettlementDate) ? this.productPricer.presentValueCoupon(product, issuerDf, tradeSettlementDate, standardSettlementDate) : -this.productPricer.presentValueCoupon(product, issuerDf, standardSettlementDate, tradeSettlementDate);
        return this.presentValueFromProductPresentValue(trade, provider, CurrencyAmount.of((Currency)currency, (double)(pvStandard + pvDiff)));
    }

    public CurrencyAmount presentValueFromCleanPriceWithZSpread(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider provider, ReferenceData refData, double cleanPrice, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        ResolvedFixedCouponBond product = trade.getProduct();
        LocalDate standardSettlementDate = this.standardSettlementDate(product, provider, refData);
        LocalDate tradeSettlementDate = this.settlementDate(trade, provider.getValuationDate());
        Currency currency = product.getCurrency();
        RepoCurveDiscountFactors repoDf = DiscountingFixedCouponBondProductPricer.repoCurveDf(product, provider);
        double df = repoDf.discountFactor(standardSettlementDate);
        double pvStandard = (cleanPrice * product.getNotional() + this.productPricer.accruedInterest(product, standardSettlementDate)) * df;
        if (standardSettlementDate.isEqual(tradeSettlementDate)) {
            return this.presentValueFromProductPresentValue(trade, provider, CurrencyAmount.of((Currency)currency, (double)pvStandard));
        }
        IssuerCurveDiscountFactors issuerDf = DiscountingFixedCouponBondProductPricer.issuerCurveDf(product, provider);
        double pvDiff = 0.0;
        pvDiff = standardSettlementDate.isAfter(tradeSettlementDate) ? this.productPricer.presentValueCouponWithZSpread(product, issuerDf, tradeSettlementDate, standardSettlementDate, zSpread, compoundedRateType, periodsPerYear) : -this.productPricer.presentValueCouponWithZSpread(product, issuerDf, standardSettlementDate, tradeSettlementDate, zSpread, compoundedRateType, periodsPerYear);
        return this.presentValueFromProductPresentValue(trade, provider, CurrencyAmount.of((Currency)currency, (double)(pvStandard + pvDiff)));
    }

    private LocalDate standardSettlementDate(ResolvedFixedCouponBond product, LegalEntityDiscountingProvider provider, ReferenceData refData) {
        return product.getSettlementDateOffset().adjust(provider.getValuationDate(), refData);
    }

    public PointSensitivities presentValueSensitivity(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider provider) {
        LocalDate settlementDate = this.settlementDate(trade, provider.getValuationDate());
        PointSensitivityBuilder sensiProduct = this.productPricer.presentValueSensitivity(trade.getProduct(), provider, settlementDate);
        return this.presentValueSensitivityFromProductPresentValueSensitivity(trade, provider, sensiProduct).build();
    }

    public PointSensitivities presentValueSensitivityWithZSpread(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider provider, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        LocalDate settlementDate = this.settlementDate(trade, provider.getValuationDate());
        PointSensitivityBuilder sensiProduct = this.productPricer.presentValueSensitivityWithZSpread(trade.getProduct(), provider, zSpread, compoundedRateType, periodsPerYear, settlementDate);
        return this.presentValueSensitivityFromProductPresentValueSensitivity(trade, provider, sensiProduct).build();
    }

    private PointSensitivityBuilder presentValueSensitivityFromProductPresentValueSensitivity(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider provider, PointSensitivityBuilder productPresnetValueSensitivity) {
        PointSensitivityBuilder sensiProduct = productPresnetValueSensitivity.multipliedBy(trade.getQuantity());
        PointSensitivityBuilder sensiPayment = this.presentValueSensitivityPayment(trade, provider);
        return sensiProduct.combinedWith(sensiPayment);
    }

    public MultiCurrencyAmount currencyExposure(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider provider) {
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{this.presentValue(trade, provider)});
    }

    public MultiCurrencyAmount currencyExposureWithZSpread(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider provider, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{this.presentValueWithZSpread(trade, provider, zSpread, compoundedRateType, periodsPerYear)});
    }

    public CurrencyAmount currentCash(ResolvedFixedCouponBondTrade trade, LocalDate valuationDate) {
        Payment upfrontPayment = this.upfrontPayment(trade);
        Currency currency = upfrontPayment.getCurrency();
        CurrencyAmount currentCash = CurrencyAmount.zero((Currency)currency);
        if (upfrontPayment.getDate().equals(valuationDate)) {
            currentCash = currentCash.plus(upfrontPayment.getValue());
        }
        if (trade.getSettlement().isPresent()) {
            LocalDate settlementDate = ((ResolvedFixedCouponBondSettlement)trade.getSettlement().get()).getSettlementDate();
            ResolvedFixedCouponBond product = trade.getProduct();
            if (!settlementDate.isAfter(valuationDate)) {
                double cashCoupon = product.hasExCouponPeriod() ? 0.0 : this.currentCashCouponPayment(product, valuationDate);
                Payment payment = product.getNominalPayment();
                double cashNominal = payment.getDate().isEqual(valuationDate) ? payment.getAmount() : 0.0;
                currentCash = currentCash.plus(CurrencyAmount.of((Currency)currency, (double)((cashCoupon + cashNominal) * trade.getQuantity())));
            }
        }
        return currentCash;
    }

    private double currentCashCouponPayment(ResolvedFixedCouponBond product, LocalDate referenceDate) {
        double cash = 0.0;
        for (FixedCouponBondPaymentPeriod period : product.getPeriodicPayments()) {
            if (!period.getPaymentDate().isEqual(referenceDate)) continue;
            cash += period.getFixedRate() * period.getNotional() * period.getYearFraction();
        }
        return cash;
    }

    private CurrencyAmount presentValuePayment(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider provider) {
        RepoCurveDiscountFactors repoDf = DiscountingFixedCouponBondProductPricer.repoCurveDf(trade.getProduct(), provider);
        Payment upfrontPayment = this.upfrontPayment(trade);
        return this.paymentPricer.presentValue(upfrontPayment, repoDf.getDiscountFactors());
    }

    private PointSensitivityBuilder presentValueSensitivityPayment(ResolvedFixedCouponBondTrade trade, LegalEntityDiscountingProvider provider) {
        RepoCurveDiscountFactors repoDf = DiscountingFixedCouponBondProductPricer.repoCurveDf(trade.getProduct(), provider);
        Payment upfrontPayment = this.upfrontPayment(trade);
        PointSensitivityBuilder pt = this.paymentPricer.presentValueSensitivity(upfrontPayment, repoDf.getDiscountFactors());
        if (pt instanceof ZeroRateSensitivity) {
            return RepoCurveZeroRateSensitivity.of((ZeroRateSensitivity)pt, repoDf.getRepoGroup());
        }
        return pt;
    }

    public Payment upfrontPayment(ResolvedFixedCouponBondTrade trade) {
        ResolvedFixedCouponBond product = trade.getProduct();
        Currency currency = product.getCurrency();
        if (!trade.getSettlement().isPresent()) {
            return Payment.of((CurrencyAmount)CurrencyAmount.zero((Currency)currency), (LocalDate)product.getStartDate());
        }
        ResolvedFixedCouponBondSettlement settlement = (ResolvedFixedCouponBondSettlement)trade.getSettlement().get();
        LocalDate settlementDate = settlement.getSettlementDate();
        double cleanPrice = settlement.getPrice();
        double dirtyPrice = this.productPricer.dirtyPriceFromCleanPrice(product, settlementDate, cleanPrice);
        double quantity = trade.getQuantity();
        double notional = product.getNotional();
        return Payment.of((CurrencyAmount)CurrencyAmount.of((Currency)currency, (double)(-quantity * notional * dirtyPrice)), (LocalDate)settlementDate);
    }

    public LocalDate settlementDate(ResolvedFixedCouponBondTrade trade, LocalDate valuationDate) {
        return trade.getSettlement().map(settle -> settle.getSettlementDate()).orElse(valuationDate);
    }
}

