/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.bond;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.LegalEntityGroup;
import com.opengamma.strata.market.curve.RepoGroup;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.bond.IssuerCurveDiscountFactors;
import com.opengamma.strata.pricer.bond.IssuerCurveZeroRateSensitivity;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.pricer.bond.RepoCurveDiscountFactors;
import com.opengamma.strata.pricer.bond.RepoCurveZeroRateSensitivity;
import com.opengamma.strata.product.LegalEntityId;
import com.opengamma.strata.product.SecurityId;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ImmutableLegalEntityDiscountingProvider
implements LegalEntityDiscountingProvider,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDate valuationDate;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<SecurityId, RepoGroup> repoCurveSecurityGroups;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<LegalEntityId, RepoGroup> repoCurveGroups;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<Pair<RepoGroup, Currency>, DiscountFactors> repoCurves;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<LegalEntityId, LegalEntityGroup> issuerCurveGroups;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<Pair<LegalEntityGroup, Currency>, DiscountFactors> issuerCurves;
    private static final long serialVersionUID = 1L;

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.valuationDate == null && !builder.issuerCurves.isEmpty()) {
            builder.valuationDate = ((DiscountFactors)builder.issuerCurves.values().iterator().next()).getValuationDate();
        }
    }

    @ImmutableValidator
    private void validate() {
        for (Map.Entry entry : this.repoCurves.entrySet()) {
            if (!((DiscountFactors)entry.getValue()).getValuationDate().isEqual(this.valuationDate)) {
                throw new IllegalArgumentException("Invalid valuation date for the repo curve: " + entry.getValue());
            }
            RepoGroup group = (RepoGroup)((Pair)entry.getKey()).getFirst();
            if (this.repoCurveGroups.containsValue((Object)group) || this.repoCurveSecurityGroups.containsValue((Object)group)) continue;
            throw new IllegalArgumentException("No map to the repo group from ID: " + group);
        }
        for (Map.Entry entry : this.issuerCurves.entrySet()) {
            if (!((DiscountFactors)entry.getValue()).getValuationDate().isEqual(this.valuationDate)) {
                throw new IllegalArgumentException("Invalid valuation date for the issuer curve: " + entry.getValue());
            }
            if (this.issuerCurveGroups.containsValue(((Pair)entry.getKey()).getFirst())) continue;
            throw new IllegalArgumentException("No map to the legal entity group from ID: " + ((Pair)entry.getKey()).getFirst());
        }
    }

    @Override
    public RepoCurveDiscountFactors repoCurveDiscountFactors(SecurityId securityId, LegalEntityId issuerId, Currency currency) {
        RepoGroup repoGroup = (RepoGroup)this.repoCurveSecurityGroups.get((Object)securityId);
        if (repoGroup == null && (repoGroup = (RepoGroup)this.repoCurveGroups.get((Object)issuerId)) == null) {
            throw new IllegalArgumentException("Unable to find map for ID: " + securityId + ", " + issuerId);
        }
        return this.repoCurveDiscountFactors(repoGroup, currency);
    }

    @Override
    public RepoCurveDiscountFactors repoCurveDiscountFactors(LegalEntityId issuerId, Currency currency) {
        RepoGroup repoGroup = (RepoGroup)this.repoCurveGroups.get((Object)issuerId);
        if (repoGroup == null) {
            throw new IllegalArgumentException("Unable to find map for ID: " + issuerId);
        }
        return this.repoCurveDiscountFactors(repoGroup, currency);
    }

    private RepoCurveDiscountFactors repoCurveDiscountFactors(RepoGroup repoGroup, Currency currency) {
        DiscountFactors discountFactors = (DiscountFactors)this.repoCurves.get((Object)Pair.of((Object)repoGroup, (Object)currency));
        if (discountFactors == null) {
            throw new IllegalArgumentException("Unable to find repo curve: " + repoGroup + ", " + currency);
        }
        return RepoCurveDiscountFactors.of(discountFactors, repoGroup);
    }

    @Override
    public IssuerCurveDiscountFactors issuerCurveDiscountFactors(LegalEntityId issuerId, Currency currency) {
        LegalEntityGroup legalEntityGroup = (LegalEntityGroup)this.issuerCurveGroups.get((Object)issuerId);
        if (legalEntityGroup == null) {
            throw new IllegalArgumentException("Unable to find map for ID: " + issuerId);
        }
        return this.issuerCurveDiscountFactors(legalEntityGroup, currency);
    }

    private IssuerCurveDiscountFactors issuerCurveDiscountFactors(LegalEntityGroup legalEntityGroup, Currency currency) {
        DiscountFactors discountFactors = (DiscountFactors)this.issuerCurves.get((Object)Pair.of((Object)legalEntityGroup, (Object)currency));
        if (discountFactors == null) {
            throw new IllegalArgumentException("Unable to find issuer curve: " + legalEntityGroup + ", " + currency);
        }
        return IssuerCurveDiscountFactors.of(discountFactors, legalEntityGroup);
    }

    @Override
    public CurrencyParameterSensitivities parameterSensitivity(PointSensitivities pointSensitivities) {
        CurrencyParameterSensitivities sens = CurrencyParameterSensitivities.empty();
        for (PointSensitivity point : pointSensitivities.getSensitivities()) {
            ImmutableBean factors;
            PointSensitivityBuilder pt;
            if (point instanceof RepoCurveZeroRateSensitivity) {
                pt = (RepoCurveZeroRateSensitivity)point;
                factors = this.repoCurveDiscountFactors(pt.getRepoGroup(), pt.getCurveCurrency());
                sens = sens.combinedWith(factors.parameterSensitivity((RepoCurveZeroRateSensitivity)pt));
                continue;
            }
            if (!(point instanceof IssuerCurveZeroRateSensitivity)) continue;
            pt = (IssuerCurveZeroRateSensitivity)point;
            factors = this.issuerCurveDiscountFactors(pt.getLegalEntityGroup(), pt.getCurveCurrency());
            sens = sens.combinedWith(factors.parameterSensitivity((IssuerCurveZeroRateSensitivity)pt));
        }
        return sens;
    }

    @Override
    public <T> T data(MarketDataId<T> id) {
        throw new IllegalArgumentException("Unknown identifier: " + id.toString());
    }

    @Override
    public <T> Optional<T> findData(MarketDataName<T> name) {
        if (name instanceof CurveName) {
            return Stream.concat(this.repoCurves.values().stream(), this.issuerCurves.values().stream()).map(df -> df.findData(name)).filter(opt -> opt.isPresent()).map(opt -> opt.get()).findFirst();
        }
        return Optional.empty();
    }

    @Override
    public ImmutableLegalEntityDiscountingProvider toImmutableLegalEntityDiscountingProvider() {
        return this;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ImmutableLegalEntityDiscountingProvider(LocalDate valuationDate, Map<SecurityId, RepoGroup> repoCurveSecurityGroups, Map<LegalEntityId, RepoGroup> repoCurveGroups, Map<Pair<RepoGroup, Currency>, DiscountFactors> repoCurves, Map<LegalEntityId, LegalEntityGroup> issuerCurveGroups, Map<Pair<LegalEntityGroup, Currency>, DiscountFactors> issuerCurves) {
        JodaBeanUtils.notNull((Object)valuationDate, (String)"valuationDate");
        JodaBeanUtils.notNull(repoCurveSecurityGroups, (String)"repoCurveSecurityGroups");
        JodaBeanUtils.notNull(repoCurveGroups, (String)"repoCurveGroups");
        JodaBeanUtils.notNull(repoCurves, (String)"repoCurves");
        JodaBeanUtils.notNull(issuerCurveGroups, (String)"issuerCurveGroups");
        JodaBeanUtils.notNull(issuerCurves, (String)"issuerCurves");
        this.valuationDate = valuationDate;
        this.repoCurveSecurityGroups = ImmutableMap.copyOf(repoCurveSecurityGroups);
        this.repoCurveGroups = ImmutableMap.copyOf(repoCurveGroups);
        this.repoCurves = ImmutableMap.copyOf(repoCurves);
        this.issuerCurveGroups = ImmutableMap.copyOf(issuerCurveGroups);
        this.issuerCurves = ImmutableMap.copyOf(issuerCurves);
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public LocalDate getValuationDate() {
        return this.valuationDate;
    }

    public ImmutableMap<SecurityId, RepoGroup> getRepoCurveSecurityGroups() {
        return this.repoCurveSecurityGroups;
    }

    public ImmutableMap<LegalEntityId, RepoGroup> getRepoCurveGroups() {
        return this.repoCurveGroups;
    }

    public ImmutableMap<Pair<RepoGroup, Currency>, DiscountFactors> getRepoCurves() {
        return this.repoCurves;
    }

    public ImmutableMap<LegalEntityId, LegalEntityGroup> getIssuerCurveGroups() {
        return this.issuerCurveGroups;
    }

    public ImmutableMap<Pair<LegalEntityGroup, Currency>, DiscountFactors> getIssuerCurves() {
        return this.issuerCurves;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ImmutableLegalEntityDiscountingProvider other = (ImmutableLegalEntityDiscountingProvider)obj;
            return JodaBeanUtils.equal((Object)this.valuationDate, (Object)other.valuationDate) && JodaBeanUtils.equal(this.repoCurveSecurityGroups, other.repoCurveSecurityGroups) && JodaBeanUtils.equal(this.repoCurveGroups, other.repoCurveGroups) && JodaBeanUtils.equal(this.repoCurves, other.repoCurves) && JodaBeanUtils.equal(this.issuerCurveGroups, other.issuerCurveGroups) && JodaBeanUtils.equal(this.issuerCurves, other.issuerCurves);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.valuationDate);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.repoCurveSecurityGroups);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.repoCurveGroups);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.repoCurves);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.issuerCurveGroups);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.issuerCurves);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(224);
        buf.append("ImmutableLegalEntityDiscountingProvider{");
        buf.append("valuationDate").append('=').append(JodaBeanUtils.toString((Object)this.valuationDate)).append(',').append(' ');
        buf.append("repoCurveSecurityGroups").append('=').append(JodaBeanUtils.toString(this.repoCurveSecurityGroups)).append(',').append(' ');
        buf.append("repoCurveGroups").append('=').append(JodaBeanUtils.toString(this.repoCurveGroups)).append(',').append(' ');
        buf.append("repoCurves").append('=').append(JodaBeanUtils.toString(this.repoCurves)).append(',').append(' ');
        buf.append("issuerCurveGroups").append('=').append(JodaBeanUtils.toString(this.issuerCurveGroups)).append(',').append(' ');
        buf.append("issuerCurves").append('=').append(JodaBeanUtils.toString(this.issuerCurves));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ImmutableLegalEntityDiscountingProvider> {
        private LocalDate valuationDate;
        private Map<SecurityId, RepoGroup> repoCurveSecurityGroups = ImmutableMap.of();
        private Map<LegalEntityId, RepoGroup> repoCurveGroups = ImmutableMap.of();
        private Map<Pair<RepoGroup, Currency>, DiscountFactors> repoCurves = ImmutableMap.of();
        private Map<LegalEntityId, LegalEntityGroup> issuerCurveGroups = ImmutableMap.of();
        private Map<Pair<LegalEntityGroup, Currency>, DiscountFactors> issuerCurves = ImmutableMap.of();

        private Builder() {
        }

        private Builder(ImmutableLegalEntityDiscountingProvider beanToCopy) {
            this.valuationDate = beanToCopy.getValuationDate();
            this.repoCurveSecurityGroups = beanToCopy.getRepoCurveSecurityGroups();
            this.repoCurveGroups = beanToCopy.getRepoCurveGroups();
            this.repoCurves = beanToCopy.getRepoCurves();
            this.issuerCurveGroups = beanToCopy.getIssuerCurveGroups();
            this.issuerCurves = beanToCopy.getIssuerCurves();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 113107279: {
                    return this.valuationDate;
                }
                case -1749299407: {
                    return this.repoCurveSecurityGroups;
                }
                case -1279842095: {
                    return this.repoCurveGroups;
                }
                case 587630454: {
                    return this.repoCurves;
                }
                case 1830129450: {
                    return this.issuerCurveGroups;
                }
                case -1909076611: {
                    return this.issuerCurves;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 113107279: {
                    this.valuationDate = (LocalDate)newValue;
                    break;
                }
                case -1749299407: {
                    this.repoCurveSecurityGroups = (Map)newValue;
                    break;
                }
                case -1279842095: {
                    this.repoCurveGroups = (Map)newValue;
                    break;
                }
                case 587630454: {
                    this.repoCurves = (Map)newValue;
                    break;
                }
                case 1830129450: {
                    this.issuerCurveGroups = (Map)newValue;
                    break;
                }
                case -1909076611: {
                    this.issuerCurves = (Map)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ImmutableLegalEntityDiscountingProvider build() {
            ImmutableLegalEntityDiscountingProvider.preBuild(this);
            return new ImmutableLegalEntityDiscountingProvider(this.valuationDate, this.repoCurveSecurityGroups, this.repoCurveGroups, this.repoCurves, this.issuerCurveGroups, this.issuerCurves);
        }

        public Builder valuationDate(LocalDate valuationDate) {
            JodaBeanUtils.notNull((Object)valuationDate, (String)"valuationDate");
            this.valuationDate = valuationDate;
            return this;
        }

        public Builder repoCurveSecurityGroups(Map<SecurityId, RepoGroup> repoCurveSecurityGroups) {
            JodaBeanUtils.notNull(repoCurveSecurityGroups, (String)"repoCurveSecurityGroups");
            this.repoCurveSecurityGroups = repoCurveSecurityGroups;
            return this;
        }

        public Builder repoCurveGroups(Map<LegalEntityId, RepoGroup> repoCurveGroups) {
            JodaBeanUtils.notNull(repoCurveGroups, (String)"repoCurveGroups");
            this.repoCurveGroups = repoCurveGroups;
            return this;
        }

        public Builder repoCurves(Map<Pair<RepoGroup, Currency>, DiscountFactors> repoCurves) {
            JodaBeanUtils.notNull(repoCurves, (String)"repoCurves");
            this.repoCurves = repoCurves;
            return this;
        }

        public Builder issuerCurveGroups(Map<LegalEntityId, LegalEntityGroup> issuerCurveGroups) {
            JodaBeanUtils.notNull(issuerCurveGroups, (String)"issuerCurveGroups");
            this.issuerCurveGroups = issuerCurveGroups;
            return this;
        }

        public Builder issuerCurves(Map<Pair<LegalEntityGroup, Currency>, DiscountFactors> issuerCurves) {
            JodaBeanUtils.notNull(issuerCurves, (String)"issuerCurves");
            this.issuerCurves = issuerCurves;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(224);
            buf.append("ImmutableLegalEntityDiscountingProvider.Builder{");
            buf.append("valuationDate").append('=').append(JodaBeanUtils.toString((Object)this.valuationDate)).append(',').append(' ');
            buf.append("repoCurveSecurityGroups").append('=').append(JodaBeanUtils.toString(this.repoCurveSecurityGroups)).append(',').append(' ');
            buf.append("repoCurveGroups").append('=').append(JodaBeanUtils.toString(this.repoCurveGroups)).append(',').append(' ');
            buf.append("repoCurves").append('=').append(JodaBeanUtils.toString(this.repoCurves)).append(',').append(' ');
            buf.append("issuerCurveGroups").append('=').append(JodaBeanUtils.toString(this.issuerCurveGroups)).append(',').append(' ');
            buf.append("issuerCurves").append('=').append(JodaBeanUtils.toString(this.issuerCurves));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<LocalDate> valuationDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valuationDate", ImmutableLegalEntityDiscountingProvider.class, LocalDate.class);
        private final MetaProperty<ImmutableMap<SecurityId, RepoGroup>> repoCurveSecurityGroups = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"repoCurveSecurityGroups", ImmutableLegalEntityDiscountingProvider.class, ImmutableMap.class);
        private final MetaProperty<ImmutableMap<LegalEntityId, RepoGroup>> repoCurveGroups = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"repoCurveGroups", ImmutableLegalEntityDiscountingProvider.class, ImmutableMap.class);
        private final MetaProperty<ImmutableMap<Pair<RepoGroup, Currency>, DiscountFactors>> repoCurves = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"repoCurves", ImmutableLegalEntityDiscountingProvider.class, ImmutableMap.class);
        private final MetaProperty<ImmutableMap<LegalEntityId, LegalEntityGroup>> issuerCurveGroups = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"issuerCurveGroups", ImmutableLegalEntityDiscountingProvider.class, ImmutableMap.class);
        private final MetaProperty<ImmutableMap<Pair<LegalEntityGroup, Currency>, DiscountFactors>> issuerCurves = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"issuerCurves", ImmutableLegalEntityDiscountingProvider.class, ImmutableMap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"valuationDate", "repoCurveSecurityGroups", "repoCurveGroups", "repoCurves", "issuerCurveGroups", "issuerCurves"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 113107279: {
                    return this.valuationDate;
                }
                case -1749299407: {
                    return this.repoCurveSecurityGroups;
                }
                case -1279842095: {
                    return this.repoCurveGroups;
                }
                case 587630454: {
                    return this.repoCurves;
                }
                case 1830129450: {
                    return this.issuerCurveGroups;
                }
                case -1909076611: {
                    return this.issuerCurves;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ImmutableLegalEntityDiscountingProvider> beanType() {
            return ImmutableLegalEntityDiscountingProvider.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<LocalDate> valuationDate() {
            return this.valuationDate;
        }

        public MetaProperty<ImmutableMap<SecurityId, RepoGroup>> repoCurveSecurityGroups() {
            return this.repoCurveSecurityGroups;
        }

        public MetaProperty<ImmutableMap<LegalEntityId, RepoGroup>> repoCurveGroups() {
            return this.repoCurveGroups;
        }

        public MetaProperty<ImmutableMap<Pair<RepoGroup, Currency>, DiscountFactors>> repoCurves() {
            return this.repoCurves;
        }

        public MetaProperty<ImmutableMap<LegalEntityId, LegalEntityGroup>> issuerCurveGroups() {
            return this.issuerCurveGroups;
        }

        public MetaProperty<ImmutableMap<Pair<LegalEntityGroup, Currency>, DiscountFactors>> issuerCurves() {
            return this.issuerCurves;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 113107279: {
                    return ((ImmutableLegalEntityDiscountingProvider)bean).getValuationDate();
                }
                case -1749299407: {
                    return ((ImmutableLegalEntityDiscountingProvider)bean).getRepoCurveSecurityGroups();
                }
                case -1279842095: {
                    return ((ImmutableLegalEntityDiscountingProvider)bean).getRepoCurveGroups();
                }
                case 587630454: {
                    return ((ImmutableLegalEntityDiscountingProvider)bean).getRepoCurves();
                }
                case 1830129450: {
                    return ((ImmutableLegalEntityDiscountingProvider)bean).getIssuerCurveGroups();
                }
                case -1909076611: {
                    return ((ImmutableLegalEntityDiscountingProvider)bean).getIssuerCurves();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

