/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.bond;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.market.curve.LegalEntityGroup;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.bond.IssuerCurveZeroRateSensitivity;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class IssuerCurveDiscountFactors
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final DiscountFactors discountFactors;
    @PropertyDefinition(validate="notNull")
    private final LegalEntityGroup legalEntityGroup;
    private static final long serialVersionUID = 1L;

    public static IssuerCurveDiscountFactors of(DiscountFactors discountFactors, LegalEntityGroup legalEntityGroup) {
        return new IssuerCurveDiscountFactors(discountFactors, legalEntityGroup);
    }

    public Currency getCurrency() {
        return this.discountFactors.getCurrency();
    }

    public LocalDate getValuationDate() {
        return this.discountFactors.getValuationDate();
    }

    public double discountFactor(LocalDate date) {
        return this.discountFactors.discountFactor(date);
    }

    public IssuerCurveZeroRateSensitivity zeroRatePointSensitivity(LocalDate date) {
        return this.zeroRatePointSensitivity(date, this.getCurrency());
    }

    public IssuerCurveZeroRateSensitivity zeroRatePointSensitivity(LocalDate date, Currency sensitivityCurrency) {
        ZeroRateSensitivity zeroRateSensitivity = this.discountFactors.zeroRatePointSensitivity(date, sensitivityCurrency);
        return IssuerCurveZeroRateSensitivity.of(zeroRateSensitivity, this.legalEntityGroup);
    }

    public CurrencyParameterSensitivities parameterSensitivity(IssuerCurveZeroRateSensitivity pointSensitivity) {
        return this.discountFactors.parameterSensitivity(pointSensitivity.createZeroRateSensitivity());
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private IssuerCurveDiscountFactors(DiscountFactors discountFactors, LegalEntityGroup legalEntityGroup) {
        JodaBeanUtils.notNull((Object)discountFactors, (String)"discountFactors");
        JodaBeanUtils.notNull((Object)legalEntityGroup, (String)"legalEntityGroup");
        this.discountFactors = discountFactors;
        this.legalEntityGroup = legalEntityGroup;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public DiscountFactors getDiscountFactors() {
        return this.discountFactors;
    }

    public LegalEntityGroup getLegalEntityGroup() {
        return this.legalEntityGroup;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IssuerCurveDiscountFactors other = (IssuerCurveDiscountFactors)obj;
            return JodaBeanUtils.equal((Object)this.discountFactors, (Object)other.discountFactors) && JodaBeanUtils.equal((Object)this.legalEntityGroup, (Object)other.legalEntityGroup);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.discountFactors);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.legalEntityGroup);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("IssuerCurveDiscountFactors{");
        buf.append("discountFactors").append('=').append(JodaBeanUtils.toString((Object)this.discountFactors)).append(',').append(' ');
        buf.append("legalEntityGroup").append('=').append(JodaBeanUtils.toString((Object)this.legalEntityGroup));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<IssuerCurveDiscountFactors> {
        private DiscountFactors discountFactors;
        private LegalEntityGroup legalEntityGroup;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -91613053: {
                    return this.discountFactors;
                }
                case -899047453: {
                    return this.legalEntityGroup;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -91613053: {
                    this.discountFactors = (DiscountFactors)newValue;
                    break;
                }
                case -899047453: {
                    this.legalEntityGroup = (LegalEntityGroup)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public IssuerCurveDiscountFactors build() {
            return new IssuerCurveDiscountFactors(this.discountFactors, this.legalEntityGroup);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("IssuerCurveDiscountFactors.Builder{");
            buf.append("discountFactors").append('=').append(JodaBeanUtils.toString((Object)this.discountFactors)).append(',').append(' ');
            buf.append("legalEntityGroup").append('=').append(JodaBeanUtils.toString((Object)this.legalEntityGroup));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<DiscountFactors> discountFactors = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"discountFactors", IssuerCurveDiscountFactors.class, DiscountFactors.class);
        private final MetaProperty<LegalEntityGroup> legalEntityGroup = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"legalEntityGroup", IssuerCurveDiscountFactors.class, LegalEntityGroup.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"discountFactors", "legalEntityGroup"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -91613053: {
                    return this.discountFactors;
                }
                case -899047453: {
                    return this.legalEntityGroup;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends IssuerCurveDiscountFactors> builder() {
            return new Builder();
        }

        public Class<? extends IssuerCurveDiscountFactors> beanType() {
            return IssuerCurveDiscountFactors.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<DiscountFactors> discountFactors() {
            return this.discountFactors;
        }

        public MetaProperty<LegalEntityGroup> legalEntityGroup() {
            return this.legalEntityGroup;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -91613053: {
                    return ((IssuerCurveDiscountFactors)bean).getDiscountFactors();
                }
                case -899047453: {
                    return ((IssuerCurveDiscountFactors)bean).getLegalEntityGroup();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

