/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.bond;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.bond.ImmutableLegalEntityDiscountingProvider;
import com.opengamma.strata.pricer.bond.IssuerCurveDiscountFactors;
import com.opengamma.strata.pricer.bond.RepoCurveDiscountFactors;
import com.opengamma.strata.product.LegalEntityId;
import com.opengamma.strata.product.SecurityId;
import java.time.LocalDate;
import java.util.Optional;

public interface LegalEntityDiscountingProvider {
    public LocalDate getValuationDate();

    public RepoCurveDiscountFactors repoCurveDiscountFactors(SecurityId var1, LegalEntityId var2, Currency var3);

    public RepoCurveDiscountFactors repoCurveDiscountFactors(LegalEntityId var1, Currency var2);

    public IssuerCurveDiscountFactors issuerCurveDiscountFactors(LegalEntityId var1, Currency var2);

    public CurrencyParameterSensitivities parameterSensitivity(PointSensitivities var1);

    public <T> T data(MarketDataId<T> var1);

    public <T> Optional<T> findData(MarketDataName<T> var1);

    public ImmutableLegalEntityDiscountingProvider toImmutableLegalEntityDiscountingProvider();
}

