/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.bond;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.market.curve.RepoGroup;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.bond.RepoCurveZeroRateSensitivity;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class RepoCurveDiscountFactors
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final DiscountFactors discountFactors;
    @PropertyDefinition(validate="notNull")
    private final RepoGroup repoGroup;
    private static final long serialVersionUID = 1L;

    public static RepoCurveDiscountFactors of(DiscountFactors discountFactors, RepoGroup group) {
        return new RepoCurveDiscountFactors(discountFactors, group);
    }

    public Currency getCurrency() {
        return this.discountFactors.getCurrency();
    }

    public LocalDate getValuationDate() {
        return this.discountFactors.getValuationDate();
    }

    public double discountFactor(LocalDate date) {
        return this.discountFactors.discountFactor(date);
    }

    public RepoCurveZeroRateSensitivity zeroRatePointSensitivity(LocalDate date) {
        return this.zeroRatePointSensitivity(date, this.getCurrency());
    }

    public RepoCurveZeroRateSensitivity zeroRatePointSensitivity(LocalDate date, Currency sensitivityCurrency) {
        ZeroRateSensitivity zeroRateSensitivity = this.discountFactors.zeroRatePointSensitivity(date, sensitivityCurrency);
        return RepoCurveZeroRateSensitivity.of(zeroRateSensitivity, this.repoGroup);
    }

    public CurrencyParameterSensitivities parameterSensitivity(RepoCurveZeroRateSensitivity pointSensitivity) {
        return this.discountFactors.parameterSensitivity(pointSensitivity.createZeroRateSensitivity());
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private RepoCurveDiscountFactors(DiscountFactors discountFactors, RepoGroup repoGroup) {
        JodaBeanUtils.notNull((Object)discountFactors, (String)"discountFactors");
        JodaBeanUtils.notNull((Object)repoGroup, (String)"repoGroup");
        this.discountFactors = discountFactors;
        this.repoGroup = repoGroup;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public DiscountFactors getDiscountFactors() {
        return this.discountFactors;
    }

    public RepoGroup getRepoGroup() {
        return this.repoGroup;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            RepoCurveDiscountFactors other = (RepoCurveDiscountFactors)obj;
            return JodaBeanUtils.equal((Object)this.discountFactors, (Object)other.discountFactors) && JodaBeanUtils.equal((Object)this.repoGroup, (Object)other.repoGroup);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.discountFactors);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.repoGroup);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("RepoCurveDiscountFactors{");
        buf.append("discountFactors").append('=').append(JodaBeanUtils.toString((Object)this.discountFactors)).append(',').append(' ');
        buf.append("repoGroup").append('=').append(JodaBeanUtils.toString((Object)this.repoGroup));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<RepoCurveDiscountFactors> {
        private DiscountFactors discountFactors;
        private RepoGroup repoGroup;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -91613053: {
                    return this.discountFactors;
                }
                case -393084371: {
                    return this.repoGroup;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -91613053: {
                    this.discountFactors = (DiscountFactors)newValue;
                    break;
                }
                case -393084371: {
                    this.repoGroup = (RepoGroup)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public RepoCurveDiscountFactors build() {
            return new RepoCurveDiscountFactors(this.discountFactors, this.repoGroup);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("RepoCurveDiscountFactors.Builder{");
            buf.append("discountFactors").append('=').append(JodaBeanUtils.toString((Object)this.discountFactors)).append(',').append(' ');
            buf.append("repoGroup").append('=').append(JodaBeanUtils.toString((Object)this.repoGroup));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<DiscountFactors> discountFactors = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"discountFactors", RepoCurveDiscountFactors.class, DiscountFactors.class);
        private final MetaProperty<RepoGroup> repoGroup = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"repoGroup", RepoCurveDiscountFactors.class, RepoGroup.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"discountFactors", "repoGroup"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -91613053: {
                    return this.discountFactors;
                }
                case -393084371: {
                    return this.repoGroup;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends RepoCurveDiscountFactors> builder() {
            return new Builder();
        }

        public Class<? extends RepoCurveDiscountFactors> beanType() {
            return RepoCurveDiscountFactors.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<DiscountFactors> discountFactors() {
            return this.discountFactors;
        }

        public MetaProperty<RepoGroup> repoGroup() {
            return this.repoGroup;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -91613053: {
                    return ((RepoCurveDiscountFactors)bean).getDiscountFactors();
                }
                case -393084371: {
                    return ((RepoCurveDiscountFactors)bean).getRepoGroup();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

