/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.bond;

import com.google.common.collect.ComparisonChain;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.market.curve.RepoGroup;
import com.opengamma.strata.market.sensitivity.MutablePointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.DoubleUnaryOperator;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class RepoCurveZeroRateSensitivity
implements PointSensitivity,
PointSensitivityBuilder,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Currency curveCurrency;
    @PropertyDefinition
    private final double yearFraction;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    @PropertyDefinition(validate="notNull")
    private final RepoGroup repoGroup;
    @PropertyDefinition(overrideGet=true)
    private final double sensitivity;
    private static final long serialVersionUID = 1L;

    public static RepoCurveZeroRateSensitivity of(Currency currency, double yearFraction, RepoGroup repoGroup, double sensitivity) {
        return RepoCurveZeroRateSensitivity.of(currency, yearFraction, currency, repoGroup, sensitivity);
    }

    public static RepoCurveZeroRateSensitivity of(ZeroRateSensitivity zeroRateSensitivity, RepoGroup repoGroup) {
        return RepoCurveZeroRateSensitivity.of(zeroRateSensitivity.getCurveCurrency(), zeroRateSensitivity.getYearFraction(), zeroRateSensitivity.getCurrency(), repoGroup, zeroRateSensitivity.getSensitivity());
    }

    public static RepoCurveZeroRateSensitivity of(Currency curveCurrency, double yearFraction, Currency sensitivityCurrency, RepoGroup repoGroup, double sensitivity) {
        return new RepoCurveZeroRateSensitivity(curveCurrency, yearFraction, sensitivityCurrency, repoGroup, sensitivity);
    }

    public RepoCurveZeroRateSensitivity withCurrency(Currency currency) {
        if (this.currency.equals((Object)currency)) {
            return this;
        }
        return new RepoCurveZeroRateSensitivity(this.curveCurrency, this.yearFraction, currency, this.repoGroup, this.sensitivity);
    }

    public RepoCurveZeroRateSensitivity withSensitivity(double sensitivity) {
        return new RepoCurveZeroRateSensitivity(this.curveCurrency, this.yearFraction, this.currency, this.repoGroup, sensitivity);
    }

    public int compareKey(PointSensitivity other) {
        if (other instanceof RepoCurveZeroRateSensitivity) {
            RepoCurveZeroRateSensitivity otherZero = (RepoCurveZeroRateSensitivity)other;
            return ComparisonChain.start().compare((Comparable)this.curveCurrency, (Comparable)otherZero.curveCurrency).compare((Comparable)this.currency, (Comparable)otherZero.currency).compare(this.yearFraction, otherZero.yearFraction).compare((Comparable)this.repoGroup, (Comparable)otherZero.repoGroup).result();
        }
        return this.getClass().getSimpleName().compareTo(other.getClass().getSimpleName());
    }

    public RepoCurveZeroRateSensitivity convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        return (RepoCurveZeroRateSensitivity)super.convertedTo(resultCurrency, rateProvider);
    }

    public RepoCurveZeroRateSensitivity multipliedBy(double factor) {
        return new RepoCurveZeroRateSensitivity(this.curveCurrency, this.yearFraction, this.currency, this.repoGroup, this.sensitivity * factor);
    }

    public RepoCurveZeroRateSensitivity mapSensitivity(DoubleUnaryOperator operator) {
        return new RepoCurveZeroRateSensitivity(this.curveCurrency, this.yearFraction, this.currency, this.repoGroup, operator.applyAsDouble(this.sensitivity));
    }

    public RepoCurveZeroRateSensitivity normalize() {
        return this;
    }

    public MutablePointSensitivities buildInto(MutablePointSensitivities combination) {
        return combination.add((PointSensitivity)this);
    }

    public RepoCurveZeroRateSensitivity cloned() {
        return this;
    }

    public ZeroRateSensitivity createZeroRateSensitivity() {
        return ZeroRateSensitivity.of(this.curveCurrency, this.yearFraction, this.currency, this.sensitivity);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private RepoCurveZeroRateSensitivity(Currency curveCurrency, double yearFraction, Currency currency, RepoGroup repoGroup, double sensitivity) {
        JodaBeanUtils.notNull((Object)curveCurrency, (String)"curveCurrency");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        JodaBeanUtils.notNull((Object)repoGroup, (String)"repoGroup");
        this.curveCurrency = curveCurrency;
        this.yearFraction = yearFraction;
        this.currency = currency;
        this.repoGroup = repoGroup;
        this.sensitivity = sensitivity;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Currency getCurveCurrency() {
        return this.curveCurrency;
    }

    public double getYearFraction() {
        return this.yearFraction;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public RepoGroup getRepoGroup() {
        return this.repoGroup;
    }

    public double getSensitivity() {
        return this.sensitivity;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            RepoCurveZeroRateSensitivity other = (RepoCurveZeroRateSensitivity)obj;
            return JodaBeanUtils.equal((Object)this.curveCurrency, (Object)other.curveCurrency) && JodaBeanUtils.equal((double)this.yearFraction, (double)other.yearFraction) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((Object)this.repoGroup, (Object)other.repoGroup) && JodaBeanUtils.equal((double)this.sensitivity, (double)other.sensitivity);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.curveCurrency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.yearFraction);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.repoGroup);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.sensitivity);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("RepoCurveZeroRateSensitivity{");
        buf.append("curveCurrency").append('=').append(JodaBeanUtils.toString((Object)this.curveCurrency)).append(',').append(' ');
        buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("repoGroup").append('=').append(JodaBeanUtils.toString((Object)this.repoGroup)).append(',').append(' ');
        buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<RepoCurveZeroRateSensitivity> {
        private Currency curveCurrency;
        private double yearFraction;
        private Currency currency;
        private RepoGroup repoGroup;
        private double sensitivity;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1303639584: {
                    return this.curveCurrency;
                }
                case -1731780257: {
                    return this.yearFraction;
                }
                case 575402001: {
                    return this.currency;
                }
                case -393084371: {
                    return this.repoGroup;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1303639584: {
                    this.curveCurrency = (Currency)newValue;
                    break;
                }
                case -1731780257: {
                    this.yearFraction = (Double)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case -393084371: {
                    this.repoGroup = (RepoGroup)newValue;
                    break;
                }
                case 564403871: {
                    this.sensitivity = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public RepoCurveZeroRateSensitivity build() {
            return new RepoCurveZeroRateSensitivity(this.curveCurrency, this.yearFraction, this.currency, this.repoGroup, this.sensitivity);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("RepoCurveZeroRateSensitivity.Builder{");
            buf.append("curveCurrency").append('=').append(JodaBeanUtils.toString((Object)this.curveCurrency)).append(',').append(' ');
            buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("repoGroup").append('=').append(JodaBeanUtils.toString((Object)this.repoGroup)).append(',').append(' ');
            buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Currency> curveCurrency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"curveCurrency", RepoCurveZeroRateSensitivity.class, Currency.class);
        private final MetaProperty<Double> yearFraction = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yearFraction", RepoCurveZeroRateSensitivity.class, Double.TYPE);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", RepoCurveZeroRateSensitivity.class, Currency.class);
        private final MetaProperty<RepoGroup> repoGroup = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"repoGroup", RepoCurveZeroRateSensitivity.class, RepoGroup.class);
        private final MetaProperty<Double> sensitivity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sensitivity", RepoCurveZeroRateSensitivity.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"curveCurrency", "yearFraction", "currency", "repoGroup", "sensitivity"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1303639584: {
                    return this.curveCurrency;
                }
                case -1731780257: {
                    return this.yearFraction;
                }
                case 575402001: {
                    return this.currency;
                }
                case -393084371: {
                    return this.repoGroup;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends RepoCurveZeroRateSensitivity> builder() {
            return new Builder();
        }

        public Class<? extends RepoCurveZeroRateSensitivity> beanType() {
            return RepoCurveZeroRateSensitivity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Currency> curveCurrency() {
            return this.curveCurrency;
        }

        public MetaProperty<Double> yearFraction() {
            return this.yearFraction;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<RepoGroup> repoGroup() {
            return this.repoGroup;
        }

        public MetaProperty<Double> sensitivity() {
            return this.sensitivity;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1303639584: {
                    return ((RepoCurveZeroRateSensitivity)bean).getCurveCurrency();
                }
                case -1731780257: {
                    return ((RepoCurveZeroRateSensitivity)bean).getYearFraction();
                }
                case 575402001: {
                    return ((RepoCurveZeroRateSensitivity)bean).getCurrency();
                }
                case -393084371: {
                    return ((RepoCurveZeroRateSensitivity)bean).getRepoGroup();
                }
                case 564403871: {
                    return ((RepoCurveZeroRateSensitivity)bean).getSensitivity();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

