/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.surface.SurfaceMetadata;
import com.opengamma.strata.market.surface.Surfaces;
import com.opengamma.strata.market.surface.interpolator.GridSurfaceInterpolator;
import com.opengamma.strata.math.impl.interpolation.PenaltyMatrixGenerator;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilitiesName;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilityDefinition;
import com.opengamma.strata.pricer.option.RawOptionData;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class DirectIborCapletFloorletVolatilityDefinition
implements IborCapletFloorletVolatilityDefinition,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborCapletFloorletVolatilitiesName name;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborIndex index;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DayCount dayCount;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final double lambdaExpiry;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final double lambdaStrike;
    @PropertyDefinition(validate="notNull")
    private final GridSurfaceInterpolator interpolator;
    @PropertyDefinition(get="optional")
    private final Curve shiftCurve;
    private static final long serialVersionUID = 1L;

    public static DirectIborCapletFloorletVolatilityDefinition of(IborCapletFloorletVolatilitiesName name, IborIndex index, DayCount dayCount, double lambdaExpiry, double lambdaStrike, GridSurfaceInterpolator interpolator) {
        return new DirectIborCapletFloorletVolatilityDefinition(name, index, dayCount, lambdaExpiry, lambdaStrike, interpolator, null);
    }

    public static DirectIborCapletFloorletVolatilityDefinition of(IborCapletFloorletVolatilitiesName name, IborIndex index, DayCount dayCount, double lambdaExpiry, double lambdaStrike, GridSurfaceInterpolator interpolator, Curve shiftCurve) {
        return new DirectIborCapletFloorletVolatilityDefinition(name, index, dayCount, lambdaExpiry, lambdaStrike, interpolator, shiftCurve);
    }

    @Override
    public SurfaceMetadata createMetadata(RawOptionData capFloorData) {
        SurfaceMetadata metadata;
        if (capFloorData.getDataType().equals((Object)ValueType.BLACK_VOLATILITY)) {
            metadata = Surfaces.blackVolatilityByExpiryStrike((String)this.name.getName(), (DayCount)this.dayCount);
        } else if (capFloorData.getDataType().equals((Object)ValueType.NORMAL_VOLATILITY)) {
            metadata = Surfaces.normalVolatilityByExpiryStrike((String)this.name.getName(), (DayCount)this.dayCount);
        } else {
            throw new IllegalArgumentException("Data type not supported");
        }
        return metadata;
    }

    public DoubleMatrix computePenaltyMatrix(DoubleArray strikes, DoubleArray expiries) {
        ArgChecker.isTrue((strikes.size() > 2 ? 1 : 0) != 0, (String)"Need at least 3 points for a curvature estimate");
        ArgChecker.isTrue((expiries.size() > 2 ? 1 : 0) != 0, (String)"Need at least 3 points for a curvature estimate");
        return PenaltyMatrixGenerator.getPenaltyMatrix((double[][])new double[][]{expiries.toArray(), strikes.toArray()}, (int[])new int[]{2, 2}, (double[])new double[]{this.lambdaExpiry, this.lambdaStrike});
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private DirectIborCapletFloorletVolatilityDefinition(IborCapletFloorletVolatilitiesName name, IborIndex index, DayCount dayCount, double lambdaExpiry, double lambdaStrike, GridSurfaceInterpolator interpolator, Curve shiftCurve) {
        JodaBeanUtils.notNull((Object)name, (String)"name");
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        ArgChecker.notNegative((double)lambdaExpiry, (String)"lambdaExpiry");
        ArgChecker.notNegative((double)lambdaStrike, (String)"lambdaStrike");
        JodaBeanUtils.notNull((Object)interpolator, (String)"interpolator");
        this.name = name;
        this.index = index;
        this.dayCount = dayCount;
        this.lambdaExpiry = lambdaExpiry;
        this.lambdaStrike = lambdaStrike;
        this.interpolator = interpolator;
        this.shiftCurve = shiftCurve;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public IborCapletFloorletVolatilitiesName getName() {
        return this.name;
    }

    @Override
    public IborIndex getIndex() {
        return this.index;
    }

    @Override
    public DayCount getDayCount() {
        return this.dayCount;
    }

    public double getLambdaExpiry() {
        return this.lambdaExpiry;
    }

    public double getLambdaStrike() {
        return this.lambdaStrike;
    }

    public GridSurfaceInterpolator getInterpolator() {
        return this.interpolator;
    }

    public Optional<Curve> getShiftCurve() {
        return Optional.ofNullable(this.shiftCurve);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DirectIborCapletFloorletVolatilityDefinition other = (DirectIborCapletFloorletVolatilityDefinition)obj;
            return JodaBeanUtils.equal((Object)this.name, (Object)other.name) && JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((double)this.lambdaExpiry, (double)other.lambdaExpiry) && JodaBeanUtils.equal((double)this.lambdaStrike, (double)other.lambdaStrike) && JodaBeanUtils.equal((Object)this.interpolator, (Object)other.interpolator) && JodaBeanUtils.equal((Object)this.shiftCurve, (Object)other.shiftCurve);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.lambdaExpiry);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.lambdaStrike);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.interpolator);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.shiftCurve);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("DirectIborCapletFloorletVolatilityDefinition{");
        buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("lambdaExpiry").append('=').append(JodaBeanUtils.toString((Object)this.lambdaExpiry)).append(',').append(' ');
        buf.append("lambdaStrike").append('=').append(JodaBeanUtils.toString((Object)this.lambdaStrike)).append(',').append(' ');
        buf.append("interpolator").append('=').append(JodaBeanUtils.toString((Object)this.interpolator)).append(',').append(' ');
        buf.append("shiftCurve").append('=').append(JodaBeanUtils.toString((Object)this.shiftCurve));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<DirectIborCapletFloorletVolatilityDefinition> {
        private IborCapletFloorletVolatilitiesName name;
        private IborIndex index;
        private DayCount dayCount;
        private double lambdaExpiry;
        private double lambdaStrike;
        private GridSurfaceInterpolator interpolator;
        private Curve shiftCurve;

        private Builder() {
        }

        private Builder(DirectIborCapletFloorletVolatilityDefinition beanToCopy) {
            this.name = beanToCopy.getName();
            this.index = beanToCopy.getIndex();
            this.dayCount = beanToCopy.getDayCount();
            this.lambdaExpiry = beanToCopy.getLambdaExpiry();
            this.lambdaStrike = beanToCopy.getLambdaStrike();
            this.interpolator = beanToCopy.getInterpolator();
            this.shiftCurve = beanToCopy.shiftCurve;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 100346066: {
                    return this.index;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -1966011430: {
                    return this.lambdaExpiry;
                }
                case -1568838055: {
                    return this.lambdaStrike;
                }
                case 2096253127: {
                    return this.interpolator;
                }
                case 1908090253: {
                    return this.shiftCurve;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (IborCapletFloorletVolatilitiesName)newValue;
                    break;
                }
                case 100346066: {
                    this.index = (IborIndex)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case -1966011430: {
                    this.lambdaExpiry = (Double)newValue;
                    break;
                }
                case -1568838055: {
                    this.lambdaStrike = (Double)newValue;
                    break;
                }
                case 2096253127: {
                    this.interpolator = (GridSurfaceInterpolator)newValue;
                    break;
                }
                case 1908090253: {
                    this.shiftCurve = (Curve)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public DirectIborCapletFloorletVolatilityDefinition build() {
            return new DirectIborCapletFloorletVolatilityDefinition(this.name, this.index, this.dayCount, this.lambdaExpiry, this.lambdaStrike, this.interpolator, this.shiftCurve);
        }

        public Builder name(IborCapletFloorletVolatilitiesName name) {
            JodaBeanUtils.notNull((Object)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder index(IborIndex index) {
            JodaBeanUtils.notNull((Object)index, (String)"index");
            this.index = index;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder lambdaExpiry(double lambdaExpiry) {
            ArgChecker.notNegative((double)lambdaExpiry, (String)"lambdaExpiry");
            this.lambdaExpiry = lambdaExpiry;
            return this;
        }

        public Builder lambdaStrike(double lambdaStrike) {
            ArgChecker.notNegative((double)lambdaStrike, (String)"lambdaStrike");
            this.lambdaStrike = lambdaStrike;
            return this;
        }

        public Builder interpolator(GridSurfaceInterpolator interpolator) {
            JodaBeanUtils.notNull((Object)interpolator, (String)"interpolator");
            this.interpolator = interpolator;
            return this;
        }

        public Builder shiftCurve(Curve shiftCurve) {
            this.shiftCurve = shiftCurve;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            buf.append("DirectIborCapletFloorletVolatilityDefinition.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("lambdaExpiry").append('=').append(JodaBeanUtils.toString((Object)this.lambdaExpiry)).append(',').append(' ');
            buf.append("lambdaStrike").append('=').append(JodaBeanUtils.toString((Object)this.lambdaStrike)).append(',').append(' ');
            buf.append("interpolator").append('=').append(JodaBeanUtils.toString((Object)this.interpolator)).append(',').append(' ');
            buf.append("shiftCurve").append('=').append(JodaBeanUtils.toString((Object)this.shiftCurve));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<IborCapletFloorletVolatilitiesName> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", DirectIborCapletFloorletVolatilityDefinition.class, IborCapletFloorletVolatilitiesName.class);
        private final MetaProperty<IborIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", DirectIborCapletFloorletVolatilityDefinition.class, IborIndex.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", DirectIborCapletFloorletVolatilityDefinition.class, DayCount.class);
        private final MetaProperty<Double> lambdaExpiry = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"lambdaExpiry", DirectIborCapletFloorletVolatilityDefinition.class, Double.TYPE);
        private final MetaProperty<Double> lambdaStrike = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"lambdaStrike", DirectIborCapletFloorletVolatilityDefinition.class, Double.TYPE);
        private final MetaProperty<GridSurfaceInterpolator> interpolator = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"interpolator", DirectIborCapletFloorletVolatilityDefinition.class, GridSurfaceInterpolator.class);
        private final MetaProperty<Curve> shiftCurve = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"shiftCurve", DirectIborCapletFloorletVolatilityDefinition.class, Curve.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "index", "dayCount", "lambdaExpiry", "lambdaStrike", "interpolator", "shiftCurve"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 100346066: {
                    return this.index;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -1966011430: {
                    return this.lambdaExpiry;
                }
                case -1568838055: {
                    return this.lambdaStrike;
                }
                case 2096253127: {
                    return this.interpolator;
                }
                case 1908090253: {
                    return this.shiftCurve;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends DirectIborCapletFloorletVolatilityDefinition> beanType() {
            return DirectIborCapletFloorletVolatilityDefinition.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<IborCapletFloorletVolatilitiesName> name() {
            return this.name;
        }

        public MetaProperty<IborIndex> index() {
            return this.index;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<Double> lambdaExpiry() {
            return this.lambdaExpiry;
        }

        public MetaProperty<Double> lambdaStrike() {
            return this.lambdaStrike;
        }

        public MetaProperty<GridSurfaceInterpolator> interpolator() {
            return this.interpolator;
        }

        public MetaProperty<Curve> shiftCurve() {
            return this.shiftCurve;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((DirectIborCapletFloorletVolatilityDefinition)bean).getName();
                }
                case 100346066: {
                    return ((DirectIborCapletFloorletVolatilityDefinition)bean).getIndex();
                }
                case 1905311443: {
                    return ((DirectIborCapletFloorletVolatilityDefinition)bean).getDayCount();
                }
                case -1966011430: {
                    return ((DirectIborCapletFloorletVolatilityDefinition)bean).getLambdaExpiry();
                }
                case -1568838055: {
                    return ((DirectIborCapletFloorletVolatilityDefinition)bean).getLambdaStrike();
                }
                case 2096253127: {
                    return ((DirectIborCapletFloorletVolatilityDefinition)bean).getInterpolator();
                }
                case 1908090253: {
                    return ((DirectIborCapletFloorletVolatilityDefinition)bean).shiftCurve;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

