/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.product.capfloor.IborCapletFloorletPeriod;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class IborCapletFloorletPeriodCurrencyAmounts
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<IborCapletFloorletPeriod, CurrencyAmount> amounts;
    private static final long serialVersionUID = 1L;

    public static IborCapletFloorletPeriodCurrencyAmounts of(Map<IborCapletFloorletPeriod, CurrencyAmount> currencyAmountMap) {
        return new IborCapletFloorletPeriodCurrencyAmounts(currencyAmountMap);
    }

    public Optional<CurrencyAmount> findAmount(IborCapletFloorletPeriod period) {
        return Optional.ofNullable(this.amounts.get((Object)period));
    }

    public CurrencyAmount getAmount(IborCapletFloorletPeriod period) {
        if (!this.amounts.containsKey((Object)period)) {
            throw new IllegalArgumentException("Could not find currency amount for " + period);
        }
        return (CurrencyAmount)this.amounts.get((Object)period);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private IborCapletFloorletPeriodCurrencyAmounts(Map<IborCapletFloorletPeriod, CurrencyAmount> amounts) {
        JodaBeanUtils.notNull(amounts, (String)"amounts");
        this.amounts = ImmutableMap.copyOf(amounts);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ImmutableMap<IborCapletFloorletPeriod, CurrencyAmount> getAmounts() {
        return this.amounts;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IborCapletFloorletPeriodCurrencyAmounts other = (IborCapletFloorletPeriodCurrencyAmounts)obj;
            return JodaBeanUtils.equal(this.amounts, other.amounts);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.amounts);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("IborCapletFloorletPeriodCurrencyAmounts{");
        buf.append("amounts").append('=').append(JodaBeanUtils.toString(this.amounts));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<IborCapletFloorletPeriodCurrencyAmounts> {
        private Map<IborCapletFloorletPeriod, CurrencyAmount> amounts = ImmutableMap.of();

        private Builder() {
        }

        private Builder(IborCapletFloorletPeriodCurrencyAmounts beanToCopy) {
            this.amounts = beanToCopy.getAmounts();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -879772901: {
                    return this.amounts;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -879772901: {
                    this.amounts = (Map)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public IborCapletFloorletPeriodCurrencyAmounts build() {
            return new IborCapletFloorletPeriodCurrencyAmounts(this.amounts);
        }

        public Builder amounts(Map<IborCapletFloorletPeriod, CurrencyAmount> amounts) {
            JodaBeanUtils.notNull(amounts, (String)"amounts");
            this.amounts = amounts;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("IborCapletFloorletPeriodCurrencyAmounts.Builder{");
            buf.append("amounts").append('=').append(JodaBeanUtils.toString(this.amounts));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableMap<IborCapletFloorletPeriod, CurrencyAmount>> amounts = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"amounts", IborCapletFloorletPeriodCurrencyAmounts.class, ImmutableMap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"amounts"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -879772901: {
                    return this.amounts;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends IborCapletFloorletPeriodCurrencyAmounts> beanType() {
            return IborCapletFloorletPeriodCurrencyAmounts.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableMap<IborCapletFloorletPeriod, CurrencyAmount>> amounts() {
            return this.amounts;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -879772901: {
                    return ((IborCapletFloorletPeriodCurrencyAmounts)bean).getAmounts();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

