/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.market.MarketDataView;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.ParameterizedData;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilitiesName;
import com.opengamma.strata.product.common.PutCall;
import java.time.LocalDate;
import java.time.ZonedDateTime;

public interface IborCapletFloorletVolatilities
extends MarketDataView,
ParameterizedData {
    public IborCapletFloorletVolatilitiesName getName();

    public IborIndex getIndex();

    public ValueType getVolatilityType();

    default public LocalDate getValuationDate() {
        return this.getValuationDateTime().toLocalDate();
    }

    public ZonedDateTime getValuationDateTime();

    public IborCapletFloorletVolatilities withParameter(int var1, double var2);

    public IborCapletFloorletVolatilities withPerturbation(ParameterPerturbation var1);

    default public double volatility(ZonedDateTime expiryDateTime, double strike, double forward) {
        return this.volatility(this.relativeTime(expiryDateTime), strike, forward);
    }

    public double volatility(double var1, double var3, double var5);

    default public CurrencyParameterSensitivities parameterSensitivity(PointSensitivity ... pointSensitivities) {
        return this.parameterSensitivity(PointSensitivities.of((PointSensitivity[])pointSensitivities));
    }

    public CurrencyParameterSensitivities parameterSensitivity(PointSensitivities var1);

    public double price(double var1, PutCall var3, double var4, double var6, double var8);

    public double priceDelta(double var1, PutCall var3, double var4, double var6, double var8);

    public double priceGamma(double var1, PutCall var3, double var4, double var6, double var8);

    public double priceTheta(double var1, PutCall var3, double var4, double var6, double var8);

    public double priceVega(double var1, PutCall var3, double var4, double var6, double var8);

    public double relativeTime(ZonedDateTime var1);
}

