/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.surface.Surface;
import com.opengamma.strata.market.surface.SurfaceInfoType;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletSensitivity;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilitiesName;
import com.opengamma.strata.pricer.capfloor.NormalIborCapletFloorletVolatilities;
import com.opengamma.strata.pricer.impl.option.NormalFormulaRepository;
import com.opengamma.strata.product.common.PutCall;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalInt;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class NormalIborCapletFloorletExpiryStrikeVolatilities
implements NormalIborCapletFloorletVolatilities,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborIndex index;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ZonedDateTime valuationDateTime;
    @PropertyDefinition(validate="notNull")
    private final Surface surface;
    private final transient DayCount dayCount;
    private static final long serialVersionUID = 1L;

    public static NormalIborCapletFloorletExpiryStrikeVolatilities of(IborIndex index, ZonedDateTime valuationDateTime, Surface surface) {
        return new NormalIborCapletFloorletExpiryStrikeVolatilities(index, valuationDateTime, surface);
    }

    @ImmutableConstructor
    private NormalIborCapletFloorletExpiryStrikeVolatilities(IborIndex index, ZonedDateTime valuationDateTime, Surface surface) {
        ArgChecker.notNull((Object)index, (String)"index");
        ArgChecker.notNull((Object)valuationDateTime, (String)"valuationDateTime");
        ArgChecker.notNull((Object)surface, (String)"surface");
        surface.getMetadata().getXValueType().checkEquals(ValueType.YEAR_FRACTION, "Incorrect x-value type for Normal volatilities");
        surface.getMetadata().getYValueType().checkEquals(ValueType.STRIKE, "Incorrect y-value type for Normal volatilities");
        surface.getMetadata().getZValueType().checkEquals(ValueType.NORMAL_VOLATILITY, "Incorrect z-value type for Normal volatilities");
        DayCount dayCount = (DayCount)surface.getMetadata().findInfo(SurfaceInfoType.DAY_COUNT).orElseThrow(() -> new IllegalArgumentException("Incorrect surface metadata, missing DayCount"));
        this.index = index;
        this.valuationDateTime = valuationDateTime;
        this.surface = surface;
        this.dayCount = dayCount;
    }

    private Object readResolve() {
        return new NormalIborCapletFloorletExpiryStrikeVolatilities(this.index, this.valuationDateTime, this.surface);
    }

    @Override
    public IborCapletFloorletVolatilitiesName getName() {
        return IborCapletFloorletVolatilitiesName.of(this.surface.getName().getName());
    }

    public <T> Optional<T> findData(MarketDataName<T> name) {
        if (this.surface.getName().equals(name)) {
            return Optional.of(name.getMarketDataType().cast(this.surface));
        }
        return Optional.empty();
    }

    public int getParameterCount() {
        return this.surface.getParameterCount();
    }

    public double getParameter(int parameterIndex) {
        return this.surface.getParameter(parameterIndex);
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.surface.getParameterMetadata(parameterIndex);
    }

    public OptionalInt findParameterIndex(ParameterMetadata metadata) {
        return this.surface.findParameterIndex(metadata);
    }

    @Override
    public NormalIborCapletFloorletExpiryStrikeVolatilities withParameter(int parameterIndex, double newValue) {
        return new NormalIborCapletFloorletExpiryStrikeVolatilities(this.index, this.valuationDateTime, this.surface.withParameter(parameterIndex, newValue));
    }

    @Override
    public NormalIborCapletFloorletExpiryStrikeVolatilities withPerturbation(ParameterPerturbation perturbation) {
        return new NormalIborCapletFloorletExpiryStrikeVolatilities(this.index, this.valuationDateTime, this.surface.withPerturbation(perturbation));
    }

    @Override
    public double volatility(double expiry, double strike, double forward) {
        return this.surface.zValue(expiry, strike);
    }

    @Override
    public CurrencyParameterSensitivities parameterSensitivity(PointSensitivities pointSensitivities) {
        CurrencyParameterSensitivities sens = CurrencyParameterSensitivities.empty();
        for (PointSensitivity point : pointSensitivities.getSensitivities()) {
            IborCapletFloorletSensitivity pt;
            if (!(point instanceof IborCapletFloorletSensitivity) || !(pt = (IborCapletFloorletSensitivity)point).getVolatilitiesName().equals(this.getName())) continue;
            sens = sens.combinedWith(this.parameterSensitivity(pt));
        }
        return sens;
    }

    private CurrencyParameterSensitivity parameterSensitivity(IborCapletFloorletSensitivity point) {
        double expiry = point.getExpiry();
        double strike = point.getStrike();
        UnitParameterSensitivity unitSens = this.surface.zValueParameterSensitivity(expiry, strike);
        return unitSens.multipliedBy(point.getCurrency(), point.getSensitivity());
    }

    @Override
    public double price(double expiry, PutCall putCall, double strike, double forward, double volatility) {
        return NormalFormulaRepository.price(forward, strike, expiry, volatility, putCall);
    }

    @Override
    public double priceDelta(double expiry, PutCall putCall, double strike, double forward, double volatility) {
        return NormalFormulaRepository.delta(forward, strike, expiry, volatility, putCall);
    }

    @Override
    public double priceGamma(double expiry, PutCall putCall, double strike, double forward, double volatility) {
        return NormalFormulaRepository.gamma(forward, strike, expiry, volatility, putCall);
    }

    @Override
    public double priceTheta(double expiry, PutCall putCall, double strike, double forward, double volatility) {
        return NormalFormulaRepository.theta(forward, strike, expiry, volatility, putCall);
    }

    @Override
    public double priceVega(double expiry, PutCall putCall, double strike, double forward, double volatility) {
        return NormalFormulaRepository.vega(forward, strike, expiry, volatility, putCall);
    }

    @Override
    public double relativeTime(ZonedDateTime dateTime) {
        ArgChecker.notNull((Object)dateTime, (String)"dateTime");
        LocalDate valuationDate = this.valuationDateTime.toLocalDate();
        LocalDate date = dateTime.toLocalDate();
        return this.dayCount.relativeYearFraction(valuationDate, date);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public IborIndex getIndex() {
        return this.index;
    }

    @Override
    public ZonedDateTime getValuationDateTime() {
        return this.valuationDateTime;
    }

    public Surface getSurface() {
        return this.surface;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            NormalIborCapletFloorletExpiryStrikeVolatilities other = (NormalIborCapletFloorletExpiryStrikeVolatilities)obj;
            return JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.valuationDateTime, (Object)other.valuationDateTime) && JodaBeanUtils.equal((Object)this.surface, (Object)other.surface);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.valuationDateTime);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.surface);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("NormalIborCapletFloorletExpiryStrikeVolatilities{");
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("valuationDateTime").append('=').append(JodaBeanUtils.toString((Object)this.valuationDateTime)).append(',').append(' ');
        buf.append("surface").append('=').append(JodaBeanUtils.toString((Object)this.surface));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<NormalIborCapletFloorletExpiryStrikeVolatilities> {
        private IborIndex index;
        private ZonedDateTime valuationDateTime;
        private Surface surface;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case -949589828: {
                    return this.valuationDateTime;
                }
                case -1853231955: {
                    return this.surface;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    this.index = (IborIndex)newValue;
                    break;
                }
                case -949589828: {
                    this.valuationDateTime = (ZonedDateTime)newValue;
                    break;
                }
                case -1853231955: {
                    this.surface = (Surface)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public NormalIborCapletFloorletExpiryStrikeVolatilities build() {
            return new NormalIborCapletFloorletExpiryStrikeVolatilities(this.index, this.valuationDateTime, this.surface);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("NormalIborCapletFloorletExpiryStrikeVolatilities.Builder{");
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("valuationDateTime").append('=').append(JodaBeanUtils.toString((Object)this.valuationDateTime)).append(',').append(' ');
            buf.append("surface").append('=').append(JodaBeanUtils.toString((Object)this.surface));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<IborIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", NormalIborCapletFloorletExpiryStrikeVolatilities.class, IborIndex.class);
        private final MetaProperty<ZonedDateTime> valuationDateTime = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valuationDateTime", NormalIborCapletFloorletExpiryStrikeVolatilities.class, ZonedDateTime.class);
        private final MetaProperty<Surface> surface = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"surface", NormalIborCapletFloorletExpiryStrikeVolatilities.class, Surface.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"index", "valuationDateTime", "surface"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case -949589828: {
                    return this.valuationDateTime;
                }
                case -1853231955: {
                    return this.surface;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends NormalIborCapletFloorletExpiryStrikeVolatilities> builder() {
            return new Builder();
        }

        public Class<? extends NormalIborCapletFloorletExpiryStrikeVolatilities> beanType() {
            return NormalIborCapletFloorletExpiryStrikeVolatilities.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<IborIndex> index() {
            return this.index;
        }

        public MetaProperty<ZonedDateTime> valuationDateTime() {
            return this.valuationDateTime;
        }

        public MetaProperty<Surface> surface() {
            return this.surface;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return ((NormalIborCapletFloorletExpiryStrikeVolatilities)bean).getIndex();
                }
                case -949589828: {
                    return ((NormalIborCapletFloorletExpiryStrikeVolatilities)bean).getValuationDateTime();
                }
                case -1853231955: {
                    return ((NormalIborCapletFloorletExpiryStrikeVolatilities)bean).getSurface();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

