/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.capfloor.SabrIborCapletFloorletPeriodPricer;
import com.opengamma.strata.pricer.capfloor.SabrIborCapletFloorletVolatilities;
import com.opengamma.strata.pricer.capfloor.VolatilityIborCapFloorLegPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.capfloor.IborCapletFloorletPeriod;
import com.opengamma.strata.product.capfloor.ResolvedIborCapFloorLeg;

public class SabrIborCapFloorLegPricer
extends VolatilityIborCapFloorLegPricer {
    public static final SabrIborCapFloorLegPricer DEFAULT = new SabrIborCapFloorLegPricer(SabrIborCapletFloorletPeriodPricer.DEFAULT);
    private final SabrIborCapletFloorletPeriodPricer periodPricer;

    public SabrIborCapFloorLegPricer(SabrIborCapletFloorletPeriodPricer periodPricer) {
        super(periodPricer);
        this.periodPricer = periodPricer;
    }

    public PointSensitivityBuilder presentValueSensitivityRatesStickyModel(ResolvedIborCapFloorLeg capFloorLeg, RatesProvider ratesProvider, SabrIborCapletFloorletVolatilities volatilities) {
        this.validate(ratesProvider, volatilities);
        return capFloorLeg.getCapletFloorletPeriods().stream().map(period -> this.periodPricer.presentValueSensitivityRatesStickyModel((IborCapletFloorletPeriod)period, ratesProvider, volatilities)).reduce((c1, c2) -> c1.combinedWith(c2)).get();
    }

    public PointSensitivityBuilder presentValueSensitivityModelParamsSabr(ResolvedIborCapFloorLeg capFloorLeg, RatesProvider ratesProvider, SabrIborCapletFloorletVolatilities volatilities) {
        this.validate(ratesProvider, volatilities);
        return capFloorLeg.getCapletFloorletPeriods().stream().map(period -> this.periodPricer.presentValueSensitivityModelParamsSabr((IborCapletFloorletPeriod)period, ratesProvider, volatilities)).reduce((c1, c2) -> c1.combinedWith(c2)).get();
    }
}

